/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.user_facing.huds.hud;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Predicate;
import net.dark_roleplay.travellers_map.configs.client.HudConfig;
import net.dark_roleplay.travellers_map.user_facing.huds.GuiAlignment;
import net.dark_roleplay.travellers_map.user_facing.huds.hud.Hud;

public class HudHelper {
    private Hud hud;
    private HudConfig config;
    private Predicate<Void>[] predicates;

    public HudHelper(Hud hud, Predicate<Void> ... predicates) {
        this.hud = hud;
        this.config = hud.config;
        this.predicates = predicates;
    }

    public void render(MatrixStack matrix, int width, int height, float partialTicks) {
        if (!this.shouldRender()) {
            return;
        }
        RenderSystem.pushMatrix();
        int posX = this.config == null ? 0 : ((GuiAlignment)((Object)this.config.ALIGNMENT.get())).getX(width) + (Integer)this.config.POS_X.get();
        int posY = this.config == null ? 0 : ((GuiAlignment)((Object)this.config.ALIGNMENT.get())).getY(height) + (Integer)this.config.POS_Y.get();
        RenderSystem.translatef((float)posX, (float)posY, (float)0.0f);
        this.hud.setWindowSize(width, height);
        this.hud.render(matrix, 0, 0, partialTicks);
        RenderSystem.popMatrix();
    }

    private boolean shouldRender() {
        if (this.config != null && !((Boolean)this.config.VISIBLE.get()).booleanValue()) {
            return false;
        }
        for (Predicate<Void> predicate : this.predicates) {
            if (predicate.test(null)) continue;
            return false;
        }
        return true;
    }
}

