/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.user_facing.huds.minimap;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.dark_roleplay.travellers_map.configs.ClientConfig;
import net.dark_roleplay.travellers_map.objects.style.HudStyle;
import net.dark_roleplay.travellers_map.objects.style.HudStyleProvider;
import net.dark_roleplay.travellers_map.rendering.MapRenderInfo;
import net.dark_roleplay.travellers_map.rendering.MapRenderer;
import net.dark_roleplay.travellers_map.rendering.MapType;
import net.dark_roleplay.travellers_map.user_facing.huds.hud.Hud;
import net.dark_roleplay.travellers_map.user_facing.screens.full_map.FullMapScreen;
import net.dark_roleplay.travellers_map.util.BlendBlitHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;

public class MinimapHUD
extends Hud {
    public static final MinimapHUD INSTANCE = new MinimapHUD();
    private float[] zoomLevels = new float[]{0.25f, 0.5f, 1.0f, 2.0f};
    private int currentZoomLevel = 1;
    private MapRenderInfo mapRenderInfo = new MapRenderInfo();

    private MinimapHUD() {
        super(ClientConfig.MINIMAP, "hud.travellers_map.minimap", new HudStyleProvider(ClientConfig.MINIMAP, new HudStyle("Default", 64, 64, "travellers_map:textures/styles/minimap/default_mask.png", "travellers_map:textures/styles/minimap/default_overlay.png")));
    }

    @Override
    public void render(MatrixStack matrix, int mouseX, int mouseY, float delta) {
        if (Minecraft.func_71410_x().field_71462_r instanceof FullMapScreen) {
            return;
        }
        this.renderOverlay(matrix);
        this.renderMap(matrix, delta);
    }

    private void renderOverlay(MatrixStack matrix) {
        HudStyle style = this.getStyleProvider().getActiveStyle();
        RenderSystem.pushMatrix();
        RenderSystem.scaled((double)((Double)ClientConfig.MINIMAP.SCALE.get()), (double)((Double)ClientConfig.MINIMAP.SCALE.get()), (double)1.0);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(style.getOverlay());
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableAlphaTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BlendBlitHelper.blit(0.0, 0.0, style.getWidth(), style.getHeight(), 0.0f, 0.0f, 1, 1, 1, 1);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MatrixStack stack = new MatrixStack();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(style.getMask());
        RenderSystem.enableDepthTest();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)950.0f);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        MinimapHUD.func_238467_a_((MatrixStack)stack, (int)4680, (int)2260, (int)-4680, (int)-2260, (int)-1);
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-950.0f);
        RenderSystem.depthFunc((int)518);
        MinimapHUD.func_238466_a_((MatrixStack)stack, (int)0, (int)0, (int)style.getWidth(), (int)style.getHeight(), (float)0.0f, (float)0.0f, (int)1, (int)1, (int)1, (int)1);
        RenderSystem.depthFunc((int)515);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    private void renderMap(MatrixStack matrix, float delta) {
        HudStyle style = this.getStyleProvider().getActiveStyle();
        MatrixStack stack = new MatrixStack();
        BlockPos playerPos = Minecraft.func_71410_x().field_71439_g.func_233580_cy_();
        this.mapRenderInfo.update(style.getWidth(), style.getHeight(), this.zoomLevels[this.currentZoomLevel], playerPos);
        MapRenderer.renderMap(matrix, this.mapRenderInfo, MapType.MINIMAP, (Boolean)ClientConfig.SPIN_MINIMAP.get(), delta);
        RenderSystem.translatef((float)(style.getWidth() / 2), (float)(style.getHeight() / 2), (float)0.0f);
        RenderSystem.depthFunc((int)518);
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-950.0f);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        MinimapHUD.func_238467_a_((MatrixStack)stack, (int)4680, (int)2260, (int)-4680, (int)-2260, (int)-16777216);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.depthFunc((int)515);
        RenderSystem.popMatrix();
    }

    public static void increaseZoom() {
        MinimapHUD.INSTANCE.currentZoomLevel = Math.min(MinimapHUD.INSTANCE.zoomLevels.length - 1, MinimapHUD.INSTANCE.currentZoomLevel + 1);
    }

    public static void decreaseZoom() {
        MinimapHUD.INSTANCE.currentZoomLevel = Math.max(0, MinimapHUD.INSTANCE.currentZoomLevel - 1);
    }
}

