/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.user_facing.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.dark_roleplay.travellers_map.objects.style.HudStyle;
import net.dark_roleplay.travellers_map.objects.style.HudStyleProvider;
import net.dark_roleplay.travellers_map.util.BlendBlitHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class StyleChoser
extends Screen {
    private HudStyleProvider styleProvider;
    private int xOffset;
    private int currentStyle;
    private List<HudStyle> styles;
    private Button setStyleBtn;

    public StyleChoser(int xOffset, HudStyleProvider styleProvider) {
        super((ITextComponent)new TranslationTextComponent("travellers_map.style_chooser"));
        this.xOffset = xOffset;
        this.styleProvider = styleProvider;
        this.styles = new ArrayList<HudStyle>(styleProvider.getStyles());
        this.currentStyle = this.styles.indexOf(styleProvider.getActiveStyle());
    }

    public void func_231160_c_() {
        int trueWidth = this.field_230708_k_ - this.xOffset;
        int centerX = this.field_230708_k_ / 2;
        if (centerX - 100 < this.xOffset) {
            centerX += this.xOffset - (centerX - 100);
        }
        this.setStyleBtn = new Button(centerX - Math.min(100, trueWidth / 2), this.field_230709_l_ - 30, Math.min(200, trueWidth), 20, (ITextComponent)new StringTextComponent("SELECT"), btn -> {
            this.styleProvider.setActiveStyle(this.styles.get(this.currentStyle));
            this.setStyleBtn.field_230693_o_ = false;
        });
        this.func_230480_a_((Widget)this.setStyleBtn);
        this.setStyleBtn.field_230693_o_ = this.styles.get(this.currentStyle) != this.styleProvider.getActiveStyle();
        this.func_230480_a_((Widget)new Button(centerX - Math.min(100, trueWidth / 2), 10, 20, 20, (ITextComponent)new StringTextComponent("<"), btn -> {
            this.currentStyle = this.currentStyle > 0 ? this.currentStyle - 1 : this.styles.size() - 1;
            this.setStyleBtn.field_230693_o_ = this.styles.get(this.currentStyle) != this.styleProvider.getActiveStyle();
        }));
        this.func_230480_a_((Widget)new Button(centerX + Math.min(90, trueWidth / 2 - 10), 10, 20, 20, (ITextComponent)new StringTextComponent(">"), btn -> {
            this.currentStyle = this.currentStyle < this.styles.size() - 1 ? this.currentStyle + 1 : 0;
            this.setStyleBtn.field_230693_o_ = this.styles.get(this.currentStyle) != this.styleProvider.getActiveStyle();
        }));
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float delta) {
        int centerX = this.field_230708_k_ / 2;
        if (centerX - 100 < this.xOffset) {
            centerX += this.xOffset - (centerX - 100);
        }
        int centerY = this.field_230709_l_ / 2;
        this.func_230446_a_(matrix);
        super.func_230430_a_(matrix, mouseX, mouseY, delta);
        HudStyle currentStyle = this.styles.get(this.currentStyle);
        StyleChoser.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)currentStyle.getStyleName(), (int)centerX, (int)16, (int)-1);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(currentStyle.getOverlay());
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableAlphaTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BlendBlitHelper.blit(centerX - currentStyle.getWidth() / 2, centerY - currentStyle.getHeight() / 2, currentStyle.getWidth(), currentStyle.getHeight(), 0.0f, 0.0f, 1, 1, 1, 1);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
    }
}

