/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.user_facing.screens.full_map;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.dark_roleplay.travellers_map.rendering.MapRenderInfo;
import net.dark_roleplay.travellers_map.rendering.MapRenderer;
import net.dark_roleplay.travellers_map.rendering.MapType;
import net.dark_roleplay.travellers_map.user_facing.screens.SidePanelButton;
import net.dark_roleplay.travellers_map.user_facing.screens.full_map.SettingsButton;
import net.dark_roleplay.travellers_map.user_facing.screens.minimap.settings.MinimapSettingsScreen;
import net.dark_roleplay.travellers_map.user_facing.screens.waypoints.WayPointCreationScreen;
import net.dark_roleplay.travellers_map.user_facing.screens.waypoints.WaypointScrollPanel;
import net.dark_roleplay.travellers_map.util.Wrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class FullMapScreen
extends Screen {
    public static ResourceLocation FULL_MAP_TEXTURES = new ResourceLocation("travellers_map", "textures/guis/full_map.png");
    private float xOffset = 0.0f;
    private float zOffset = 0.0f;
    private int currentZoomLevel = 1;
    private MapRenderInfo mapRenderInfo = new MapRenderInfo();
    private Wrapper<Boolean> isWaypointListOpen = new Wrapper<Boolean>(false);
    private WaypointScrollPanel scrollPanel;
    private float[] zoomLevels = new float[]{2.0f, 1.0f, 0.5f, 0.25f};

    public FullMapScreen() {
        super((ITextComponent)new TranslationTextComponent("screen.travellers_map.full_map"));
    }

    protected void func_231160_c_() {
        this.scrollPanel = new WaypointScrollPanel(this.field_230706_i_, this, 118, this.field_230709_l_ - 35, 5, 5);
        Button waypointButton = new Button(5, this.field_230709_l_ - 25, 118, 20, (ITextComponent)new TranslationTextComponent("New Waypoint"), button -> this.field_230706_i_.func_147108_a((Screen)new WayPointCreationScreen(this, null)));
        this.func_230480_a_((Widget)new SettingsButton(this.field_230708_k_ - 13, 1, btn -> Minecraft.func_71410_x().func_147108_a((Screen)new MinimapSettingsScreen(this))));
        this.func_230480_a_((Widget)new SidePanelButton(this.isWaypointListOpen.get() != false ? 125 : -2, (this.field_230709_l_ - 23) / 2, this.isWaypointListOpen, btn -> {
            if (this.isWaypointListOpen.get().booleanValue()) {
                this.field_230705_e_.add(this.scrollPanel);
                this.func_230480_a_((Widget)waypointButton);
                btn.field_230690_l_ = 125;
            } else {
                this.field_230710_m_.remove((Object)this.scrollPanel);
                btn.field_230690_l_ = -2;
                this.field_230710_m_.remove(waypointButton);
                this.field_230710_m_.remove(waypointButton);
            }
        }));
        if (this.isWaypointListOpen.get().booleanValue()) {
            this.field_230705_e_.add(this.scrollPanel);
            this.func_230480_a_((Widget)waypointButton);
        }
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float delta) {
        this.func_231165_f_(0);
        BlockPos playerPos = Minecraft.func_71410_x().field_71439_g.func_233580_cy_();
        this.mapRenderInfo.update(this.field_230708_k_, this.field_230709_l_, 1.0f / this.zoomLevels[this.currentZoomLevel], playerPos.func_177963_a((double)this.xOffset, 0.0, (double)this.zOffset), mouseX, mouseY);
        MapRenderer.renderMap(matrix, this.mapRenderInfo, MapType.FULL_MAP, false, delta);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(FULL_MAP_TEXTURES);
        if (this.isWaypointListOpen.get().booleanValue()) {
            FullMapScreen.func_238466_a_((MatrixStack)matrix, (int)0, (int)0, (int)128, (int)this.field_230709_l_, (float)0.0f, (float)0.0f, (int)128, (int)256, (int)256, (int)256);
            this.scrollPanel.func_230430_a_(matrix, mouseX, mouseY, delta);
        }
        super.func_230430_a_(matrix, mouseX, mouseY, delta);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int mouseButton, double deltaX, double deltaY) {
        boolean success = super.func_231045_a_(mouseX, mouseY, mouseButton, deltaX, deltaY);
        if (success || mouseButton != 0) {
            return success;
        }
        this.xOffset = (float)((double)this.xOffset - deltaX * (double)this.zoomLevels[this.currentZoomLevel]);
        this.zOffset = (float)((double)this.zOffset - deltaY * (double)this.zoomLevels[this.currentZoomLevel]);
        return true;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scroll) {
        boolean success = super.func_231043_a_(mouseX, mouseY, scroll);
        if (success) {
            return success;
        }
        if (scroll > 0.0) {
            this.increaseZoom();
        } else if (scroll < 0.0) {
            this.decreaseZoom();
        }
        return true;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int btn) {
        boolean result = super.func_231044_a_(mouseX, mouseY, btn);
        if (result || btn == 0) {
            return result;
        }
        BlockPos playerPos = Minecraft.func_71410_x().field_71439_g.func_233580_cy_().func_177963_a((double)this.xOffset, 0.0, (double)this.zOffset);
        double worldX = (double)playerPos.func_177958_n() + (mouseX - (double)(this.field_230708_k_ / 2)) / (double)this.zoomLevels[this.currentZoomLevel];
        double worldZ = (double)playerPos.func_177952_p() + (mouseY - (double)(this.field_230709_l_ / 2)) / (double)this.zoomLevels[this.currentZoomLevel];
        this.xOffset = 0.0f;
        this.zOffset = 0.0f;
        return true;
    }

    public void increaseZoom() {
        if (this.currentZoomLevel < this.zoomLevels.length - 1) {
            ++this.currentZoomLevel;
        }
    }

    public void decreaseZoom() {
        if (this.currentZoomLevel > 0) {
            --this.currentZoomLevel;
        }
    }
}

