/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.user_facing.screens.minimap.settings;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.dark_roleplay.travellers_map.configs.ClientConfig;
import net.dark_roleplay.travellers_map.objects.style.HudStyle;
import net.dark_roleplay.travellers_map.user_facing.huds.GuiAlignment;
import net.dark_roleplay.travellers_map.user_facing.huds.hud.Hud;
import net.dark_roleplay.travellers_map.util.BlendBlitHelper;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class MinimapMover
extends Widget {
    private Hud hud;
    private int posX;
    private int posY;
    private double initOffsetX = 0.0;
    private double initOffsetY = 0.0;
    private double scale = 0.0;

    public MinimapMover(Hud hud) {
        super(0, 0, 200, 20, (ITextComponent)new TranslationTextComponent(hud.getUnlocalizedName() + ".mover"));
        this.hud = hud;
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        GuiAlignment alignment = (GuiAlignment)((Object)ClientConfig.MINIMAP.ALIGNMENT.get());
        this.posX = (Integer)ClientConfig.MINIMAP.POS_X.get() + alignment.getX(window.func_198107_o());
        this.posY = (Integer)ClientConfig.MINIMAP.POS_Y.get() + alignment.getY(window.func_198087_p());
        this.scale = (Double)ClientConfig.MINIMAP.SCALE.get();
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        this.initOffsetX = (double)this.posX - mouseX;
        this.initOffsetY = (double)this.posY - mouseY;
    }

    public void func_230983_a_(double mouseX, double mouseY, double deltaX, double deltaY) {
        HudStyle style = this.hud.getStyleProvider().getActiveStyle();
        this.posX = (int)Math.min(Math.max(0.0, mouseX + this.initOffsetX), (double)Minecraft.func_71410_x().func_228018_at_().func_198107_o() - Math.floor((double)style.getWidth() * this.scale));
        this.posY = (int)Math.min(Math.max(0.0, mouseY + this.initOffsetY), (double)Minecraft.func_71410_x().func_228018_at_().func_198087_p() - Math.floor((double)style.getHeight() * this.scale));
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        this.scale = Math.max(0.25, Math.min(4.0, this.scale + delta * 0.1));
        return true;
    }

    public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float delta) {
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        HudStyle style = this.hud.getStyleProvider().getActiveStyle();
        this.field_230688_j_ = (int)((double)style.getWidth() * this.scale);
        this.field_230689_k_ = (int)((double)style.getWidth() * this.scale);
        this.field_230690_l_ = this.posX;
        this.field_230691_m_ = this.posY;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)this.field_230690_l_, (float)this.field_230691_m_, (float)0.0f);
        RenderSystem.scaled((double)this.scale, (double)this.scale, (double)1.0);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(style.getOverlay());
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableAlphaTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BlendBlitHelper.blit(0.0, 0.0, style.getWidth(), style.getHeight(), 0.0f, 0.0f, 1, 1, 1, 1);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.popMatrix();
    }

    public void onClose() {
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        int windowWidth = window.func_198107_o();
        int windowHeight = window.func_198087_p();
        GuiAlignment alignment = this.posX < windowWidth / 3 ? (this.posY < windowHeight / 3 ? GuiAlignment.TOP_LEFT : (this.posY < windowHeight / 3 * 2 ? GuiAlignment.LEFT : GuiAlignment.BOTTOM_LEFT)) : (this.posX < windowWidth / 3 * 2 ? (this.posY < windowHeight / 3 ? GuiAlignment.TOP : (this.posY < windowHeight / 3 * 2 ? GuiAlignment.CENTER : GuiAlignment.BOTTOM)) : (this.posY < windowHeight / 3 ? GuiAlignment.TOP_RIGHT : (this.posY < windowHeight / 3 * 2 ? GuiAlignment.RIGHT : GuiAlignment.BOTTOM_RIGHT)));
        int newX = this.posX - alignment.getX(window.func_198107_o());
        int newY = this.posY - alignment.getY(window.func_198087_p());
        ClientConfig.MINIMAP.SCALE.set((Object)this.scale);
        ClientConfig.MINIMAP.ALIGNMENT.set((Object)alignment);
        ClientConfig.MINIMAP.POS_X.set((Object)newX);
        ClientConfig.MINIMAP.POS_Y.set((Object)newY);
    }
}

