/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.user_facing.screens.minimap.settings;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.dark_roleplay.travellers_map.TravellersMap;
import net.dark_roleplay.travellers_map.objects.style.HudStyle;
import net.dark_roleplay.travellers_map.user_facing.huds.hud.Hud;
import net.dark_roleplay.travellers_map.util.BlendBlitHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.client.gui.ScrollPanel;

public class StylesPanel
extends ScrollPanel {
    private int spacing = 5;
    private Hud hud;

    public StylesPanel(Minecraft client, int x, int y, int width, int height, Hud hud) {
        super(client, width, height, x, y);
        this.hud = hud;
    }

    protected int getContentHeight() {
        int height = 0;
        for (HudStyle style : this.hud.getStyleProvider().getStyles()) {
            height += style.getHeight() + this.spacing;
        }
        return height;
    }

    protected void drawPanel(MatrixStack matrix, int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
        int offset = 5;
        for (HudStyle style : this.hud.getStyleProvider().getStyles()) {
            int elemTop = (int)((float)(this.top + offset) - this.scrollDistance);
            offset += style.getHeight() + this.spacing;
            if (elemTop + style.getHeight() < this.top || elemTop > this.top + this.height) continue;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(style.getOverlay());
            if (mouseX >= this.left && mouseX <= this.right - 6 && mouseY >= elemTop - 2 && mouseY <= elemTop + style.getHeight() + 2) {
                StylesPanel.func_238467_a_((MatrixStack)matrix, (int)this.left, (int)(elemTop - 2), (int)this.right, (int)(elemTop + style.getHeight() + 2), (int)-14671840);
            }
            BlendBlitHelper.blit(this.left + (this.width - style.getWidth()) / 2, elemTop, style.getWidth(), style.getHeight(), 0.0f, 0.0f, 1, 1, 1, 1);
        }
    }

    protected boolean clickPanel(double mouseX, double mouseY, int button) {
        int offset = 5;
        for (HudStyle style : this.hud.getStyleProvider().getStyles()) {
            int elemTop = (int)((float)(this.top + offset) - this.scrollDistance);
            offset += style.getHeight() + this.spacing;
            if (elemTop + style.getHeight() < this.top || elemTop > this.top + this.height || !(mouseX >= (double)this.left) || !(mouseX <= (double)(this.right - 6)) || !(mouseY >= (double)(elemTop - 2)) || !(mouseY <= (double)(elemTop + style.getHeight() + 2))) continue;
            this.hud.getStyleProvider().setActiveStyle(style);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            TravellersMap.LOG.info("Style set to {}.", (Object)style.getStyleName());
            return true;
        }
        return false;
    }
}

