/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.user_facing.screens.waypoints;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.dark_roleplay.travellers_map.objects.waypoints.Waypoint;
import net.dark_roleplay.travellers_map.user_facing.screens.full_map.FullMapScreen;
import net.dark_roleplay.travellers_map.user_facing.screens.waypoints.WayPointCreationScreen;
import net.dark_roleplay.travellers_map.util.MapManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.client.gui.ScrollPanel;

public class WaypointScrollPanel
extends ScrollPanel {
    private Screen parent;
    private static int elementHeight = 24;

    public WaypointScrollPanel(Minecraft client, Screen parent, int width, int height, int top, int left) {
        super(client, width, height, top, left);
        this.parent = parent;
    }

    protected int getContentHeight() {
        return Math.max(this.height - 4, MapManager.WAYPOINTS.size() * elementHeight);
    }

    protected void drawPanel(MatrixStack matrix, int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
        int offset = 0;
        for (Waypoint waypoint : MapManager.WAYPOINTS) {
            int elemTop = (int)((float)(this.top + 3 + offset) - this.scrollDistance);
            if (elemTop + elementHeight < this.top || elemTop > this.top + this.height) {
                offset += elementHeight;
                continue;
            }
            if (mouseX >= this.left && mouseX <= this.right - 6 && mouseY >= elemTop && mouseY <= elemTop + elementHeight) {
                WaypointScrollPanel.func_238467_a_((MatrixStack)matrix, (int)this.left, (int)elemTop, (int)this.right, (int)(elemTop + elementHeight), (int)-14671840);
            }
            FontRenderer renderer = Minecraft.func_71410_x().field_71466_p;
            renderer.func_238421_b_(matrix, waypoint.getName(), (float)(this.left + 3), (float)(elemTop + 3), waypoint.getColor());
            renderer.func_238421_b_(matrix, String.format("x: %d, y: %d, z: %d", waypoint.getPos().func_177958_n(), waypoint.getPos().func_177956_o(), waypoint.getPos().func_177952_p()), (float)(this.left + 3), (float)(elemTop + 13), -6250336);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(FullMapScreen.FULL_MAP_TEXTURES);
            WaypointScrollPanel.func_238466_a_((MatrixStack)matrix, (int)(this.right - 21), (int)(elemTop + 3), (int)14, (int)7, (float)242.0f, (float)(waypoint.isVisible() ? 0.0f : 7.0f), (int)14, (int)7, (int)256, (int)256);
            offset += elementHeight;
        }
    }

    protected boolean clickPanel(double mouseX, double mouseY, int button) {
        int offset = 0;
        for (Waypoint waypoint : MapManager.WAYPOINTS) {
            int elemTop = offset;
            if (elemTop + elementHeight < this.top || elemTop > this.top + this.height) {
                offset += elementHeight;
                continue;
            }
            if (mouseY >= (double)elemTop && mouseY <= (double)(elemTop + elementHeight)) {
                if (button == 0) {
                    waypoint.toggleVisible();
                } else if (button == 1) {
                    Minecraft.func_71410_x().func_147108_a((Screen)new WayPointCreationScreen(this.parent, waypoint));
                }
                return true;
            }
            offset += elementHeight;
        }
        return true;
    }
}

