/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.util;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.TransformationMatrix;

public class BlendBlitHelper {
    public static void blit(double x0, double y0, int destWidth, int destHeight, float u0, float v0, int srcWidth, int srcHeight, int texWidth, int texHeight) {
        BlendBlitHelper.innerBlit(x0, x0 + (double)destWidth, y0, y0 + (double)destHeight, 0, srcWidth, srcHeight, u0, v0, texWidth, texHeight);
    }

    private static void innerBlit(double x0, double x1, double y0, double y1, int z, int width, int height, float u0, float v0, int texWidth, int texHeight) {
        BlendBlitHelper.innerBlit(x0, x1, y0, y1, z, (u0 + 0.0f) / (float)texWidth, (u0 + (float)width) / (float)texWidth, (v0 + 0.0f) / (float)texHeight, (v0 + (float)height) / (float)texHeight);
    }

    protected static void innerBlit(double x0, double x1, double y0, double y1, int z, float u0, float u1, float v0, float v1) {
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_(x0, y1, (double)z).func_225583_a_(u0, v1).func_181675_d();
        bufferbuilder.func_225582_a_(x1, y1, (double)z).func_225583_a_(u1, v1).func_181675_d();
        bufferbuilder.func_225582_a_(x1, y0, (double)z).func_225583_a_(u1, v0).func_181675_d();
        bufferbuilder.func_225582_a_(x0, y0, (double)z).func_225583_a_(u0, v0).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }

    public static void blitColor(double x0, double y0, int destWidth, int destHeight, float u0, float v0, int srcWidth, int srcHeight, int texWidth, int texHeight, int color) {
        BlendBlitHelper.innerBlitColor(x0, x0 + (double)destWidth, y0, y0 + (double)destHeight, 0, srcWidth, srcHeight, u0, v0, texWidth, texHeight, color);
    }

    private static void innerBlitColor(double x0, double x1, double y0, double y1, int z, int width, int height, float u0, float v0, int texWidth, int texHeight, int color) {
        BlendBlitHelper.innerBlitColor(x0, x1, y0, y1, z, (u0 + 0.0f) / (float)texWidth, (u0 + (float)width) / (float)texWidth, (v0 + 0.0f) / (float)texHeight, (v0 + (float)height) / (float)texHeight, color);
    }

    protected static void innerBlitColor(double x0, double x1, double y0, double y1, int z, float u0, float u1, float v0, float v1, int color) {
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        bufferbuilder.func_225582_a_(x0, y1, (double)z).func_227885_a_(f, f1, f2, f3).func_225583_a_(u0, v1).func_181675_d();
        bufferbuilder.func_225582_a_(x1, y1, (double)z).func_227885_a_(f, f1, f2, f3).func_225583_a_(u1, v1).func_181675_d();
        bufferbuilder.func_225582_a_(x1, y0, (double)z).func_227885_a_(f, f1, f2, f3).func_225583_a_(u1, v0).func_181675_d();
        bufferbuilder.func_225582_a_(x0, y0, (double)z).func_227885_a_(f, f1, f2, f3).func_225583_a_(u0, v0).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }

    public static void vLine(float x, float y1, float y2, int color) {
        BlendBlitHelper.fill(x, y1, x + 1.0f, y2, color);
    }

    public static void fill(float x1, float y1, float x2, float y2, int color) {
        BlendBlitHelper.fill(TransformationMatrix.func_227983_a_().func_227988_c_(), x1, y1, x2, y2, color);
    }

    public static void fill(Matrix4f matrixStack, float x1, float y1, float x2, float y2, int color) {
        if (x1 < x2) {
            float i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            float j = y1;
            y1 = y2;
            y2 = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_227888_a_(matrixStack, x1, y2, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_227888_a_(matrixStack, x2, y2, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_227888_a_(matrixStack, x2, y1, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_227888_a_(matrixStack, x1, y1, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }
}

