/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.util;

import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.dark_roleplay.travellers_map.util.MapManager;
import net.dark_roleplay.travellers_map.util2.DataController;
import net.minecraft.client.Minecraft;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.SaveFormat;

public class MapFileHelper {
    private static File SP_FOLDER;
    private static File MP_FOLDER;
    private static File ACTIVE_FOLDER;
    private static File WAYPOINT_FOLDER;

    public static void setupBaseMapFolder(ResourceLocation dimensionLoc) {
        boolean changedWorld = false;
        if (Minecraft.func_71410_x().func_71387_A()) {
            SaveFormat.LevelSave saveFile = Minecraft.func_71410_x().func_71401_C().field_71310_m;
            File tmpFolder = new File(SP_FOLDER, saveFile.func_237282_a_());
            if (!tmpFolder.equals(ACTIVE_FOLDER)) {
                changedWorld = true;
                ACTIVE_FOLDER = tmpFolder;
            }
        } else {
            InetSocketAddress inet;
            File tmpFolder;
            SocketAddress socket = Minecraft.func_71410_x().func_147114_u().func_147298_b().func_74430_c();
            if (socket instanceof InetSocketAddress && !(tmpFolder = new File(MP_FOLDER, (inet = (InetSocketAddress)socket).getHostName() + "_" + inet.getPort())).equals(ACTIVE_FOLDER)) {
                changedWorld = true;
                ACTIVE_FOLDER = tmpFolder;
            }
        }
        WAYPOINT_FOLDER = new File(ACTIVE_FOLDER, "waypoints");
        WAYPOINT_FOLDER.mkdirs();
        if (changedWorld) {
            DataController.clear();
            MapManager.WAYPOINTS.clear();
            MapManager.loadWaypoints(WAYPOINT_FOLDER);
        }
    }

    public static File getDimFolder(RegistryKey<World> dimension) {
        return new File(ACTIVE_FOLDER, dimension.func_240901_a_().func_110624_b() + "_" + dimension.func_240901_a_().func_110623_a());
    }

    public static File getWaypointFolder() {
        return WAYPOINT_FOLDER;
    }

    static {
        File baseFolder = new File("./mod_data/travellers_map/");
        SP_FOLDER = new File(baseFolder, "singleplayer");
        MP_FOLDER = new File(baseFolder, "multiplayer");
        SP_FOLDER.mkdirs();
        MP_FOLDER.mkdirs();
    }
}

