/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.dark_roleplay.travellers_map.TravellersMap;
import net.dark_roleplay.travellers_map.objects.waypoints.Waypoint;
import net.dark_roleplay.travellers_map.util.MapFileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;

public class MapManager {
    public static final List<Waypoint> WAYPOINTS = new ArrayList<Waypoint>();

    public static void saveWaypoint(Waypoint waypoint, boolean isNew) {
        File waypointFile = new File(MapFileHelper.getWaypointFolder(), waypoint.uuid.toString() + ".waypoint");
        try {
            CompressedStreamTools.func_74795_b((CompoundNBT)waypoint.serializeNBT(), (File)waypointFile);
            if (isNew) {
                WAYPOINTS.add(waypoint);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadWaypoints(File waypointFolder) {
        File[] children;
        for (File file : children = waypointFolder.listFiles()) {
            if (file.isDirectory()) {
                MapManager.loadWaypoints(file);
                continue;
            }
            try {
                TravellersMap.LOG.info("Reading waypoints from {}.", (Object)file.getName());
                Waypoint wp = new Waypoint(UUID.fromString(file.getName().substring(0, file.getName().lastIndexOf(46))));
                wp.deserializeNBT(CompressedStreamTools.func_74797_a((File)file));
                WAYPOINTS.add(wp);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void deleteWaypoint(Waypoint waypoint) {
        File waypointFile = new File(MapFileHelper.getWaypointFolder(), waypoint.uuid.toString() + ".waypoint");
        try {
            if (waypointFile.exists()) {
                Files.delete(waypointFile.toPath());
            }
        }
        catch (IOException e) {
            TravellersMap.LOG.error("Failed to delete waypoint {}.", (Object)waypointFile.getName(), (Object)e);
            e.printStackTrace();
        }
        WAYPOINTS.remove(waypoint);
    }
}

