/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.dark_roleplay.travellers_map.mapping.IMapSegmentTicket;
import net.dark_roleplay.travellers_map.util2.MapSegmentProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;

public class MapSegment {
    public static MapSegment EMPTY = new MapSegment(null, "empty", null, 0L, new IMapSegmentTicket[0]){

        @Override
        public boolean isEmpty() {
            return true;
        }
    };
    private final MapSegmentProvider owner;
    private File mapFile;
    private long identifier;
    private int segX;
    private int segZ;
    private DynamicTexture dynTexture;
    private NativeImage mapImage;
    private ResourceLocation mapLocation;
    private Set<IMapSegmentTicket> tickets = new HashSet<IMapSegmentTicket>();
    boolean dirtyIO = false;
    boolean dirtyGPU = false;
    private String segmentName;

    public MapSegment(MapSegmentProvider owner, String segmentName, File mapFile, long identifier, IMapSegmentTicket ... tickets) {
        this.owner = owner;
        this.segmentName = segmentName;
        this.mapFile = mapFile;
        this.identifier = identifier;
        this.segX = (int)(identifier >> 32 & 0xFFFFFFFFFFFFFFFFL);
        this.segZ = (int)(identifier & 0xFFFFFFFFFFFFFFFFL);
        try {
            this.mapImage = mapFile != null && mapFile.exists() ? NativeImage.func_195713_a((InputStream)new FileInputStream(mapFile)) : new NativeImage(NativeImage.PixelFormat.RGBA, 512, 512, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (IMapSegmentTicket ticket : tickets) {
            this.tickets.add(ticket);
        }
    }

    public void addTicket(IMapSegmentTicket ticket) {
        this.tickets.add(ticket);
    }

    public DynamicTexture getDynTexture() {
        if (this.dynTexture == null) {
            this.dynTexture = new DynamicTexture(this.mapImage);
            this.mapLocation = Minecraft.func_71410_x().func_110434_K().func_110578_a(this.segmentName, this.dynTexture);
        }
        return this.dynTexture;
    }

    public void updateChunk(World world, IChunk chunk) {
        if (this.isEmpty()) {
            return;
        }
        this.owner.getMapper().mapChunk(world, chunk, this.mapImage);
    }

    public void markDirty() {
        if (this.isEmpty()) {
            return;
        }
        this.dirtyIO = true;
        this.dirtyGPU = true;
    }

    public void updadteGPU() {
        if (this.isEmpty()) {
            return;
        }
        if (this.dirtyGPU && this.dynTexture != null) {
            this.dynTexture.func_110564_a();
            this.dirtyGPU = false;
        }
    }

    public long getIdent() {
        return this.identifier;
    }

    public void update() {
        if (this.isEmpty()) {
            return;
        }
        if (this.dirtyIO) {
            try {
                this.mapImage.func_209271_a(this.mapFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.dirtyIO = false;
        }
        Iterator<IMapSegmentTicket> iter = this.tickets.iterator();
        while (iter.hasNext()) {
            if (iter.next().isActive()) continue;
            iter.remove();
        }
        if (this.tickets.isEmpty()) {
            this.free();
        }
    }

    public void free() {
        if (this.isEmpty()) {
            return;
        }
        RenderSystem.recordRenderCall(() -> Minecraft.func_71410_x().func_110434_K().func_147645_c(this.mapLocation));
        this.owner.unloadSegment(this);
    }

    public int getSegX() {
        return this.segX;
    }

    public int getSegZ() {
        return this.segZ;
    }

    public boolean isEmpty() {
        return false;
    }
}

