/*
 * Decompiled with CFR 0.152.
 */
package net.konwboy.tumbleweed.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.konwboy.tumbleweed.client.ModelTumbleweed;
import net.konwboy.tumbleweed.common.EntityTumbleweed;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.common.model.TransformationHelper;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class RenderTumbleweed
extends EntityRenderer<EntityTumbleweed> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("tumbleweed", "textures/entity/tumbleweed.png");
    private static RenderType TUMBLEWEED = ForgeRenderTypes.getUnlitTranslucent((ResourceLocation)TEXTURE, (boolean)false);
    private ModelTumbleweed tumbleweed = new ModelTumbleweed(0.0f);

    public RenderTumbleweed(EntityRendererManager manager) {
        super(manager);
        this.field_76989_e = 0.4f;
        this.field_76987_f = 0.8f;
    }

    public void render(EntityTumbleweed entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int packedLightIn) {
        float alpha;
        this.field_76987_f = alpha = (1.0f - (float)entity.fadeProgress / 80.0f) * 0.7f;
        this.field_76989_e = entity.func_213311_cf() * 0.5f;
        matrixStack.func_227860_a_();
        float size = 1.0f + (float)entity.getSize() / 8.0f;
        float stretch = MathHelper.func_219799_g((float)partialTicks, (float)entity.prevStretch, (float)entity.stretch);
        matrixStack.func_227861_a_(0.0, (double)(entity.func_213302_cg() * 0.3f), 0.0);
        matrixStack.func_227862_a_(size, size, size);
        matrixStack.func_227862_a_(1.0f, stretch, 1.0f);
        matrixStack.func_227863_a_(TransformationHelper.slerp((Quaternion)entity.prevQuat, (Quaternion)entity.quat, (float)partialTicks));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(entity.rot1));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(entity.rot2));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(entity.rot3));
        IVertexBuilder buf = bufferIn.getBuffer(TUMBLEWEED);
        this.tumbleweed.render(matrixStack, buf, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, alpha);
        matrixStack.func_227865_b_();
        super.func_225623_a_((Entity)entity, entityYaw, partialTicks, matrixStack, bufferIn, packedLightIn);
    }

    public ResourceLocation getEntityTexture(EntityTumbleweed entity) {
        return TEXTURE;
    }

    public static class Factory
    implements IRenderFactory<EntityTumbleweed> {
        public EntityRenderer<EntityTumbleweed> createRenderFor(EntityRendererManager manager) {
            return new RenderTumbleweed(manager);
        }
    }
}

