/*
 * Decompiled with CFR 0.152.
 */
package net.konwboy.tumbleweed.common;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.konwboy.tumbleweed.common.TumbleweedConfig;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.TrackedEntity;
import net.minecraft.world.World;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityTumbleweed
extends Entity
implements IEntityAdditionalSpawnData {
    public static final int FADE_TIME = 80;
    private static final int DESPAWN_RANGE = 110;
    private static final float BASE_SIZE = 0.75f;
    private static final double WIND_X = -0.0625;
    private static final double WIND_Z = -0.0625;
    private static final DataParameter<Integer> SIZE = EntityDataManager.func_187226_a(EntityTumbleweed.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> CUSTOM_WIND_ENABLED = EntityDataManager.func_187226_a(EntityTumbleweed.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> CUSTOM_WIND_X = EntityDataManager.func_187226_a(EntityTumbleweed.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> CUSTOM_WIND_Z = EntityDataManager.func_187226_a(EntityTumbleweed.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> FADING = EntityDataManager.func_187226_a(EntityTumbleweed.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int age;
    public int fadeProgress;
    public boolean persistent;
    private double windMod;
    private int lifetime;
    private float angularX;
    private float angularZ;
    public float stretch = 1.0f;
    public float prevStretch = 1.0f;
    private boolean prevOnGround;
    private Vector3d prevMotion = Vector3d.field_186680_a;
    @OnlyIn(value=Dist.CLIENT)
    public float rot1;
    @OnlyIn(value=Dist.CLIENT)
    public float rot2;
    @OnlyIn(value=Dist.CLIENT)
    public float rot3;
    @OnlyIn(value=Dist.CLIENT)
    public Quaternion quat;
    @OnlyIn(value=Dist.CLIENT)
    public Quaternion prevQuat;
    private static Field trackedEntityHashTable = EntityTumbleweed.fieldsOfType(ChunkManager.class, Int2ObjectMap.class)[0];
    private static Field entryFieldLazy;
    private static Field encodedPosX;
    private static Field encodedPosY;
    private static Field encodedPosZ;
    private static Field updateCounter;

    public EntityTumbleweed(EntityType<?> type, World world) {
        super(type, world);
        this.field_70144_Y = 0.95f;
        this.field_70156_m = true;
        this.func_145769_d(this.func_145782_y());
        if (this.field_70170_p.field_72995_K) {
            this.initClient();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void initClient() {
        this.rot1 = 360.0f * this.field_70170_p.field_73012_v.nextFloat();
        this.rot2 = 360.0f * this.field_70170_p.field_73012_v.nextFloat();
        this.rot3 = 360.0f * this.field_70170_p.field_73012_v.nextFloat();
        this.quat = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
        this.prevQuat = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SIZE, (Object)2);
        this.field_70180_af.func_187214_a(CUSTOM_WIND_ENABLED, (Object)false);
        this.field_70180_af.func_187214_a(CUSTOM_WIND_X, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(CUSTOM_WIND_Z, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(FADING, (Object)false);
        this.func_213323_x_();
    }

    protected void func_213281_b(CompoundNBT nbt) {
        nbt.func_74768_a("Size", this.getSize());
        nbt.func_74757_a("CustomWindEnabled", this.getCustomWindEnabled());
        nbt.func_74780_a("CustomWindX", this.getCustomWindX());
        nbt.func_74780_a("CustomWindZ", this.getCustomWindZ());
        nbt.func_74757_a("Persistent", this.persistent);
        AxisAlignedBB bb = this.func_174813_aQ();
        nbt.func_218657_a("AABB", (INBT)this.func_70087_a(new double[]{bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f}));
    }

    protected void func_70037_a(CompoundNBT nbt) {
        if (nbt.func_74764_b("Size")) {
            this.field_70180_af.func_187227_b(SIZE, (Object)nbt.func_74762_e("Size"));
        }
        this.field_70180_af.func_187227_b(CUSTOM_WIND_ENABLED, (Object)nbt.func_74767_n("CustomWindEnabled"));
        this.field_70180_af.func_187227_b(CUSTOM_WIND_X, (Object)Float.valueOf(nbt.func_74760_g("CustomWindX")));
        this.field_70180_af.func_187227_b(CUSTOM_WIND_Z, (Object)Float.valueOf(nbt.func_74760_g("CustomWindZ")));
        this.persistent = nbt.func_74767_n("Persistent");
        if (nbt.func_74764_b("AABB")) {
            ListNBT aabb = nbt.func_150295_c("AABB", 6);
            this.func_174826_a(new AxisAlignedBB(aabb.func_150309_d(0), aabb.func_150309_d(1), aabb.func_150309_d(2), aabb.func_150309_d(3), aabb.func_150309_d(4), aabb.func_150309_d(5)));
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (key.equals(SIZE)) {
            this.func_213323_x_();
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public EntitySize func_213305_a(Pose pose) {
        float mcSize = 0.75f + (float)this.getSize() * 0.125f;
        if (this.field_70170_p.field_72995_K) {
            mcSize -= 4.8828125E-4f;
        }
        return EntitySize.func_220314_b((float)mcSize, (float)mcSize);
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    public void func_145769_d(int id) {
        super.func_145769_d(id);
        Random rand = new Random(id);
        this.windMod = 1.05 - 0.1 * rand.nextDouble();
        this.lifetime = 2400 + rand.nextInt(200);
    }

    public void func_70071_h_() {
        double windZ;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.trackerHack();
        }
        if (this.field_70170_p.field_72995_K) {
            this.preTickClient();
        }
        if (this.func_184187_bx() != null) {
            this.func_213317_d(Vector3d.field_186680_a);
            return;
        }
        if (!this.func_70090_H()) {
            this.func_213317_d(this.func_213322_ci().func_178786_a(0.0, 0.012, 0.0));
        }
        this.prevMotion = this.func_213322_ci();
        this.prevOnGround = this.field_70122_E;
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        double windX = this.getCustomWindEnabled() ? this.getCustomWindX() : -0.0625 * this.windMod;
        double d = windZ = this.getCustomWindEnabled() ? this.getCustomWindZ() : -0.0625 * this.windMod;
        if (this.func_70090_H()) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.95, 1.0, 0.95));
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.02, 0.0));
            windZ = 0.0;
            windX = 0.0;
        } else if (windX != 0.0 || windZ != 0.0) {
            this.func_213293_j(windX, this.func_213322_ci().field_72448_b, windZ);
        }
        if (this.field_70170_p.field_72995_K) {
            this.tickClient();
        }
        if (this.field_70122_E) {
            if (windX * windX + windZ * windZ >= 0.0025000000000000005) {
                this.func_213293_j(this.func_213322_ci().field_72450_a, Math.max(-this.prevMotion.field_72448_b * 0.7, 0.24 - (double)this.getSize() * 0.02), this.func_213322_ci().field_72449_c);
            } else {
                this.func_213293_j(this.func_213322_ci().field_72450_a, -this.prevMotion.field_72448_b * 0.7, this.func_213322_ci().field_72449_c);
            }
        }
        this.func_213317_d(this.func_213322_ci().func_216372_d(0.98, 0.98, 0.98));
        this.collideWithNearbyEntities();
        if (!this.field_70170_p.field_72995_K) {
            this.age += this.field_70123_F || this.func_70090_H() ? 8 : 1;
            this.tryDespawn();
        }
        if (this.isFading()) {
            ++this.fadeProgress;
            if (this.fadeProgress > 80) {
                this.func_70106_y();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void preTickClient() {
        this.prevStretch = this.stretch;
        this.stretch *= 1.2f;
        if (this.stretch > 1.0f) {
            this.stretch = 1.0f;
        }
        this.prevQuat = new Quaternion(this.quat);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickClient() {
        if (this.prevOnGround != this.field_70122_E) {
            this.stretch *= 0.75f;
        }
        float motionAngleX = (float)(-this.prevMotion.field_72450_a) / (this.func_213311_cf() * 0.5f);
        float motionAngleZ = (float)this.prevMotion.field_72449_c / (this.func_213311_cf() * 0.5f);
        if (this.field_70122_E) {
            this.angularX = motionAngleX;
            this.angularZ = motionAngleZ;
        }
        if (this.func_70090_H()) {
            this.angularX += motionAngleX * 0.2f;
            this.angularZ += motionAngleZ * 0.2f;
        }
        float resistance = this.func_70090_H() ? 0.9f : 0.96f;
        this.angularX *= resistance;
        this.angularZ *= resistance;
        Quaternion temp = new Quaternion(this.angularZ, 0.0f, this.angularX, false);
        temp.func_195890_a(this.quat);
        this.quat = temp;
    }

    private void trackerHack() {
        TrackedEntity entry = this.getTrackerEntry();
        try {
            int counter = (Integer)updateCounter.get(entry);
            if (entry != null && counter == 0) {
                updateCounter.set(entry, counter + 30);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private void tryDespawn() {
        if (this.shouldPersist()) {
            this.age = 0;
            return;
        }
        PlayerEntity player = this.field_70170_p.func_217362_a((Entity)this, -1.0);
        if (player != null && player.func_70068_e((Entity)this) > 12100.0) {
            this.func_70106_y();
        }
        if (this.age > this.lifetime && this.fadeProgress == 0) {
            this.field_70180_af.func_187227_b(FADING, (Object)true);
        }
    }

    public boolean func_70112_a(double distance) {
        return distance < 16384.0;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.func_70089_S() && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            SoundType sound = SoundType.field_185850_c;
            this.func_184185_a(sound.func_185845_c(), (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f);
            if (TumbleweedConfig.enableDrops && (!TumbleweedConfig.dropOnlyByPlayer || source.func_76346_g() instanceof PlayerEntity)) {
                this.dropItem();
            }
        }
        return true;
    }

    private void dropItem() {
        ItemStack item = TumbleweedConfig.getRandomItem();
        if (item != null) {
            ItemEntity itemEntity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), item);
            itemEntity.func_213317_d(new Vector3d(0.0, 0.2, 0.0));
            itemEntity.func_174869_p();
            this.field_70170_p.func_217376_c((Entity)itemEntity);
        }
    }

    public boolean func_85031_j(Entity entityIn) {
        return entityIn instanceof PlayerEntity && this.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)entityIn)), 0.0f);
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187579_bV, 0.15f, 1.0f);
    }

    public boolean canTrample(BlockState state, BlockPos pos, float fallDistance) {
        return this.field_70170_p.field_73012_v.nextFloat() < 0.7f && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b) && TumbleweedConfig.damageCrops;
    }

    protected boolean func_142008_O() {
        return false;
    }

    private void collideWithNearbyEntities() {
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(0.2, 0.0, 0.2), Entity::func_70104_M);
        for (Entity entity : list) {
            if (!this.field_70170_p.field_72995_K && entity instanceof AbstractMinecartEntity && ((AbstractMinecartEntity)entity).func_184264_v() == AbstractMinecartEntity.Type.RIDEABLE && entity.func_213322_ci().field_72450_a * entity.func_213322_ci().field_72450_a + entity.func_213322_ci().field_72449_c * entity.func_213322_ci().field_72449_c > 0.01 && entity.func_184188_bt().isEmpty() && this.func_184187_bx() == null) {
                this.func_184220_m(entity);
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.25, 0.0));
                this.field_70133_I = true;
            }
            entity.func_70108_f((Entity)this);
        }
    }

    public boolean isNotColliding() {
        return this.field_70170_p.func_226668_i_((Entity)this) && !this.field_70170_p.func_226666_b_((Entity)this, this.func_174813_aQ()).findAny().isPresent() && !this.field_70170_p.func_72953_d(this.func_174813_aQ());
    }

    public void setSize(int size) {
        this.field_70180_af.func_187227_b(SIZE, (Object)size);
    }

    public int getSize() {
        return (Integer)this.field_70180_af.func_187225_a(SIZE);
    }

    public double getCustomWindX() {
        return ((Float)this.field_70180_af.func_187225_a(CUSTOM_WIND_X)).floatValue();
    }

    public double getCustomWindZ() {
        return ((Float)this.field_70180_af.func_187225_a(CUSTOM_WIND_Z)).floatValue();
    }

    public boolean getCustomWindEnabled() {
        return (Boolean)this.field_70180_af.func_187225_a(CUSTOM_WIND_ENABLED);
    }

    public boolean isFading() {
        return (Boolean)this.field_70180_af.func_187225_a(FADING);
    }

    public boolean shouldPersist() {
        return this.persistent || this.func_184187_bx() != null;
    }

    private static Field[] fieldsOfType(Class inClass, Class type) {
        return (Field[])Arrays.stream(inClass.getDeclaredFields()).filter(f -> f.getType() == type).toArray(Field[]::new);
    }

    public TrackedEntity getTrackerEntry() {
        TrackedEntity entry = null;
        try {
            Object e = ((Int2ObjectMap)trackedEntityHashTable.get(((ServerWorld)this.field_70170_p).func_72863_F().field_217237_a)).get(this.func_145782_y());
            if (entryFieldLazy == null) {
                entryFieldLazy = EntityTumbleweed.fieldsOfType(e.getClass(), TrackedEntity.class)[0];
                entryFieldLazy.setAccessible(true);
            }
            entry = (TrackedEntity)entryFieldLazy.get(e);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return entry;
    }

    public void writeSpawnData(PacketBuffer buffer) {
        TrackedEntity entry = this.getTrackerEntry();
        try {
            buffer.writeLong(((Long)encodedPosX.get(entry)).longValue());
            buffer.writeLong(((Long)encodedPosY.get(entry)).longValue());
            buffer.writeLong(((Long)encodedPosZ.get(entry)).longValue());
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.func_213312_b((double)additionalData.readLong() / 4096.0, (double)additionalData.readLong() / 4096.0, (double)additionalData.readLong() / 4096.0);
    }

    static {
        trackedEntityHashTable.setAccessible(true);
        encodedPosX = EntityTumbleweed.fieldsOfType(TrackedEntity.class, Long.TYPE)[0];
        encodedPosX.setAccessible(true);
        encodedPosY = EntityTumbleweed.fieldsOfType(TrackedEntity.class, Long.TYPE)[1];
        encodedPosY.setAccessible(true);
        encodedPosZ = EntityTumbleweed.fieldsOfType(TrackedEntity.class, Long.TYPE)[2];
        encodedPosZ.setAccessible(true);
        updateCounter = EntityTumbleweed.fieldsOfType(TrackedEntity.class, Integer.TYPE)[4];
        updateCounter.setAccessible(true);
    }
}

