/*
 * Decompiled with CFR 0.152.
 */
package net.konwboy.tumbleweed.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import net.konwboy.tumbleweed.common.EntityTumbleweed;
import net.konwboy.tumbleweed.common.TumbleweedConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TumbleweedSpawner {
    private static final int TRY_SPAWN_TICKS = 200;
    private static final int MOB_COUNT_DIV = 289;
    private static final int SEARCH_RADIUS = 2;
    private static final int SPAWN_ATTEMPTS = 10;

    private static void trySpawn(WorldServer world) {
        HashSet eligibleChunksForSpawning = Sets.newHashSet();
        for (EntityPlayer entityplayer : world.field_73010_i) {
            if (entityplayer.func_175149_v()) continue;
            int playerX = MathHelper.func_76128_c((double)(entityplayer.field_70165_t / 16.0));
            int playerZ = MathHelper.func_76128_c((double)(entityplayer.field_70161_v / 16.0));
            for (int x = 8; x >= -8; --x) {
                for (int z = 8; z >= -8; --z) {
                    Biome biome;
                    boolean corner = x == -8 || x == 8 || z == -8 || z == 8;
                    ChunkPos chunk = new ChunkPos(x + playerX, z + playerZ);
                    if (eligibleChunksForSpawning.contains(chunk) || corner || !world.func_175723_af().func_177730_a(chunk) || !TumbleweedSpawner.isEntityProcessing((World)world, chunk.field_77276_a * 16, chunk.field_77275_b * 16) || !TumbleweedSpawner.isValidBiome(biome = world.func_180494_b(chunk.func_180331_a(8, 0, 8)))) continue;
                    eligibleChunksForSpawning.add(chunk);
                }
            }
        }
        ArrayList chunkList = Lists.newArrayList((Iterable)eligibleChunksForSpawning);
        Collections.shuffle(chunkList);
        BlockPos worldSpawn = world.func_175694_M();
        int current = world.func_72907_a(EntityTumbleweed.class);
        int max = MathHelper.func_76143_f((double)((double)(TumbleweedConfig.maxPerPlayer * eligibleChunksForSpawning.size()) / 289.0));
        block3: for (ChunkPos chunk : chunkList) {
            if (current > max) break;
            if (world.field_73012_v.nextDouble() > TumbleweedConfig.spawnChance) continue;
            BlockPos start = TumbleweedSpawner.getRandomSurfacePosition((World)world, chunk.field_77276_a, chunk.field_77275_b);
            BlockPos spawner = null;
            block4: for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos check = world.func_175645_m(new BlockPos(start.func_177958_n() + x, 0, start.func_177952_p() + z));
                    IBlockState state = world.func_180495_p(check);
                    Block block = state.func_177230_c();
                    TumbleweedConfig.Metadata meta = new TumbleweedConfig.Metadata(block.getRegistryName(), block.func_176201_c(state));
                    if (!TumbleweedConfig.Logic.spawningBlocks.contains(meta) || !world.func_175710_j(check)) continue;
                    spawner = check;
                    continue block4;
                }
            }
            if (spawner == null) continue;
            int packSize = 1 + (world.field_73012_v.nextFloat() < 0.2f ? 1 : 0);
            int packSpawned = 0;
            for (int i = 0; i < 10; ++i) {
                int x = spawner.func_177958_n() + world.field_73012_v.nextInt(5) - world.field_73012_v.nextInt(5);
                int y = spawner.func_177956_o() + world.field_73012_v.nextInt(2) - world.field_73012_v.nextInt(2);
                int z = spawner.func_177952_p() + world.field_73012_v.nextInt(5) - world.field_73012_v.nextInt(5);
                if (!TumbleweedSpawner.isEntityProcessing((World)world, x, z) || !world.isSideSolid(new BlockPos(x, y - 1, z), EnumFacing.UP) || world.func_175636_b((double)x, (double)y, (double)z, 32.0) || worldSpawn.func_177954_c((double)x, (double)y, (double)z) < 576.0) continue;
                EntityTumbleweed entity = new EntityTumbleweed((World)world);
                entity.setSize(world.field_73012_v.nextInt(5) - 2);
                entity.func_70012_b((double)x + 0.5, (double)y + 0.5 + 0.5 * world.field_73012_v.nextDouble(), (double)z + 0.5, 0.0f, 0.0f);
                if (entity.isNotColliding()) {
                    ++current;
                    ++packSpawned;
                    world.func_72838_d((Entity)entity);
                }
                if (packSpawned == packSize) continue block3;
            }
        }
    }

    private static boolean isValidBiome(Biome biome) {
        boolean rightType = BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY);
        return TumbleweedConfig.Logic.biomeWhitelist.isEmpty() && rightType || TumbleweedConfig.Logic.biomeWhitelist.contains(biome.getRegistryName());
    }

    private static BlockPos getRandomSurfacePosition(World world, int chunkX, int chunkZ) {
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        int x = chunkX * 16 + world.field_73012_v.nextInt(14) + 2;
        int z = chunkZ * 16 + world.field_73012_v.nextInt(14) + 2;
        int y = chunk.func_177433_f(new BlockPos(x, 0, z));
        return new BlockPos(x, y, z);
    }

    private static boolean isEntityProcessing(World world, double posX, double posZ) {
        int x = MathHelper.func_76128_c((double)posX);
        int z = MathHelper.func_76128_c((double)posZ);
        return world.func_175707_a(new BlockPos(x - 32, 0, z - 32), new BlockPos(x + 32, 0, z + 32));
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent event) {
        WorldServer world = (WorldServer)event.world;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (world.func_82737_E() % 200L == 7L) {
            world.field_72984_F.func_76320_a("spawn_tumbleweed");
            TumbleweedSpawner.trySpawn(world);
            world.field_72984_F.func_76319_b();
        }
    }

    @SubscribeEvent
    public void onCanUpdate(EntityEvent.CanUpdate event) {
        Entity entity = event.getEntity();
        World world = entity.func_130014_f_();
        if (!(world.field_72995_K || !(entity instanceof EntityTumbleweed) || entity.field_70173_aa <= 0 || TumbleweedSpawner.isEntityProcessing(world, entity.field_70165_t, entity.field_70161_v) || ((EntityTumbleweed)entity).persistent || entity.func_184218_aH())) {
            world.func_72900_e(entity);
        }
    }
}

