/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.unhealthydying.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mrbysco.unhealthydying.util.UnhealthyHelper;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class UnhealthyCommands {
    public static void initializeCommands(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder root = Commands.func_197057_a((String)"unhealthydying");
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)root.requires(p_198721_0_ -> p_198721_0_.func_197034_c(2))).then(Commands.func_197057_a((String)"hearts").then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197094_d()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"health", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> UnhealthyCommands.addHearts((CommandContext<CommandSource>)ctx, false))).then(Commands.func_197056_a((String)"hideMessage", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> UnhealthyCommands.addHearts((CommandContext<CommandSource>)ctx, !BoolArgumentType.getBool((CommandContext)ctx, (String)"hideMessage"))))))))).then(Commands.func_197057_a((String)"hearts").then(Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197094_d()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"health", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> UnhealthyCommands.removeHearts((CommandContext<CommandSource>)ctx, false))).then(Commands.func_197056_a((String)"hideMessage", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> UnhealthyCommands.removeHearts((CommandContext<CommandSource>)ctx, !BoolArgumentType.getBool((CommandContext)ctx, (String)"hideMessage"))))))))).then(Commands.func_197057_a((String)"hearts").then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197094_d()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"health", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> UnhealthyCommands.setHearts((CommandContext<CommandSource>)ctx, false))).then(Commands.func_197056_a((String)"hideMessage", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> UnhealthyCommands.setHearts((CommandContext<CommandSource>)ctx, !BoolArgumentType.getBool((CommandContext)ctx, (String)"hideMessage"))))))));
        dispatcher.register(root);
    }

    private static int addHearts(CommandContext<CommandSource> ctx, boolean silent) throws CommandSyntaxException {
        int health = IntegerArgumentType.getInteger(ctx, (String)"health");
        for (ServerPlayerEntity player : EntityArgument.func_197090_e(ctx, (String)"player")) {
            if (health <= 0) continue;
            UnhealthyHelper.setHealth((PlayerEntity)player, health);
            if (silent) continue;
            IFormattableTextComponent text = new TranslationTextComponent("unhealthydying:addhearts.message", new Object[]{(double)health / 2.0}).func_240699_a_(TextFormatting.RED);
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)text, false);
        }
        return 0;
    }

    private static int removeHearts(CommandContext<CommandSource> ctx, boolean silent) throws CommandSyntaxException {
        int health = IntegerArgumentType.getInteger(ctx, (String)"health");
        for (ServerPlayerEntity player : EntityArgument.func_197090_e(ctx, (String)"player")) {
            if (health <= 0) continue;
            UnhealthyHelper.setHealth((PlayerEntity)player, -health);
            if (silent) continue;
            IFormattableTextComponent text = new TranslationTextComponent("unhealthydying:removehearts.message", new Object[]{(double)health / 2.0}).func_240699_a_(TextFormatting.RED);
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)text, false);
        }
        return 0;
    }

    private static int setHearts(CommandContext<CommandSource> ctx, boolean silent) throws CommandSyntaxException {
        int health = IntegerArgumentType.getInteger(ctx, (String)"health");
        for (ServerPlayerEntity player : EntityArgument.func_197090_e(ctx, (String)"player")) {
            if (health <= 0) continue;
            UnhealthyHelper.setHealth((PlayerEntity)player, (int)UnhealthyHelper.getModifierForAmount((PlayerEntity)player, health), false);
            if (silent) continue;
            IFormattableTextComponent text = new TranslationTextComponent("unhealthydying:sethealth.message", new Object[]{health}).func_240699_a_(TextFormatting.RED);
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)text, false);
        }
        return 0;
    }
}

