/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.unhealthydying.handlers;

import com.mrbysco.unhealthydying.UnhealthyDying;
import com.mrbysco.unhealthydying.config.EnumHealthSetting;
import com.mrbysco.unhealthydying.config.UnhealthyConfig;
import com.mrbysco.unhealthydying.util.UnhealthyHelper;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.math.NumberUtils;

public class EasterEgg {
    @SubscribeEvent
    public void killedEntityEvent(LivingDeathEvent event) {
        List targets;
        if (((Boolean)UnhealthyConfig.SERVER.regenHealth.get()).booleanValue() && !(targets = (List)UnhealthyConfig.SERVER.regenTargets.get()).isEmpty()) {
            for (String target : targets) {
                if (!(event.getSource().func_76346_g() instanceof PlayerEntity) || event.getSource().func_76346_g() instanceof FakePlayer) continue;
                PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
                String[] targetInfo = target.split(",");
                if (targetInfo.length <= 2) continue;
                ResourceLocation entityLocation = event.getEntityLiving().func_200600_R().getRegistryName();
                int healthFromKill = NumberUtils.toInt((String)targetInfo[1], (int)0);
                int targetAmount = NumberUtils.toInt((String)targetInfo[2], (int)0);
                if (!targetInfo[0].contains(":") || entityLocation == null) continue;
                String[] splitResource = targetInfo[0].split(":");
                if (targetInfo[0].equals("*:*")) {
                    this.processKill(player, targetInfo[0], healthFromKill, targetAmount);
                    continue;
                }
                if (splitResource[0].equals("*") || splitResource[1].equals("*")) {
                    if (splitResource[0].equals("*") && entityLocation.func_110623_a().equals(splitResource[1])) {
                        this.processKill(player, targetInfo[0], healthFromKill, targetAmount);
                        continue;
                    }
                    if (!splitResource[1].equals("*") || !entityLocation.func_110624_b().equals(splitResource[0])) continue;
                    this.processKill(player, targetInfo[0], healthFromKill, targetAmount);
                    continue;
                }
                if (!new ResourceLocation(targetInfo[0]).equals((Object)entityLocation)) continue;
                this.processKill(player, targetInfo[0], healthFromKill, targetAmount);
            }
        }
    }

    public void processKill(PlayerEntity player, String target, int healthGained, int targetAmount) {
        float maxRegained;
        float playerHealth = player.func_110138_aP();
        if (playerHealth < (maxRegained = (float)((Integer)UnhealthyConfig.SERVER.maxRegained.get()).intValue())) {
            if (targetAmount == 1) {
                switch ((EnumHealthSetting)((Object)UnhealthyConfig.SERVER.healthSetting.get())) {
                    case EVERYBODY: {
                        UnhealthyHelper.setEveryonesHealth(player, healthGained);
                        break;
                    }
                    case SCOREBOARD_TEAM: {
                        UnhealthyHelper.setScoreboardHealth(player, healthGained);
                        break;
                    }
                    default: {
                        UnhealthyHelper.setHealth(player, healthGained);
                        break;
                    }
                }
            } else {
                String customTag = "unhealthydying:" + target + ":" + targetAmount;
                switch ((EnumHealthSetting)((Object)UnhealthyConfig.SERVER.healthSetting.get())) {
                    case EVERYBODY: {
                        EasterEgg.setEveryonesKillCount(player, customTag, healthGained, targetAmount);
                        break;
                    }
                    case SCOREBOARD_TEAM: {
                        EasterEgg.setScoreboardKillCount(player, customTag, targetAmount, healthGained);
                        break;
                    }
                    default: {
                        EasterEgg.setAmountData(player, customTag, targetAmount, healthGained);
                    }
                }
            }
        }
    }

    public static void setEveryonesKillCount(PlayerEntity player, String customTag, int healthGained, int targetAmount) {
        for (PlayerEntity players : player.field_70170_p.func_217369_A()) {
            if (players.equals((Object)player)) {
                EasterEgg.setAmountData(player, customTag, healthGained, targetAmount);
                continue;
            }
            EasterEgg.setAmountData(players, customTag, healthGained, targetAmount);
        }
    }

    public static void setScoreboardKillCount(PlayerEntity player, String customTag, int healthGained, int targetAmount) {
        World world = player.field_70170_p;
        if (player.func_96124_cp() != null) {
            Team team = player.func_96124_cp();
            for (PlayerEntity players : world.func_217369_A()) {
                if (players.equals((Object)player)) {
                    EasterEgg.setAmountData(player, customTag, healthGained, targetAmount);
                    continue;
                }
                if (!players.func_184194_a(team)) continue;
                EasterEgg.setAmountData(players, customTag, healthGained, targetAmount);
            }
        } else {
            UnhealthyDying.LOGGER.error(player.func_200200_C_() + " is not in a team");
        }
    }

    public static void setAmountData(PlayerEntity player, String customTag, int targetAmount, int healthGained) {
        CompoundNBT playerData = player.getPersistentData();
        if (playerData.func_74764_b(customTag)) {
            int currentAmount = playerData.func_74762_e(customTag);
            if (currentAmount + 1 >= targetAmount) {
                switch ((EnumHealthSetting)((Object)UnhealthyConfig.SERVER.healthSetting.get())) {
                    case EVERYBODY: {
                        UnhealthyHelper.setEveryonesHealth(player, healthGained);
                        break;
                    }
                    case SCOREBOARD_TEAM: {
                        UnhealthyHelper.setScoreboardHealth(player, healthGained);
                        break;
                    }
                    default: {
                        UnhealthyHelper.setHealth(player, healthGained);
                    }
                }
                playerData.func_82580_o(customTag);
            } else {
                playerData.func_74768_a(customTag, currentAmount + 1);
            }
        } else {
            playerData.func_74768_a(customTag, 1);
        }
    }
}

