/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.unhealthydying.util;

import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class ModifierWorldData
extends WorldSavedData {
    private static final String DATA_NAME = "unhealthydying_world_data";
    private static final String MODIFIER_TAG = "stored_modifiers";
    private static final String EVERYBODY_TAG = "EverybodyModifier";
    private CompoundNBT modifierTag = new CompoundNBT();

    public ModifierWorldData() {
        super(DATA_NAME);
    }

    public void func_76184_a(CompoundNBT nbt) {
        if (nbt.func_74764_b(MODIFIER_TAG)) {
            this.setModifierTag((CompoundNBT)nbt.func_74781_a(MODIFIER_TAG));
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        compound.func_218657_a(MODIFIER_TAG, (INBT)this.modifierTag);
        return compound;
    }

    public CompoundNBT getModifierTag() {
        return this.modifierTag;
    }

    public void setModifierTag(CompoundNBT modifierTag) {
        this.modifierTag = modifierTag;
    }

    public void setScoreboardTeamModifier(String scoreboardName, int healthModifier) {
        String teamTag = "Scoreboard" + scoreboardName + "Modifier";
        this.getModifierTag().func_74768_a(teamTag, healthModifier);
    }

    public int getScoreboardTeamModifier(String scoreboardName) {
        String teamTag = "Scoreboard" + scoreboardName + "Modifier";
        if (this.getModifierTag().func_74764_b(teamTag)) {
            return this.getModifierTag().func_74762_e(teamTag);
        }
        this.getModifierTag().func_74768_a(teamTag, 0);
        return 0;
    }

    public void setEverybodyModifier(int healthModifier) {
        this.getModifierTag().func_74768_a(EVERYBODY_TAG, healthModifier);
    }

    public int getEverybodyModifier() {
        if (this.getModifierTag().func_74764_b(EVERYBODY_TAG)) {
            return this.getModifierTag().func_74762_e(EVERYBODY_TAG);
        }
        this.getModifierTag().func_74768_a(EVERYBODY_TAG, 0);
        return 0;
    }

    public void setPlayerModifier(UUID uuid, int healthModifier) {
        this.getModifierTag().func_74768_a(uuid.toString(), healthModifier);
    }

    public int getPlayerModifier(UUID uuid) {
        if (this.getModifierTag().func_74764_b(uuid.toString())) {
            return this.getModifierTag().func_74762_e(uuid.toString());
        }
        this.getModifierTag().func_74768_a(uuid.toString(), 0);
        return 0;
    }

    public static ModifierWorldData get(World world) {
        if (!(world instanceof ServerWorld)) {
            throw new RuntimeException("Attempted to get the data from a client world. This is wrong.");
        }
        ServerWorld overworld = world.func_73046_m().func_71218_a(World.field_234918_g_);
        DimensionSavedDataManager storage = overworld.func_217481_x();
        return (ModifierWorldData)storage.func_215752_a(ModifierWorldData::new, DATA_NAME);
    }
}

