/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.unhealthydying.util;

import com.mrbysco.unhealthydying.Reference;
import com.mrbysco.unhealthydying.UnhealthyDying;
import com.mrbysco.unhealthydying.config.EnumHealthSetting;
import com.mrbysco.unhealthydying.config.UnhealthyConfig;
import com.mrbysco.unhealthydying.util.HealthUtil;
import com.mrbysco.unhealthydying.util.ModifierWorldData;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.scoreboard.Team;
import net.minecraft.world.World;

public class UnhealthyHelper {
    public static void initializeModifier(PlayerEntity player, double modifier) {
        ModifiableAttributeInstance attributeInstance;
        if (!player.field_70170_p.field_72995_K && (attributeInstance = player.func_110148_a(Attributes.field_233818_a_)) != null && attributeInstance.func_111127_a(Reference.HEALTH_MODIFIER_ID) == null) {
            attributeInstance.func_233769_c_(UnhealthyHelper.getModifier(modifier));
        }
    }

    public static void changeModifier(PlayerEntity player, double modifierValue) {
        if (!player.field_70170_p.field_72995_K) {
            ModifiableAttributeInstance attributeInstance = player.func_110148_a(Attributes.field_233818_a_);
            AttributeModifier modifier = UnhealthyHelper.getModifier(modifierValue);
            if (attributeInstance != null) {
                AttributeModifier oldAttribute = attributeInstance.func_111127_a(Reference.HEALTH_MODIFIER_ID);
                if (oldAttribute != null) {
                    if (oldAttribute.func_111164_d() != modifierValue) {
                        HealthUtil.sendHealthMessage(player, (int)attributeInstance.func_111126_e(), (int)modifierValue);
                    }
                    attributeInstance.func_233770_c_(Reference.HEALTH_MODIFIER_ID);
                }
                attributeInstance.func_233769_c_(modifier);
            }
        }
    }

    public static AttributeModifier getModifier(double modifier) {
        return new AttributeModifier(Reference.HEALTH_MODIFIER_ID, "UnhealthyHealthModifier", modifier, AttributeModifier.Operation.ADDITION);
    }

    @Nullable
    public static ModifierWorldData getSavedData(PlayerEntity player) {
        return !player.field_70170_p.field_72995_K ? ModifierWorldData.get((World)player.func_184102_h().func_71218_a(World.field_234918_g_)) : null;
    }

    public static void setEveryonesHealth(PlayerEntity player, int changeModifier) {
        UnhealthyHelper.setEveryonesHealth(player, changeModifier, true);
    }

    public static void setEveryonesHealth(PlayerEntity player, int changeModifier, boolean recalculate) {
        ModifierWorldData worldData = UnhealthyHelper.getSavedData(player);
        if (worldData != null) {
            int savedModifier;
            int n = savedModifier = recalculate ? worldData.getEverybodyModifier() : changeModifier;
            if (recalculate) {
                savedModifier += changeModifier;
                savedModifier = (int)UnhealthyHelper.safetyCheck(player, savedModifier);
            }
            worldData.setEverybodyModifier(savedModifier);
            worldData.func_76185_a();
            for (PlayerEntity players : player.field_70170_p.func_217369_A()) {
                UnhealthyHelper.changeModifier(players, savedModifier);
            }
        }
    }

    public static void setScoreboardHealth(PlayerEntity player, int changeModifier) {
        UnhealthyHelper.setScoreboardHealth(player, changeModifier, true);
    }

    public static void setScoreboardHealth(PlayerEntity player, int changeModifier, boolean recalculate) {
        if (player.func_96124_cp() != null) {
            Team team = player.func_96124_cp();
            ModifierWorldData worldData = UnhealthyHelper.getSavedData(player);
            if (worldData != null) {
                int savedModifier;
                int n = savedModifier = recalculate ? worldData.getScoreboardTeamModifier(team.func_96661_b()) : changeModifier;
                if (recalculate) {
                    savedModifier += changeModifier;
                    savedModifier = (int)UnhealthyHelper.safetyCheck(player, savedModifier);
                }
                worldData.setScoreboardTeamModifier(team.func_96661_b(), savedModifier);
                worldData.func_76185_a();
                for (PlayerEntity players : player.field_70170_p.func_217369_A()) {
                    UnhealthyHelper.changeModifier(players, savedModifier);
                }
            }
        } else {
            UnhealthyDying.LOGGER.error(player.func_200200_C_() + " is not in a team");
        }
    }

    public static void setHealth(PlayerEntity player, int changeModifier) {
        UnhealthyHelper.setHealth(player, changeModifier, true);
    }

    public static void setHealth(PlayerEntity player, int changeModifier, boolean recalculate) {
        ModifierWorldData worldData = UnhealthyHelper.getSavedData(player);
        if (worldData != null) {
            int savedModifier;
            int n = savedModifier = recalculate ? worldData.getPlayerModifier(player.func_146103_bH().getId()) : changeModifier;
            if (recalculate) {
                savedModifier += changeModifier;
                savedModifier = (int)UnhealthyHelper.safetyCheck(player, savedModifier);
            }
            worldData.setPlayerModifier(player.func_146103_bH().getId(), savedModifier);
            worldData.func_76185_a();
            UnhealthyHelper.changeModifier(player, savedModifier);
        }
    }

    public static void syncHealth(PlayerEntity player) {
        ModifierWorldData worldData = UnhealthyHelper.getSavedData(player);
        if (worldData != null) {
            switch ((EnumHealthSetting)((Object)UnhealthyConfig.SERVER.healthSetting.get())) {
                case EVERYBODY: {
                    UnhealthyHelper.setEveryonesHealth(player, worldData.getEverybodyModifier(), false);
                    break;
                }
                case SCOREBOARD_TEAM: {
                    if (player.func_96124_cp() == null) break;
                    UnhealthyHelper.setScoreboardHealth(player, worldData.getScoreboardTeamModifier(player.func_96124_cp().func_96661_b()), false);
                    break;
                }
                default: {
                    UnhealthyHelper.setHealth(player, worldData.getPlayerModifier(player.func_146103_bH().getId()), false);
                }
            }
        }
    }

    public static double getModifierForAmount(PlayerEntity player, double healthWanted) {
        ModifiableAttributeInstance attributeInstance = player.func_110148_a(Attributes.field_233818_a_);
        if (attributeInstance != null) {
            double health = attributeInstance.func_111125_b();
            double modifierRequired = healthWanted - health;
            if (((Boolean)UnhealthyConfig.SERVER.regenHealth.get()).booleanValue() && healthWanted > (double)((Integer)UnhealthyConfig.SERVER.maxRegained.get()).intValue()) {
                modifierRequired = health - (double)((Integer)UnhealthyConfig.SERVER.maxRegained.get()).intValue();
            }
            if (healthWanted < (double)((Integer)UnhealthyConfig.SERVER.minimumHealth.get()).intValue()) {
                modifierRequired = (double)((Integer)UnhealthyConfig.SERVER.minimumHealth.get()).intValue() - health;
            }
            return modifierRequired;
        }
        UnhealthyDying.LOGGER.error("Something went wrong. Somehow the player has no max_health attribute applied");
        return 0.0;
    }

    public static double safetyCheck(PlayerEntity player, double modifierValue) {
        ModifiableAttributeInstance attributeInstance = player.func_110148_a(Attributes.field_233818_a_);
        if (attributeInstance != null) {
            AttributeModifier currentModifier = attributeInstance.func_111127_a(Reference.HEALTH_MODIFIER_ID);
            double health = attributeInstance.func_111125_b();
            if (currentModifier != null) {
                health -= currentModifier.func_111164_d();
            }
            double modifiedHealth = health + modifierValue;
            double usedModifier = modifierValue;
            if (((Boolean)UnhealthyConfig.SERVER.regenHealth.get()).booleanValue() && modifiedHealth > (double)((Integer)UnhealthyConfig.SERVER.maxRegained.get()).intValue()) {
                usedModifier = modifiedHealth - (double)((Integer)UnhealthyConfig.SERVER.maxRegained.get()).intValue();
            }
            if (modifiedHealth < (double)((Integer)UnhealthyConfig.SERVER.minimumHealth.get()).intValue()) {
                usedModifier = (double)((Integer)UnhealthyConfig.SERVER.minimumHealth.get()).intValue() - health;
            }
            return usedModifier;
        }
        UnhealthyDying.LOGGER.error("Something went wrong. Somehow the player has no max_health attribute applied");
        return 0.0;
    }
}

