/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.unhealthydying.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mrbysco.unhealthydying.util.UnhealthyHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class UnhealthyCommands {
    public static void initializeCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder root = Commands.m_82127_((String)"unhealthydying");
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)root.requires(p_198721_0_ -> p_198721_0_.m_6761_(2))).then(Commands.m_82127_((String)"hearts").then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"health", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> UnhealthyCommands.addHearts((CommandContext<CommandSourceStack>)ctx, false))).then(Commands.m_82129_((String)"hideMessage", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> UnhealthyCommands.addHearts((CommandContext<CommandSourceStack>)ctx, !BoolArgumentType.getBool((CommandContext)ctx, (String)"hideMessage"))))))))).then(Commands.m_82127_((String)"hearts").then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"health", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> UnhealthyCommands.removeHearts((CommandContext<CommandSourceStack>)ctx, false))).then(Commands.m_82129_((String)"hideMessage", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> UnhealthyCommands.removeHearts((CommandContext<CommandSourceStack>)ctx, !BoolArgumentType.getBool((CommandContext)ctx, (String)"hideMessage"))))))))).then(Commands.m_82127_((String)"hearts").then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"health", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> UnhealthyCommands.setHearts((CommandContext<CommandSourceStack>)ctx, false))).then(Commands.m_82129_((String)"hideMessage", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> UnhealthyCommands.setHearts((CommandContext<CommandSourceStack>)ctx, !BoolArgumentType.getBool((CommandContext)ctx, (String)"hideMessage"))))))));
        dispatcher.register(root);
    }

    private static int addHearts(CommandContext<CommandSourceStack> ctx, boolean silent) throws CommandSyntaxException {
        int health = IntegerArgumentType.getInteger(ctx, (String)"health");
        for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"player")) {
            if (health <= 0) continue;
            UnhealthyHelper.setHealth((Player)player, health);
            if (silent) continue;
            MutableComponent text = new TranslatableComponent("unhealthydying:addhearts.message", new Object[]{(double)health / 2.0}).m_130940_(ChatFormatting.RED);
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)text, false);
        }
        return 0;
    }

    private static int removeHearts(CommandContext<CommandSourceStack> ctx, boolean silent) throws CommandSyntaxException {
        int health = IntegerArgumentType.getInteger(ctx, (String)"health");
        for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"player")) {
            if (health <= 0) continue;
            UnhealthyHelper.setHealth((Player)player, -health);
            if (silent) continue;
            MutableComponent text = new TranslatableComponent("unhealthydying:removehearts.message", new Object[]{(double)health / 2.0}).m_130940_(ChatFormatting.RED);
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)text, false);
        }
        return 0;
    }

    private static int setHearts(CommandContext<CommandSourceStack> ctx, boolean silent) throws CommandSyntaxException {
        int health = IntegerArgumentType.getInteger(ctx, (String)"health");
        for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"player")) {
            if (health <= 0) continue;
            UnhealthyHelper.setHealth((Player)player, (int)UnhealthyHelper.getModifierForAmount((Player)player, health), false);
            if (silent) continue;
            MutableComponent text = new TranslatableComponent("unhealthydying:sethealth.message", new Object[]{health}).m_130940_(ChatFormatting.RED);
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)text, false);
        }
        return 0;
    }
}

