/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.unhealthydying.config;

import com.mrbysco.unhealthydying.UnhealthyDying;
import com.mrbysco.unhealthydying.config.EnumHealthSetting;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public class UnhealthyConfig {
    public static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        UnhealthyDying.LOGGER.debug("Loaded Unhealthy Dying's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        UnhealthyDying.LOGGER.debug("Unhealthy Dying's config just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.IntValue minimumHealth;
        public final ForgeConfigSpec.IntValue healthPerDeath;
        public final ForgeConfigSpec.BooleanValue reducedHealthMessage;
        public final ForgeConfigSpec.EnumValue<EnumHealthSetting> healthSetting;
        public final ForgeConfigSpec.BooleanValue regenHealth;
        public final ForgeConfigSpec.IntValue maxRegained;
        public final ForgeConfigSpec.BooleanValue regenHealthMessage;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> regenTargets;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("General settings").push("General");
            this.minimumHealth = builder.comment("Minimum amount of health the player can end up with (2 = 1 heart) [default: 2]").defineInRange("minimumHealth", 2, 1, Integer.MAX_VALUE);
            this.healthPerDeath = builder.comment("The amount of health taken from the player upon death (2 = 1 heart) [default: 2]").defineInRange("healthPerDeath", 2, 1, Integer.MAX_VALUE);
            this.reducedHealthMessage = builder.comment("When set to true it notifies the player about their new max health when they respawn [default: true]").define("reducedHealthMessage", true);
            this.healthSetting = builder.comment("Decides if the reduced health is per player, for everybody or per team [default: SEPARATE]").defineEnum("healthSetting", (Enum)EnumHealthSetting.SEPARATE);
            builder.pop();
            builder.comment("Regen settings").push("Regen");
            this.regenHealth = builder.comment("When set to true allows you to gain back health upon killing set target(s) [default: false]").define("regenHealth", false);
            this.maxRegained = builder.comment("The amount of max health the player can get from killing the target(s) (20 = 10 hearts) [default: 20]").defineInRange("maxRegained", 20, 1, Integer.MAX_VALUE);
            this.regenHealthMessage = builder.comment("When set to true it notifies the player about their new max health when they respawn [default: true]").define("regenHealthMessage", true);
            String[] targetArray = new String[]{"minecraft:ender_dragon,4,1", "minecraft:wither,2,1"};
            this.regenTargets = builder.comment(new String[]{"Adding lines / removing lines specifies which mobs will cause the players to regen max health", "Syntax: modid:mobname,healthRegenned,amount", "For wildcards use *. For instance [*:*,1,20] would mean every 20 kills regain half a heart", "While [minecraft:*,1,10] would mean every 10 kills of vanilla mobs regains half a heart"}).defineListAllowEmpty(Collections.singletonList("regenTargets"), () -> Arrays.asList(targetArray), o -> o instanceof String);
            builder.pop();
        }
    }
}

