/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.unhealthydying.handlers;

import com.mrbysco.unhealthydying.UnhealthyDying;
import com.mrbysco.unhealthydying.config.EnumHealthSetting;
import com.mrbysco.unhealthydying.config.UnhealthyConfig;
import com.mrbysco.unhealthydying.util.UnhealthyHelper;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.Team;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.math.NumberUtils;

public class EasterEgg {
    @SubscribeEvent
    public void killedEntityEvent(LivingDeathEvent event) {
        List targets;
        if (((Boolean)UnhealthyConfig.SERVER.regenHealth.get()).booleanValue() && !(targets = (List)UnhealthyConfig.SERVER.regenTargets.get()).isEmpty()) {
            for (String target : targets) {
                String[] targetInfo;
                Entity entity = event.getSource().m_7639_();
                if (!(entity instanceof Player)) continue;
                Player player = (Player)entity;
                if (event.getSource().m_7639_() instanceof FakePlayer || (targetInfo = target.split(",")).length <= 2) continue;
                ResourceLocation entityLocation = event.getEntityLiving().m_6095_().getRegistryName();
                int healthFromKill = NumberUtils.toInt((String)targetInfo[1], (int)0);
                int targetAmount = NumberUtils.toInt((String)targetInfo[2], (int)0);
                if (!targetInfo[0].contains(":") || entityLocation == null) continue;
                String[] splitResource = targetInfo[0].split(":");
                if (targetInfo[0].equals("*:*")) {
                    this.processKill(player, targetInfo[0], healthFromKill, targetAmount);
                    continue;
                }
                if (splitResource[0].equals("*") || splitResource[1].equals("*")) {
                    if (splitResource[0].equals("*") && entityLocation.m_135815_().equals(splitResource[1])) {
                        this.processKill(player, targetInfo[0], healthFromKill, targetAmount);
                        continue;
                    }
                    if (!splitResource[1].equals("*") || !entityLocation.m_135827_().equals(splitResource[0])) continue;
                    this.processKill(player, targetInfo[0], healthFromKill, targetAmount);
                    continue;
                }
                if (!new ResourceLocation(targetInfo[0]).equals((Object)entityLocation)) continue;
                this.processKill(player, targetInfo[0], healthFromKill, targetAmount);
            }
        }
    }

    public void processKill(Player player, String target, int healthGained, int targetAmount) {
        float maxRegained;
        float playerHealth = player.m_21233_();
        if (playerHealth < (maxRegained = (float)((Integer)UnhealthyConfig.SERVER.maxRegained.get()).intValue())) {
            if (targetAmount == 1) {
                switch ((EnumHealthSetting)((Object)UnhealthyConfig.SERVER.healthSetting.get())) {
                    case EVERYBODY: {
                        UnhealthyHelper.setEveryonesHealth(player, healthGained);
                        break;
                    }
                    case SCOREBOARD_TEAM: {
                        UnhealthyHelper.setScoreboardHealth(player, healthGained);
                        break;
                    }
                    default: {
                        UnhealthyHelper.setHealth(player, healthGained);
                        break;
                    }
                }
            } else {
                String customTag = "unhealthydying:" + target + ":" + targetAmount;
                switch ((EnumHealthSetting)((Object)UnhealthyConfig.SERVER.healthSetting.get())) {
                    case EVERYBODY: {
                        EasterEgg.setEveryonesKillCount(player, customTag, healthGained, targetAmount);
                        break;
                    }
                    case SCOREBOARD_TEAM: {
                        EasterEgg.setScoreboardKillCount(player, customTag, targetAmount, healthGained);
                        break;
                    }
                    default: {
                        EasterEgg.setAmountData(player, customTag, targetAmount, healthGained);
                    }
                }
            }
        }
    }

    public static void setEveryonesKillCount(Player player, String customTag, int healthGained, int targetAmount) {
        for (Player players : player.f_19853_.m_6907_()) {
            if (players.equals((Object)player)) {
                EasterEgg.setAmountData(player, customTag, healthGained, targetAmount);
                continue;
            }
            EasterEgg.setAmountData(players, customTag, healthGained, targetAmount);
        }
    }

    public static void setScoreboardKillCount(Player player, String customTag, int healthGained, int targetAmount) {
        Level level = player.f_19853_;
        if (player.m_5647_() != null) {
            Team team = player.m_5647_();
            for (Player players : level.m_6907_()) {
                if (players.equals((Object)player)) {
                    EasterEgg.setAmountData(player, customTag, healthGained, targetAmount);
                    continue;
                }
                if (!players.m_20031_(team)) continue;
                EasterEgg.setAmountData(players, customTag, healthGained, targetAmount);
            }
        } else {
            UnhealthyDying.LOGGER.error(player.m_7755_() + " is not in a team");
        }
    }

    public static void setAmountData(Player player, String customTag, int targetAmount, int healthGained) {
        CompoundTag playerData = player.getPersistentData();
        if (playerData.m_128441_(customTag)) {
            int currentAmount = playerData.m_128451_(customTag);
            if (currentAmount + 1 >= targetAmount) {
                switch ((EnumHealthSetting)((Object)UnhealthyConfig.SERVER.healthSetting.get())) {
                    case EVERYBODY: {
                        UnhealthyHelper.setEveryonesHealth(player, healthGained);
                        break;
                    }
                    case SCOREBOARD_TEAM: {
                        UnhealthyHelper.setScoreboardHealth(player, healthGained);
                        break;
                    }
                    default: {
                        UnhealthyHelper.setHealth(player, healthGained);
                    }
                }
                playerData.m_128473_(customTag);
            } else {
                playerData.m_128405_(customTag, currentAmount + 1);
            }
        } else {
            playerData.m_128405_(customTag, 1);
        }
    }
}

