/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.unhealthydying.handlers;

import com.mrbysco.unhealthydying.config.EnumHealthSetting;
import com.mrbysco.unhealthydying.config.UnhealthyConfig;
import com.mrbysco.unhealthydying.util.UnhealthyHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class HealthHandler {
    @SubscribeEvent(priority=EventPriority.LOW)
    public void onJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (!player.f_19853_.f_46443_) {
            UnhealthyHelper.initializeModifier(player, 0.0);
            UnhealthyHelper.syncHealth(player);
        }
    }

    @SubscribeEvent
    public void setHealth(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (!event.isEndConquered()) {
            int healthPerDeath = -((Integer)UnhealthyConfig.SERVER.healthPerDeath.get()).intValue();
            switch ((EnumHealthSetting)((Object)UnhealthyConfig.SERVER.healthSetting.get())) {
                case EVERYBODY: {
                    UnhealthyHelper.setEveryonesHealth(player, healthPerDeath);
                    break;
                }
                case SCOREBOARD_TEAM: {
                    UnhealthyHelper.setScoreboardHealth(player, healthPerDeath);
                    break;
                }
                default: {
                    UnhealthyHelper.setHealth(player, healthPerDeath);
                    break;
                }
            }
        } else {
            UnhealthyHelper.syncHealth(player);
        }
    }
}

