/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.unhealthydying.util;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class ModifierWorldData
extends SavedData {
    private static final String DATA_NAME = "unhealthydying_world_data";
    private static final String MODIFIER_TAG = "stored_modifiers";
    private static final String EVERYBODY_TAG = "EverybodyModifier";
    private CompoundTag modifierTag;

    public ModifierWorldData(CompoundTag tag) {
        this.setModifierTag(tag);
    }

    public ModifierWorldData() {
        this(new CompoundTag());
    }

    public static ModifierWorldData load(CompoundTag nbt) {
        if (nbt.m_128441_(MODIFIER_TAG)) {
            return new ModifierWorldData((CompoundTag)nbt.m_128423_(MODIFIER_TAG));
        }
        return new ModifierWorldData();
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        compound.m_128365_(MODIFIER_TAG, (Tag)this.modifierTag);
        return compound;
    }

    public CompoundTag getModifierTag() {
        return this.modifierTag;
    }

    public void setModifierTag(CompoundTag modifierTag) {
        this.modifierTag = modifierTag;
    }

    public void setScoreboardTeamModifier(String scoreboardName, int healthModifier) {
        String teamTag = "Scoreboard" + scoreboardName + "Modifier";
        this.getModifierTag().m_128405_(teamTag, healthModifier);
    }

    public int getScoreboardTeamModifier(String scoreboardName) {
        String teamTag = "Scoreboard" + scoreboardName + "Modifier";
        if (this.getModifierTag().m_128441_(teamTag)) {
            return this.getModifierTag().m_128451_(teamTag);
        }
        this.getModifierTag().m_128405_(teamTag, 0);
        return 0;
    }

    public void setEverybodyModifier(int healthModifier) {
        this.getModifierTag().m_128405_(EVERYBODY_TAG, healthModifier);
    }

    public int getEverybodyModifier() {
        if (this.getModifierTag().m_128441_(EVERYBODY_TAG)) {
            return this.getModifierTag().m_128451_(EVERYBODY_TAG);
        }
        this.getModifierTag().m_128405_(EVERYBODY_TAG, 0);
        return 0;
    }

    public void setPlayerModifier(UUID uuid, int healthModifier) {
        this.getModifierTag().m_128405_(uuid.toString(), healthModifier);
    }

    public int getPlayerModifier(UUID uuid) {
        if (this.getModifierTag().m_128441_(uuid.toString())) {
            return this.getModifierTag().m_128451_(uuid.toString());
        }
        this.getModifierTag().m_128405_(uuid.toString(), 0);
        return 0;
    }

    public static ModifierWorldData get(Level level) {
        if (!(level instanceof ServerLevel)) {
            throw new RuntimeException("Attempted to get the data from a client world. This is wrong.");
        }
        ServerLevel overworld = level.m_142572_().m_129880_(Level.f_46428_);
        DimensionDataStorage storage = overworld.m_8895_();
        return (ModifierWorldData)storage.m_164861_(ModifierWorldData::load, ModifierWorldData::new, DATA_NAME);
    }
}

