/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.unhealthydying.util;

import com.mrbysco.unhealthydying.Reference;
import com.mrbysco.unhealthydying.UnhealthyDying;
import com.mrbysco.unhealthydying.config.EnumHealthSetting;
import com.mrbysco.unhealthydying.config.UnhealthyConfig;
import com.mrbysco.unhealthydying.util.HealthUtil;
import com.mrbysco.unhealthydying.util.ModifierWorldData;
import javax.annotation.Nullable;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.Team;

public class UnhealthyHelper {
    public static void initializeModifier(Player player, double modifier) {
        AttributeInstance attributeInstance;
        if (!player.f_19853_.f_46443_ && (attributeInstance = player.m_21051_(Attributes.f_22276_)) != null && attributeInstance.m_22111_(Reference.HEALTH_MODIFIER_ID) == null) {
            attributeInstance.m_22125_(UnhealthyHelper.getModifier(modifier));
        }
    }

    public static void changeModifier(Player player, double modifierValue) {
        if (!player.f_19853_.f_46443_) {
            AttributeInstance attributeInstance = player.m_21051_(Attributes.f_22276_);
            AttributeModifier modifier = UnhealthyHelper.getModifier(modifierValue);
            if (attributeInstance != null) {
                if (attributeInstance.m_22111_(Reference.HEALTH_MODIFIER_ID) != null) {
                    attributeInstance.m_22127_(Reference.HEALTH_MODIFIER_ID);
                }
                HealthUtil.sendHealthMessage(player, (int)attributeInstance.m_22135_(), (int)modifierValue);
                attributeInstance.m_22125_(modifier);
            }
        }
    }

    public static AttributeModifier getModifier(double modifier) {
        return new AttributeModifier(Reference.HEALTH_MODIFIER_ID, () -> "UnhealthyHealthModifier", modifier, AttributeModifier.Operation.ADDITION);
    }

    @Nullable
    public static ModifierWorldData getSavedData(Player player) {
        return !player.f_19853_.f_46443_ ? ModifierWorldData.get((Level)player.m_20194_().m_129880_(Level.f_46428_)) : null;
    }

    public static void setEveryonesHealth(Player player, int changeModifier) {
        UnhealthyHelper.setEveryonesHealth(player, changeModifier, true);
    }

    public static void setEveryonesHealth(Player player, int changeModifier, boolean recalculate) {
        ModifierWorldData worldData = UnhealthyHelper.getSavedData(player);
        if (worldData != null) {
            int savedModifier;
            int n = savedModifier = recalculate ? worldData.getEverybodyModifier() : changeModifier;
            if (recalculate) {
                savedModifier += changeModifier;
                savedModifier = (int)UnhealthyHelper.safetyCheck(player, savedModifier);
            }
            worldData.setEverybodyModifier(savedModifier);
            worldData.m_77762_();
            for (Player players : player.f_19853_.m_6907_()) {
                UnhealthyHelper.changeModifier(players, savedModifier);
            }
        }
    }

    public static void setScoreboardHealth(Player player, int changeModifier) {
        UnhealthyHelper.setScoreboardHealth(player, changeModifier, true);
    }

    public static void setScoreboardHealth(Player player, int changeModifier, boolean recalculate) {
        if (player.m_5647_() != null) {
            Team team = player.m_5647_();
            ModifierWorldData worldData = UnhealthyHelper.getSavedData(player);
            if (worldData != null) {
                int savedModifier;
                int n = savedModifier = recalculate ? worldData.getScoreboardTeamModifier(team.m_5758_()) : changeModifier;
                if (recalculate) {
                    savedModifier += changeModifier;
                    savedModifier = (int)UnhealthyHelper.safetyCheck(player, savedModifier);
                }
                worldData.setScoreboardTeamModifier(team.m_5758_(), savedModifier);
                worldData.m_77762_();
                for (Player players : player.f_19853_.m_6907_()) {
                    UnhealthyHelper.changeModifier(players, savedModifier);
                }
            }
        } else {
            UnhealthyDying.LOGGER.error(player.m_7755_() + " is not in a team");
        }
    }

    public static void setHealth(Player player, int changeModifier) {
        UnhealthyHelper.setHealth(player, changeModifier, true);
    }

    public static void setHealth(Player player, int changeModifier, boolean recalculate) {
        ModifierWorldData worldData = UnhealthyHelper.getSavedData(player);
        if (worldData != null) {
            int savedModifier;
            int n = savedModifier = recalculate ? worldData.getPlayerModifier(player.m_36316_().getId()) : changeModifier;
            if (recalculate) {
                savedModifier += changeModifier;
                savedModifier = (int)UnhealthyHelper.safetyCheck(player, savedModifier);
            }
            worldData.setPlayerModifier(player.m_36316_().getId(), savedModifier);
            worldData.m_77762_();
            UnhealthyHelper.changeModifier(player, savedModifier);
        }
    }

    public static void syncHealth(Player player) {
        ModifierWorldData worldData = UnhealthyHelper.getSavedData(player);
        if (worldData != null) {
            switch ((EnumHealthSetting)((Object)UnhealthyConfig.SERVER.healthSetting.get())) {
                case EVERYBODY: {
                    UnhealthyHelper.setEveryonesHealth(player, worldData.getEverybodyModifier(), false);
                    break;
                }
                case SCOREBOARD_TEAM: {
                    if (player.m_5647_() == null) break;
                    UnhealthyHelper.setScoreboardHealth(player, worldData.getScoreboardTeamModifier(player.m_5647_().m_5758_()), false);
                    break;
                }
                default: {
                    UnhealthyHelper.setHealth(player, worldData.getPlayerModifier(player.m_36316_().getId()), false);
                }
            }
        }
    }

    public static double getModifierForAmount(Player player, double healthWanted) {
        AttributeInstance attributeInstance = player.m_21051_(Attributes.f_22276_);
        if (attributeInstance != null) {
            double health = attributeInstance.m_22115_();
            double modifierRequired = healthWanted - health;
            if (((Boolean)UnhealthyConfig.SERVER.regenHealth.get()).booleanValue() && healthWanted > (double)((Integer)UnhealthyConfig.SERVER.maxRegained.get()).intValue()) {
                modifierRequired = health - (double)((Integer)UnhealthyConfig.SERVER.maxRegained.get()).intValue();
            }
            if (healthWanted < (double)((Integer)UnhealthyConfig.SERVER.minimumHealth.get()).intValue()) {
                modifierRequired = (double)((Integer)UnhealthyConfig.SERVER.minimumHealth.get()).intValue() - health;
            }
            return modifierRequired;
        }
        UnhealthyDying.LOGGER.error("Something went wrong. Somehow the player has no max_health attribute applied");
        return 0.0;
    }

    public static double safetyCheck(Player player, double modifierValue) {
        AttributeInstance attributeInstance = player.m_21051_(Attributes.f_22276_);
        if (attributeInstance != null) {
            AttributeModifier currentModifier = attributeInstance.m_22111_(Reference.HEALTH_MODIFIER_ID);
            double health = attributeInstance.m_22115_();
            if (currentModifier != null) {
                health -= currentModifier.m_22218_();
            }
            double modifiedHealth = health + modifierValue;
            double usedModifier = modifierValue;
            if (((Boolean)UnhealthyConfig.SERVER.regenHealth.get()).booleanValue() && modifiedHealth > (double)((Integer)UnhealthyConfig.SERVER.maxRegained.get()).intValue()) {
                usedModifier = modifiedHealth - (double)((Integer)UnhealthyConfig.SERVER.maxRegained.get()).intValue();
            }
            if (modifiedHealth < (double)((Integer)UnhealthyConfig.SERVER.minimumHealth.get()).intValue()) {
                usedModifier = (double)((Integer)UnhealthyConfig.SERVER.minimumHealth.get()).intValue() - health;
            }
            return usedModifier;
        }
        UnhealthyDying.LOGGER.error("Something went wrong. Somehow the player has no max_health attribute applied");
        return 0.0;
    }
}

