/*
 * Decompiled with CFR 0.152.
 */
package com.Rolfmao.upgradednetherite.config;

import com.electronwill.nightconfig.core.file.FileConfig;
import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(modid="upgradednetherite", bus=Mod.EventBusSubscriber.Bus.MOD)
public class UpgradedNetheriteConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ArmorOptions ARMOR_OPTIONS = new ArmorOptions(BUILDER);
    public static ForgeConfigSpec spec = BUILDER.build();

    public static class Helper {
        private static final FileConfig CONFIG_FILE = FileConfig.of((File)new File(FMLPaths.CONFIGDIR.get().toFile(), "upgradednetherite-common.toml"));

        public static <T> T get(String category, String subCategory, String value) {
            return Helper.get(category + "." + subCategory, value);
        }

        public static <T> T get(String category, String value) {
            CONFIG_FILE.load();
            return (T)CONFIG_FILE.get(category + "." + value);
        }

        public static String getSubConfig(String category, String subCategory) {
            return category + "." + subCategory;
        }
    }

    public static class ArmorOptions {
        static final String ARMOR_OPTIONS = "Armor Options";
        public ForgeConfigSpec.BooleanValue GoldUpgradedRequireSet;
        public ForgeConfigSpec.BooleanValue FireUpgradedRequireSet;
        public ForgeConfigSpec.BooleanValue EnderUpgradedRequireSet;
        public ForgeConfigSpec.BooleanValue WaterUpgradedRequireSet;
        public ForgeConfigSpec.BooleanValue WitherUpgradedRequireSet;
        public ForgeConfigSpec.BooleanValue PoisonUpgradedRequireSet;

        ArmorOptions(ForgeConfigSpec.Builder builder) {
            builder.push(ARMOR_OPTIONS);
            this.GoldUpgradedRequireSet = builder.comment("Gold Upgraded Armor effect require to wear full set ?").define("GoldUpgradedRequireSet", true);
            this.FireUpgradedRequireSet = builder.comment("Fire Upgraded Armor effect require to wear full set ?").define("FireUpgradedRequireSet", true);
            this.EnderUpgradedRequireSet = builder.comment("Ender Upgraded Armor effect require to wear full set ?").define("EnderUpgradedRequireSet", true);
            this.WaterUpgradedRequireSet = builder.comment("Water Upgraded Armor effect require to wear full set ?").define("WaterUpgradedRequireSet", true);
            this.WitherUpgradedRequireSet = builder.comment("Wither Upgraded Armor effect require to wear full set ?").define("WitherUpgradedRequireSet", true);
            this.PoisonUpgradedRequireSet = builder.comment("Poison Upgraded Armor effect require to wear full set ?").define("PoisonUpgradedRequireSet", true);
            builder.pop();
        }
    }
}

