/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.common;

import com.mrcrayfish.vehicle.entity.EngineTier;
import com.mrcrayfish.vehicle.entity.EngineType;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.entity.WheelType;
import com.mrcrayfish.vehicle.init.ModItems;
import com.mrcrayfish.vehicle.item.WheelItem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import org.apache.commons.lang3.tuple.Pair;

public class ItemLookup {
    private static final Map<WheelType, Item> WHEEL_LOOKUP = new HashMap<WheelType, Item>();
    private static final Map<Pair<EngineType, EngineTier>, Item> ENGINE_LOOKUP = new HashMap<Pair<EngineType, EngineTier>, Item>();
    private static boolean init;

    public static void init() {
        if (init) {
            return;
        }
        WHEEL_LOOKUP.put(WheelType.STANDARD, (Item)ModItems.STANDARD_WHEEL.get());
        WHEEL_LOOKUP.put(WheelType.SPORTS, (Item)ModItems.SPORTS_WHEEL.get());
        WHEEL_LOOKUP.put(WheelType.RACING, (Item)ModItems.RACING_WHEEL.get());
        WHEEL_LOOKUP.put(WheelType.OFF_ROAD, (Item)ModItems.OFF_ROAD_WHEEL.get());
        WHEEL_LOOKUP.put(WheelType.SNOW, (Item)ModItems.SNOW_WHEEL.get());
        WHEEL_LOOKUP.put(WheelType.ALL_TERRAIN, (Item)ModItems.ALL_TERRAIN_WHEEL.get());
        WHEEL_LOOKUP.put(WheelType.PLASTIC, (Item)ModItems.PLASTIC_WHEEL.get());
        ENGINE_LOOKUP.put((Pair<EngineType, EngineTier>)Pair.of((Object)((Object)EngineType.SMALL_MOTOR), (Object)((Object)EngineTier.WOOD)), (Item)ModItems.WOOD_SMALL_ENGINE.get());
        ENGINE_LOOKUP.put((Pair<EngineType, EngineTier>)Pair.of((Object)((Object)EngineType.SMALL_MOTOR), (Object)((Object)EngineTier.STONE)), (Item)ModItems.STONE_SMALL_ENGINE.get());
        ENGINE_LOOKUP.put((Pair<EngineType, EngineTier>)Pair.of((Object)((Object)EngineType.SMALL_MOTOR), (Object)((Object)EngineTier.IRON)), (Item)ModItems.IRON_SMALL_ENGINE.get());
        ENGINE_LOOKUP.put((Pair<EngineType, EngineTier>)Pair.of((Object)((Object)EngineType.SMALL_MOTOR), (Object)((Object)EngineTier.GOLD)), (Item)ModItems.GOLD_SMALL_ENGINE.get());
        ENGINE_LOOKUP.put((Pair<EngineType, EngineTier>)Pair.of((Object)((Object)EngineType.SMALL_MOTOR), (Object)((Object)EngineTier.DIAMOND)), (Item)ModItems.DIAMOND_SMALL_ENGINE.get());
        ENGINE_LOOKUP.put((Pair<EngineType, EngineTier>)Pair.of((Object)((Object)EngineType.LARGE_MOTOR), (Object)((Object)EngineTier.WOOD)), (Item)ModItems.WOOD_LARGE_ENGINE.get());
        ENGINE_LOOKUP.put((Pair<EngineType, EngineTier>)Pair.of((Object)((Object)EngineType.LARGE_MOTOR), (Object)((Object)EngineTier.STONE)), (Item)ModItems.STONE_LARGE_ENGINE.get());
        ENGINE_LOOKUP.put((Pair<EngineType, EngineTier>)Pair.of((Object)((Object)EngineType.LARGE_MOTOR), (Object)((Object)EngineTier.IRON)), (Item)ModItems.IRON_LARGE_ENGINE.get());
        ENGINE_LOOKUP.put((Pair<EngineType, EngineTier>)Pair.of((Object)((Object)EngineType.LARGE_MOTOR), (Object)((Object)EngineTier.GOLD)), (Item)ModItems.GOLD_LARGE_ENGINE.get());
        ENGINE_LOOKUP.put((Pair<EngineType, EngineTier>)Pair.of((Object)((Object)EngineType.LARGE_MOTOR), (Object)((Object)EngineTier.DIAMOND)), (Item)ModItems.DIAMOND_LARGE_ENGINE.get());
        ENGINE_LOOKUP.put((Pair<EngineType, EngineTier>)Pair.of((Object)((Object)EngineType.ELECTRIC_MOTOR), (Object)((Object)EngineTier.WOOD)), (Item)ModItems.WOOD_ELECTRIC_ENGINE.get());
        ENGINE_LOOKUP.put((Pair<EngineType, EngineTier>)Pair.of((Object)((Object)EngineType.ELECTRIC_MOTOR), (Object)((Object)EngineTier.STONE)), (Item)ModItems.STONE_ELECTRIC_ENGINE.get());
        ENGINE_LOOKUP.put((Pair<EngineType, EngineTier>)Pair.of((Object)((Object)EngineType.ELECTRIC_MOTOR), (Object)((Object)EngineTier.IRON)), (Item)ModItems.IRON_ELECTRIC_ENGINE.get());
        ENGINE_LOOKUP.put((Pair<EngineType, EngineTier>)Pair.of((Object)((Object)EngineType.ELECTRIC_MOTOR), (Object)((Object)EngineTier.GOLD)), (Item)ModItems.GOLD_ELECTRIC_ENGINE.get());
        ENGINE_LOOKUP.put((Pair<EngineType, EngineTier>)Pair.of((Object)((Object)EngineType.ELECTRIC_MOTOR), (Object)((Object)EngineTier.DIAMOND)), (Item)ModItems.DIAMOND_ELECTRIC_ENGINE.get());
        init = true;
    }

    public static ItemStack getWheel(PoweredVehicleEntity entity) {
        ItemStack wheel;
        if (entity.hasWheels() && !(wheel = new ItemStack((IItemProvider)WHEEL_LOOKUP.getOrDefault((Object)entity.getWheelType(), Items.field_190931_a))).func_190926_b() && wheel.func_77973_b() instanceof WheelItem) {
            WheelItem wheelItem = (WheelItem)wheel.func_77973_b();
            int wheelColor = entity.getWheelColor();
            if (wheelColor != -1) {
                wheelItem.setColor(wheel, wheelColor);
            }
            return wheel;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getEngine(PoweredVehicleEntity entity) {
        if (entity.hasEngine()) {
            return new ItemStack((IItemProvider)ENGINE_LOOKUP.getOrDefault(Pair.of((Object)((Object)entity.getEngineType()), (Object)((Object)entity.getEngineTier())), Items.field_190931_a));
        }
        return ItemStack.field_190927_a;
    }
}

