/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity;

import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.FluidState;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class BoatEntity
extends PoweredVehicleEntity {
    protected State state;
    protected State previousState;
    private double waterLevel;

    public BoatEntity(EntityType<?> entityType, World worldIn) {
        super(entityType, worldIn);
        this.setMaxTurnAngle(65);
    }

    @Override
    public boolean canChangeWheels() {
        return false;
    }

    @Override
    public void updateVehicleMotion() {
        if (this.state == State.IN_WATER || this.state == State.UNDER_WATER) {
            if (this.state == State.UNDER_WATER) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.08, 0.0));
            } else {
                double floatingY = (this.waterLevel - 0.35 + 0.25 * (double)Math.min(1.0f, this.getNormalSpeed()) - this.func_226278_cu_()) / (double)this.func_213302_cg();
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, floatingY * 0.05, 0.0));
                if (Math.abs(floatingY) < 0.1 && this.func_213322_ci().field_72448_b > 0.0 && Math.abs(this.func_213322_ci().field_72448_b) < 0.1) {
                    this.func_70107_b(this.func_226277_ct_(), this.waterLevel - 0.35 + 0.25 * (double)Math.min(1.0f, this.getNormalSpeed()), this.func_226281_cx_());
                    this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
                }
                this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.75, 1.0));
            }
            float f1 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) / 20.0f;
            float f2 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) / 20.0f;
            this.vehicleMotionX = -this.currentSpeed * f1;
            this.vehicleMotionZ = this.currentSpeed * f2;
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.5, 1.0, 0.5));
        } else if (this.state == State.IN_AIR) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.08, 0.0));
            if (this.previousState == State.UNDER_WATER || this.previousState == State.IN_WATER) {
                this.func_213317_d(new Vector3d((double)this.vehicleMotionX, this.func_213322_ci().field_72448_b, (double)this.vehicleMotionZ));
                this.vehicleMotionX = 0.0f;
                this.vehicleMotionZ = 0.0f;
            }
        } else {
            this.vehicleMotionX *= 0.75f;
            this.vehicleMotionZ *= 0.75f;
        }
    }

    @Override
    public void updateVehicle() {
        this.previousState = this.state;
        this.state = this.getState();
        if (this.state == State.IN_AIR) {
            this.deltaYaw *= 2.0f;
        }
    }

    private boolean checkInWater() {
        AxisAlignedBB boundingBox = this.func_174813_aQ();
        int minX = MathHelper.func_76128_c((double)boundingBox.field_72340_a);
        int maxX = MathHelper.func_76143_f((double)boundingBox.field_72336_d);
        int minY = MathHelper.func_76128_c((double)boundingBox.field_72338_b);
        int maxY = MathHelper.func_76143_f((double)(boundingBox.field_72338_b + 0.001));
        int minZ = MathHelper.func_76128_c((double)boundingBox.field_72339_c);
        int maxZ = MathHelper.func_76143_f((double)boundingBox.field_72334_f);
        boolean inWater = false;
        this.waterLevel = Double.MIN_VALUE;
        BlockPos.Mutable pooledMutable = new BlockPos.Mutable();
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                for (int z = minZ; z < maxZ; ++z) {
                    pooledMutable.func_181079_c(x, y, z);
                    FluidState fluidState = this.field_70170_p.func_204610_c((BlockPos)pooledMutable);
                    if (!fluidState.func_206884_a((ITag)FluidTags.field_206959_a)) continue;
                    float waterLevel = (float)y + fluidState.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)pooledMutable);
                    this.waterLevel = Math.max((double)waterLevel, this.waterLevel);
                    inWater |= boundingBox.field_72338_b < (double)waterLevel;
                }
            }
        }
        return inWater;
    }

    @Nullable
    private State getUnderwaterState() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        double height = axisalignedbb.field_72337_e + 0.001;
        int minX = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int maxX = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int minY = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int maxY = MathHelper.func_76143_f((double)height);
        int minZ = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int maxZ = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean underWater = false;
        BlockPos.Mutable pooledMutable = new BlockPos.Mutable();
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                for (int z = minZ; z < maxZ; ++z) {
                    pooledMutable.func_181079_c(x, y, z);
                    FluidState fluidState = this.field_70170_p.func_204610_c((BlockPos)pooledMutable);
                    if (!fluidState.func_206884_a((ITag)FluidTags.field_206959_a) || !(height < (double)((float)pooledMutable.func_177956_o() + fluidState.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)pooledMutable)))) continue;
                    if (!fluidState.func_206889_d()) {
                        return State.UNDER_FLOWING_WATER;
                    }
                    underWater = true;
                }
            }
        }
        return underWater ? State.UNDER_WATER : null;
    }

    protected State getState() {
        State state = this.getUnderwaterState();
        if (state != null) {
            return state;
        }
        if (this.checkInWater()) {
            return State.IN_WATER;
        }
        if (this.field_70122_E) {
            return State.ON_LAND;
        }
        return State.IN_AIR;
    }

    @Override
    protected void updateGroundState() {
        this.wheelsOnGround = this.getState() == State.IN_WATER || this.getState() == State.UNDER_WATER;
    }

    protected static enum State {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        ON_LAND,
        IN_AIR;

    }
}

