/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.network.message;

import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.network.message.IMessage;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessagePower
implements IMessage<MessagePower> {
    private float power;

    public MessagePower() {
    }

    public MessagePower(float power) {
        this.power = power;
    }

    @Override
    public void encode(MessagePower message, PacketBuffer buffer) {
        buffer.writeFloat(message.power);
    }

    @Override
    public MessagePower decode(PacketBuffer buffer) {
        return new MessagePower(buffer.readFloat());
    }

    @Override
    public void handle(MessagePower message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            Entity riding;
            ServerPlayerEntity player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (riding = player.func_184187_bx()) instanceof PoweredVehicleEntity) {
                ((PoweredVehicleEntity)riding).setPower(message.power);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

