/*
 * Decompiled with CFR 0.152.
 */
package quarris.voidtanks.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraftforge.fluids.FluidStack;
import quarris.voidtanks.content.TankTile;

public class TankRenderer
extends TileEntityRenderer<TankTile> {
    public TankRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TankTile tank, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        FluidStack fluidStack = tank.getFluid();
        if (!fluidStack.isEmpty()) {
            int amount = fluidStack.getAmount();
            int total = tank.getTank().getTankCapacity(0);
            this.renderFluidInTank((ILightReader)tank.func_145831_w(), tank.func_174877_v(), fluidStack, matrix, buffer, (float)amount / (float)total);
        }
    }

    private void renderFluidInTank(ILightReader world, BlockPos pos, FluidStack fluid, MatrixStack matrix, IRenderTypeBuffer buffer, float fluidPerc) {
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.5, 0.5, 0.5);
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        Matrix3f matrix3f = matrix.func_227866_c_().func_227872_b_();
        int color = fluid.getFluid().getAttributes().getColor(world, pos);
        TextureAtlasSprite sprite = this.getFluidStillSprite(fluid.getFluid());
        IVertexBuilder builder = buffer.getBuffer(RenderType.func_228658_l_((ResourceLocation)sprite.func_229241_m_().func_229223_g_()));
        for (int i = 0; i < 4; ++i) {
            this.renderNorthFluidFace(sprite, matrix4f, matrix3f, builder, color, fluidPerc);
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        }
        this.renderTopFluidFace(sprite, matrix4f, matrix3f, builder, color, fluidPerc);
        matrix.func_227865_b_();
    }

    private void renderTopFluidFace(TextureAtlasSprite sprite, Matrix4f matrix4f, Matrix3f normalMatrix, IVertexBuilder builder, int color, float fluidPerc) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float width = 0.625f;
        float height = 0.875f;
        float minU = sprite.func_94214_a(3.0);
        float maxU = sprite.func_94214_a(13.0);
        float minV = sprite.func_94207_b(3.0);
        float maxV = sprite.func_94207_b(13.0);
        builder.func_227888_a_(matrix4f, -width / 2.0f, -height / 2.0f + fluidPerc * height, -width / 2.0f).func_227885_a_(r, g, b, a).func_225583_a_(minU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(normalMatrix, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(matrix4f, -width / 2.0f, -height / 2.0f + fluidPerc * height, width / 2.0f).func_227885_a_(r, g, b, a).func_225583_a_(minU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(normalMatrix, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(matrix4f, width / 2.0f, -height / 2.0f + fluidPerc * height, width / 2.0f).func_227885_a_(r, g, b, a).func_225583_a_(maxU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(normalMatrix, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(matrix4f, width / 2.0f, -height / 2.0f + fluidPerc * height, -width / 2.0f).func_227885_a_(r, g, b, a).func_225583_a_(maxU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(normalMatrix, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    private void renderNorthFluidFace(TextureAtlasSprite sprite, Matrix4f matrix4f, Matrix3f normalMatrix, IVertexBuilder builder, int color, float fluidPerc) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float width = 0.625f;
        float height = 0.875f;
        float minU = sprite.func_94214_a(3.0);
        float maxU = sprite.func_94214_a(13.0);
        float minV = sprite.func_94207_b(1.0);
        float maxV = sprite.func_94207_b((double)(15.0f * fluidPerc));
        builder.func_227888_a_(matrix4f, -width / 2.0f, -height / 2.0f + height * fluidPerc, -0.3f).func_227885_a_(r, g, b, a).func_225583_a_(minU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(normalMatrix, 0.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(matrix4f, width / 2.0f, -height / 2.0f + height * fluidPerc, -0.3f).func_227885_a_(r, g, b, a).func_225583_a_(maxU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(normalMatrix, 0.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(matrix4f, width / 2.0f, -height / 2.0f, -0.3f).func_227885_a_(r, g, b, a).func_225583_a_(maxU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(normalMatrix, 0.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(matrix4f, -width / 2.0f, -height / 2.0f, -0.3f).func_227885_a_(r, g, b, a).func_225583_a_(minU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(normalMatrix, 0.0f, 0.0f, 1.0f).func_181675_d();
    }

    private TextureAtlasSprite getFluidStillSprite(Fluid fluid) {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluid.getAttributes().getStillTexture());
    }

    private TextureAtlasSprite getFluidFlowingSprite(Fluid fluid) {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluid.getAttributes().getFlowingTexture());
    }
}

