/*
 * Decompiled with CFR 0.152.
 */
package quarris.voidtanks.content;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import quarris.voidtanks.VoidTanks;
import quarris.voidtanks.content.TankTile;

public class TankBlock
extends ContainerBlock {
    public static final BooleanProperty IS_VOID = BooleanProperty.func_177716_a((String)"is_void");
    private static final VoxelShape TOP_CAP = VoxelShapes.func_197873_a((double)0.0, (double)0.9375, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    private static final VoxelShape CENTER = VoxelShapes.func_197873_a((double)0.0625, (double)0.0625, (double)0.0625, (double)0.9375, (double)0.9375, (double)0.9375);
    private static final VoxelShape BOTTOM_CAP = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0);
    private static final VoxelShape TANK_SHAPE = VoxelShapes.func_197872_a((VoxelShape)CENTER, (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)TOP_CAP, (VoxelShape)BOTTOM_CAP));
    public final int buckets;

    public TankBlock(int buckets) {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).harvestTool(ToolType.PICKAXE).func_200943_b(2.0f).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)IS_VOID, (Comparable)Boolean.valueOf(false)));
        this.buckets = buckets;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{IS_VOID});
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack held = player.func_184586_b(hand);
        if (!((Boolean)state.func_177229_b((IProperty)IS_VOID)).booleanValue() && held.func_77973_b() == VoidTanks.VOID_UPGRADE) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)IS_VOID, (Comparable)Boolean.valueOf(true)));
            if (!player.func_184812_l_()) {
                held.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        if (((Boolean)state.func_177229_b((IProperty)IS_VOID)).booleanValue() && player.func_225608_bj_()) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)IS_VOID, (Comparable)Boolean.valueOf(false)));
            if (!world.field_72995_K) {
                ItemStack obsidian = new ItemStack((IItemProvider)VoidTanks.VOID_UPGRADE);
                if (!player.func_184812_l_() && !player.func_191521_c(obsidian)) {
                    InventoryHelper.func_180173_a((World)world, (double)player.func_226277_ct_(), (double)player.func_226280_cw_(), (double)player.func_226281_cx_(), (ItemStack)obsidian);
                }
            }
        }
        if (FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (World)world, (BlockPos)pos, (Direction)hit.func_216354_b()) || held.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List drops = super.func_220076_a(state, builder);
        if (((Boolean)state.func_177229_b((IProperty)IS_VOID)).booleanValue()) {
            drops.add(new ItemStack((IItemProvider)VoidTanks.VOID_UPGRADE));
        }
        return drops;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return TANK_SHAPE;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TankTile(this.buckets);
    }
}

