/*
 * Decompiled with CFR 0.152.
 */
package quarris.voidtanks.content;

import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import quarris.voidtanks.VoidTanks;
import quarris.voidtanks.content.TankBlock;

public class TankTile
extends TileEntity {
    public static final TileEntityType<TankTile> TYPE = TileEntityType.Builder.func_223042_a(TankTile::new, (Block[])new Block[]{VoidTanks.SMALL_TANK, VoidTanks.MEDIUM_TANK, VoidTanks.LARGE_TANK, VoidTanks.HUGE_TANK}).func_206865_a(null);
    private FluidTank tank;
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);

    public TankTile() {
        this(0);
    }

    public TankTile(int buckets) {
        super(TYPE);
        this.tank = new FluidTank(buckets * 1000){

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                int filled = super.fill(resource, action);
                return TankTile.this.isVoid() && resource.isFluidEqual(this.getFluid()) ? resource.getAmount() : filled;
            }

            protected void onContentsChanged() {
                TankTile.this.sendToClients();
            }
        };
    }

    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public boolean isVoid() {
        return (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)TankBlock.IS_VOID);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void handleUpdateTag(CompoundNBT tag) {
        this.func_145839_a(tag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void sendToClients() {
        if (this.func_145831_w().field_72995_K) {
            VoidTanks.LOGGER.debug("Tried to sync to clients from a client.");
            return;
        }
        ServerWorld world = (ServerWorld)this.func_145831_w();
        Stream entities = world.func_72863_F().field_217237_a.func_219097_a(new ChunkPos(this.func_174877_v()), false);
        SUpdateTileEntityPacket packet = this.func_189518_D_();
        entities.forEach(e -> e.field_71135_a.func_147359_a((IPacket)packet));
    }

    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.tank.readFromNBT(tag);
        this.tank.setCapacity(tag.func_74762_e("FluidCapacity"));
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        this.tank.writeToNBT(tag);
        tag.func_74768_a("FluidCapacity", this.tank.getCapacity());
        return tag;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }
}

