/*
 * Decompiled with CFR 0.152.
 */
package com._13rac1.erosion.common;

import com._13rac1.erosion.common.BlockFlag;
import com._13rac1.erosion.common.ErodableBlocks;
import com._13rac1.erosion.common.FluidLevel;
import com._13rac1.erosion.common.IWorld;
import com._13rac1.erosion.minecraft.EBlockPos;
import com._13rac1.erosion.minecraft.EBlockTags;
import com._13rac1.erosion.minecraft.EFluidBlock;
import com._13rac1.erosion.minecraft.EVec3d;
import com._13rac1.erosion.minecraft.EVec3i;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class Tasks {
    private static final EVec3i VECTOR_DOWN = new EVec3i(0, -1, 0);
    private static final EVec3i VECTOR_UP = new EVec3i(0, 1, 0);
    private static final EVec3i VECTOR_NORTH = new EVec3i(0, 0, -1);
    private static final EVec3i VECTOR_NORTH_EAST = new EVec3i(1, 0, -1);
    private static final EVec3i VECTOR_EAST = new EVec3i(1, 0, 0);
    private static final EVec3i VECTOR_SOUTH_EAST = new EVec3i(1, 0, 1);
    private static final EVec3i VECTOR_SOUTH = new EVec3i(0, 0, 1);
    private static final EVec3i VECTOR_SOUTH_WEST = new EVec3i(-1, 0, 1);
    private static final EVec3i VECTOR_WEST = new EVec3i(-1, 0, 0);
    private static final EVec3i VECTOR_NORTH_WEST = new EVec3i(-1, 0, -1);
    private static final Integer blockFlags = BlockFlag.PROPAGATE_CHANGE | BlockFlag.NOTIFY_LISTENERS;
    private static final List<EVec3i> posFourEdges = Arrays.asList(VECTOR_NORTH, VECTOR_EAST, VECTOR_SOUTH, VECTOR_WEST);
    private static final List<EVec3i> posEightAround = Arrays.asList(VECTOR_NORTH, VECTOR_NORTH_EAST, VECTOR_EAST, VECTOR_SOUTH_EAST, VECTOR_SOUTH, VECTOR_SOUTH_WEST, VECTOR_WEST, VECTOR_NORTH_WEST);
    private static final List<EVec3i> posEightAroundUp = Arrays.asList(new EVec3i(1, 1, 1), new EVec3i(1, 1, 0), new EVec3i(1, 1, -1), new EVec3i(0, 1, -1), new EVec3i(-1, 1, -1), new EVec3i(-1, 1, 0), new EVec3i(-1, 1, 1), new EVec3i(0, 1, 1));
    private static List<Integer> wallBreakers = Arrays.asList(FluidLevel.FLOW1, FluidLevel.FLOW2, FluidLevel.FLOW3, FluidLevel.FLOW4, FluidLevel.FLOW5, FluidLevel.FLOW6, FluidLevel.FLOW7);

    public void run(class_2680 state, IWorld world, EBlockPos pos, Random rand) {
        Integer level = (Integer)state.method_11654((class_2769)EFluidBlock.field_11278);
        this.maybeSourceBreak(state, world, pos, rand, level);
        if (this.maybeAddMoss(world, pos, rand)) {
            return;
        }
        if (level == FluidLevel.SOURCE) {
            return;
        }
        if (this.maybeFlowingWall(state, world, pos, rand, level)) {
            return;
        }
        this.maybeErodeEdge(state, world, pos, rand, level);
        this.maybeDecayUnder(state, world, pos, rand, level);
    }

    private void maybeErodeEdge(class_2680 state, IWorld world, EBlockPos pos, Random rand, Integer level) {
        EBlockPos underPos = pos.down();
        class_2248 underBlock = world.getBlock(underPos);
        if (!ErodableBlocks.canErode(underBlock)) {
            return;
        }
        if (!ErodableBlocks.maybeErode(rand, underBlock)) {
            return;
        }
        if (!this.isEdge(world, pos) && level != FluidLevel.FLOW7) {
            return;
        }
        class_2248 decayBlock = ErodableBlocks.maybeDecay(rand, underBlock);
        if (decayBlock != class_2246.field_10124) {
            world.setBlockState(underPos, decayBlock.method_9564(), blockFlags);
            return;
        }
        Integer underBlocklevel = level < FluidLevel.FALLING7 ? level + 1 : FluidLevel.FALLING7;
        world.setBlockState(underPos, (class_2680)class_2246.field_10382.method_9564().method_11657((class_2769)EFluidBlock.field_11278, (Comparable)underBlocklevel), blockFlags);
        if (state.method_11654((class_2769)EFluidBlock.field_11278) == FluidLevel.SOURCE) {
            return;
        }
        world.setBlockState(pos, class_2246.field_10124.method_9564(), blockFlags);
        Integer upDeleteCount = 0;
        EBlockPos posUp = pos.up();
        while (world.isFluidBlock(world.getBlock(posUp)).booleanValue()) {
            Integer n = upDeleteCount;
            Integer n2 = upDeleteCount = Integer.valueOf(upDeleteCount + 1);
            if (upDeleteCount > 3 || world.getBlockState(posUp).method_11654((class_2769)EFluidBlock.field_11278) == FluidLevel.SOURCE) break;
            world.setBlockState(posUp, class_2246.field_10124.method_9564(), blockFlags);
            posUp = posUp.up();
        }
    }

    protected boolean isEdge(IWorld world, EBlockPos pos) {
        List<EBlockPos> listSidePos = Arrays.asList(pos.north(), pos.south(), pos.east(), pos.west());
        for (EBlockPos sidePos : listSidePos) {
            EBlockPos underPos = sidePos.down();
            class_2248 underBlock = world.getBlock(underPos);
            if (!world.isFluidBlock(underBlock).booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected EVec3i dirTurnLeft(EVec3i in) {
        return in.crossProduct(VECTOR_DOWN);
    }

    protected EVec3i dirTurnRight(EVec3i in) {
        return in.crossProduct(VECTOR_UP);
    }

    protected boolean treeInColumn(IWorld world, EBlockPos pos) {
        Integer MAX_UP = 5;
        Integer count = 0;
        EBlockPos currentPos = pos.up();
        while (count < MAX_UP) {
            class_2248 currentBlock = world.getBlock(currentPos);
            if (EBlockTags.LOGS.method_15141((Object)currentBlock)) {
                return true;
            }
            if (this.isAir(currentBlock)) {
                return false;
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            currentPos = currentPos.up();
        }
        return false;
    }

    private boolean maybeFlowingWall(class_2680 state, IWorld world, EBlockPos pos, Random rand, Integer level) {
        wallBreakOption opt;
        Integer dist;
        EVec3i dirForward;
        EBlockPos posForward;
        class_2248 blockForward;
        if (!wallBreakers.contains(level)) {
            return false;
        }
        EVec3d velocity = world.getFlowVelocity(state, pos);
        if (Math.abs(velocity.getX()) < 0.8 && Math.abs(velocity.getZ()) < 0.8) {
            return false;
        }
        Integer Flow7Adjust = 0;
        if (level == FluidLevel.FLOW7) {
            Flow7Adjust = -1;
        }
        if (this.isAir(blockForward = world.getBlock(posForward = pos.add(dirForward = new EVec3i(Math.round(velocity.getX()), velocity.getY() + (double)Flow7Adjust.intValue(), Math.round(velocity.getZ()))))) || blockForward == class_2246.field_10382 || blockForward == class_2246.field_10164) {
            return false;
        }
        EVec3i dirLeft = this.dirTurnLeft(dirForward);
        EVec3i dirRight = this.dirTurnRight(dirForward);
        EBlockPos posLeft = pos.add(dirLeft);
        EBlockPos posRight = pos.add(dirRight);
        Boolean canErodeForward = ErodableBlocks.canErode(blockForward) && !this.treeInColumn(world, posForward);
        Boolean canErodeLeft = ErodableBlocks.canErode(world.getBlock(posLeft)) && !this.treeInColumn(world, posLeft);
        Boolean canErodeRight = ErodableBlocks.canErode(world.getBlock(posRight)) && !this.treeInColumn(world, posRight);
        if (!(canErodeForward.booleanValue() || canErodeLeft.booleanValue() || canErodeRight.booleanValue())) {
            return false;
        }
        ArrayList<wallBreakOption> options = new ArrayList<wallBreakOption>();
        if (canErodeForward.booleanValue() && (dist = this.distanceToAirWaterInFlowPath(world, pos, dirForward, level)) != 128) {
            opt = new wallBreakOption();
            opt.dir = dirForward;
            opt.distance = dist;
            options.add(opt);
        }
        if (canErodeLeft.booleanValue() && (dist = this.distanceToAirWaterInFlowPath(world, pos, dirLeft, level)) != 128) {
            opt = new wallBreakOption();
            opt.dir = dirLeft;
            opt.distance = dist;
            options.add(opt);
        }
        if (canErodeRight.booleanValue() && (dist = this.distanceToAirWaterInFlowPath(world, pos, dirRight, level)) != 128) {
            opt = new wallBreakOption();
            opt.dir = dirRight;
            opt.distance = dist;
            options.add(opt);
        }
        if (options.size() == 0) {
            return false;
        }
        Integer shortestDistance = 128;
        EVec3i shortestDir = null;
        for (wallBreakOption option : options) {
            if (option.distance >= shortestDistance) continue;
            shortestDistance = option.distance;
            shortestDir = option.dir;
        }
        if (shortestDir == null) {
            return false;
        }
        EBlockPos flowPos = pos.add(shortestDir);
        EBlockPos aboveFlowPos = flowPos.up();
        class_2248 aboveFlowBlock = world.getBlock(aboveFlowPos);
        if (EBlockTags.LOGS.method_15141((Object)aboveFlowBlock)) {
            return false;
        }
        class_2248 wallBlock = world.getBlock(flowPos);
        if (!ErodableBlocks.canErode(wallBlock)) {
            return false;
        }
        if (!ErodableBlocks.maybeErode(rand, wallBlock)) {
            return false;
        }
        world.setBlockState(flowPos, class_2246.field_10124.method_9564(), blockFlags);
        return true;
    }

    private void maybeSourceBreak(class_2680 state, IWorld world, EBlockPos pos, Random rand, Integer level) {
        if (level != FluidLevel.SOURCE) {
            return;
        }
        if (pos.getY() < world.getSeaLevel()) {
            return;
        }
        class_2248 upBlock = world.getBlockState(pos.up()).method_26204();
        if (!this.isAir(upBlock)) {
            return;
        }
        EVec3d velocity = world.getFlowVelocity(state, pos);
        if (velocity.length() > 0.0) {
            return;
        }
        List<EVec3i> listDirection = Arrays.asList(new EVec3i(1, 0, 0), new EVec3i(-1, 0, 0), new EVec3i(0, 0, 1), new EVec3i(0, 0, -1));
        Collections.shuffle(listDirection);
        for (EVec3i dir : listDirection) {
            Integer dist;
            EBlockPos sidePos = pos.add(dir);
            class_2248 sideBlock = world.getBlock(sidePos);
            if (sideBlock == class_2246.field_10382 || !ErodableBlocks.canErode(sideBlock) || !ErodableBlocks.canSourceBreak(sideBlock) || (dist = this.distanceToAirWaterInFlowPath(world, pos, dir, level)) == 128) continue;
            int waterFound = 0;
            for (int waterMultipler : Arrays.asList(1, 2, 3)) {
                EVec3i waterDirection = new EVec3i(-dir.getX() * waterMultipler, dir.getY(), -dir.getZ() * waterMultipler);
                EBlockPos maybeWaterPos = pos.add(waterDirection);
                class_2680 maybeWaterState = world.getBlockState(maybeWaterPos);
                if (maybeWaterState.method_26204() != class_2246.field_10382) break;
                ++waterFound;
            }
            if (waterFound < 1) continue;
            if (!ErodableBlocks.maybeErode(rand, sideBlock)) {
                return;
            }
            world.setBlockState(sidePos, class_2246.field_10124.method_9564(), blockFlags);
            return;
        }
    }

    private boolean isAir(class_2248 block) {
        return block == class_2246.field_10124 || block == class_2246.field_10543;
    }

    protected boolean airInFlowPath(IWorld world, EBlockPos pos, EVec3i dir) {
        int yDeeper = 0;
        for (int airMultipler : Arrays.asList(7, 14)) {
            EVec3i airDirection = new EVec3i(dir.getX() * airMultipler, dir.getY() - yDeeper, dir.getZ() * airMultipler);
            ++yDeeper;
            EBlockPos maybeAirPos = pos.add(airDirection);
            class_2248 maybeAirBlock = world.getBlock(maybeAirPos);
            if (!this.isAir(maybeAirBlock) && !EBlockTags.LEAVES.method_15141((Object)maybeAirBlock)) continue;
            return true;
        }
        return false;
    }

    protected Integer distanceToAirWaterInFlowPath(IWorld world, EBlockPos pos, EVec3i dir, Integer level) {
        class_2248 blockCurrent;
        if (level > FluidLevel.FLOW7) {
            return 128;
        }
        Integer distanceToAirWater = 0;
        Integer flowDistanceRemaining = 7 - level;
        EBlockPos posCurrent = pos;
        while (flowDistanceRemaining > 0) {
            flowDistanceRemaining = flowDistanceRemaining - 1;
            distanceToAirWater = distanceToAirWater + 1;
            blockCurrent = world.getBlock(posCurrent = posCurrent.add(dir));
            if (this.isAir(blockCurrent) || EBlockTags.LEAVES.method_15141((Object)blockCurrent) || blockCurrent == class_2246.field_10382) {
                return distanceToAirWater;
            }
            if (ErodableBlocks.canErode(blockCurrent)) continue;
            return 128;
        }
        posCurrent = posCurrent.down();
        flowDistanceRemaining = 7;
        while (flowDistanceRemaining > 0) {
            flowDistanceRemaining = flowDistanceRemaining - 1;
            distanceToAirWater = distanceToAirWater + 1;
            blockCurrent = world.getBlock(posCurrent = posCurrent.add(dir));
            if (!this.isAir(blockCurrent) && !EBlockTags.LEAVES.method_15141((Object)blockCurrent)) continue;
            return distanceToAirWater;
        }
        return 128;
    }

    protected boolean maybeDecayUnder(class_2680 state, IWorld world, EBlockPos pos, Random rand, Integer level) {
        if (level == FluidLevel.SOURCE || level > FluidLevel.FLOW7) {
            return false;
        }
        EBlockPos underPos = pos.down();
        class_2248 underBlock = world.getBlock(underPos);
        if (!ErodableBlocks.canErode(underBlock)) {
            return false;
        }
        class_2248 decayTo = ErodableBlocks.decayTo(underBlock);
        if (decayTo == class_2246.field_10124) {
            return false;
        }
        EVec3d velocity = world.getFlowVelocity(state, pos);
        if (Math.abs(velocity.getX()) < 0.8 && Math.abs(velocity.getZ()) < 0.8) {
            return false;
        }
        EBlockPos flowPos = underPos.add(new EVec3i(Math.round(velocity.getX()), 0.0, Math.round(velocity.getZ())));
        class_2248 flowBlock = world.getBlock(flowPos);
        if (!ErodableBlocks.getDecayList(underBlock).contains(flowBlock)) {
            return false;
        }
        world.setBlockState(underPos, decayTo.method_9564(), blockFlags);
        return true;
    }

    protected boolean isCobbleStone(class_2248 block) {
        return block == class_2246.field_10445 || block == class_2246.field_10625 || block == class_2246.field_10596 || block == class_2246.field_10625;
    }

    protected boolean isStoneBricks(class_2248 block) {
        return block == class_2246.field_10056 || block == class_2246.field_10252 || block == class_2246.field_10392 || block == class_2246.field_10252;
    }

    protected boolean maybeAddMoss(IWorld world, EBlockPos pos, Random rand) {
        List<EVec3i> listDirection = posEightAround;
        Collections.shuffle(listDirection);
        Iterator<EVec3i> iterator = listDirection.iterator();
        if (iterator.hasNext()) {
            EVec3i dir = iterator.next();
            EBlockPos sidePos = pos.add(dir);
            class_2248 sideBlock = world.getBlock(sidePos);
            if (!this.isCobbleStone(sideBlock) && !this.isStoneBricks(sideBlock)) {
                return false;
            }
            class_2248 mossBlock = ErodableBlocks.maybeDecay(rand, sideBlock);
            if (mossBlock == class_2246.field_10124) {
                return false;
            }
            world.setBlockState(sidePos, mossBlock.method_9564(), blockFlags);
            return true;
        }
        return false;
    }

    private class wallBreakOption {
        EVec3i dir;
        Integer distance;

        private wallBreakOption() {
        }
    }
}

