/*
 * Decompiled with CFR 0.152.
 */
package com._13rac1.erosion.common;

import com._13rac1.erosion.common.DefaultErosionConfig;
import com._13rac1.erosion.common.IErosionConfig;
import com._13rac1.erosion.minecraft.EBlockTags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;

public class ErodableBlocks {
    public static IErosionConfig Config = new DefaultErosionConfig();
    private static final Integer MAX_RESIST_ODDS = 0;
    private static final Integer SOURCE_BREAK_RESIST_ODDS = 8;
    private static final Integer LEAF_RESIST_ODDS = 1;
    private static final Integer SAND_RESIST_ODDS = 1;
    private static final Integer WOOL_RESIST_ODDS = 1;
    private static final Integer GRAVEL_RESIST_ODDS = 2;
    private static final Integer CLAY_RESIST_ODDS = 5;
    private static final Integer DIRT_RESIST_ODDS = 4;
    private static final Integer GRASS_RESIST_ODDS = 6;
    private static final Integer COBBLE_RESIST_ODDS = 20;
    private static final Integer BRICK_RESIST_ODDS = 25;
    private static final Integer DECAY_ALWAYS_ODDS = 0;
    private static final Integer DECAY_NEVER_ODDS = 100;
    private static final Integer DECAY_TO_AIR_ODDS = 0;
    private static final Integer DECAY_TO_SAND_ODDS = 1;
    private static final Integer DECAY_TO_GRAVEL_ODDS = 0;
    private static final Integer DECAY_TO_CLAY_ODDS = 20;
    private static final Integer DECAY_TO_DIRT_ODDS = 1;
    private static final Integer DECAY_TO_COARSE_DIRT_ODDS = 1;
    private static final Integer DECAY_TO_MOSSY_COBBLE_ODDS = 0;
    private static final Integer DECAY_TO_MOSSY_BRICKS_ODDS = 1;
    private static HashMap<Block, Integer> decayables;
    private static HashMap<Block, Erodable> erodables;

    private static HashMap<Block, Integer> getDecayables() {
        if (decayables == null) {
            decayables = new HashMap();
            decayables.put(Blocks.field_150350_a, DECAY_TO_AIR_ODDS);
            decayables.put(Blocks.field_150435_aG, DECAY_TO_CLAY_ODDS);
            decayables.put(Blocks.field_150354_m, DECAY_TO_SAND_ODDS);
            decayables.put(Blocks.field_150351_n, DECAY_TO_GRAVEL_ODDS);
            decayables.put(Blocks.field_150346_d, DECAY_TO_DIRT_ODDS);
            decayables.put(Blocks.field_196660_k, DECAY_TO_COARSE_DIRT_ODDS);
            decayables.put(Blocks.field_150341_Y, DECAY_TO_MOSSY_COBBLE_ODDS);
            decayables.put(Blocks.field_222450_ln, DECAY_TO_MOSSY_COBBLE_ODDS);
            decayables.put(Blocks.field_222411_kZ, DECAY_TO_MOSSY_COBBLE_ODDS);
            decayables.put(Blocks.field_196723_eg, DECAY_TO_MOSSY_COBBLE_ODDS);
            decayables.put(Blocks.field_196698_dj, DECAY_TO_MOSSY_BRICKS_ODDS);
            decayables.put(Blocks.field_222448_ll, DECAY_TO_MOSSY_BRICKS_ODDS);
            decayables.put(Blocks.field_222409_kX, DECAY_TO_MOSSY_BRICKS_ODDS);
            decayables.put(Blocks.field_222462_lz, DECAY_TO_MOSSY_BRICKS_ODDS);
        }
        return decayables;
    }

    private static HashMap<Block, Erodable> getErodables() {
        if (erodables == null) {
            erodables = new HashMap();
            erodables.put(Blocks.field_150435_aG, new Erodable(CLAY_RESIST_ODDS, Blocks.field_150350_a));
            erodables.put(Blocks.field_196611_F, new Erodable(SAND_RESIST_ODDS, Blocks.field_150435_aG));
            erodables.put(Blocks.field_150354_m, new Erodable(SAND_RESIST_ODDS, Blocks.field_150435_aG));
            erodables.put(Blocks.field_150351_n, new Erodable(GRAVEL_RESIST_ODDS, Blocks.field_150354_m));
            erodables.put(Blocks.field_196660_k, new Erodable(DIRT_RESIST_ODDS, Blocks.field_150351_n));
            if (Config.GetErodeFarmLand().booleanValue()) {
                erodables.put(Blocks.field_150458_ak, new Erodable(DIRT_RESIST_ODDS, Blocks.field_196660_k));
            }
            erodables.put(Blocks.field_150346_d, new Erodable(DIRT_RESIST_ODDS, Blocks.field_196660_k));
            erodables.put(Blocks.field_196661_l, new Erodable(DIRT_RESIST_ODDS, Blocks.field_196660_k));
            erodables.put(Blocks.field_196658_i, new Erodable(GRASS_RESIST_ODDS, Blocks.field_150346_d));
            erodables.put(Blocks.field_150349_c, new Erodable(GRASS_RESIST_ODDS, Blocks.field_150346_d));
            erodables.put(Blocks.field_185774_da, new Erodable(GRASS_RESIST_ODDS, Blocks.field_150349_c));
            erodables.put(Blocks.field_150341_Y, new Erodable(COBBLE_RESIST_ODDS, Blocks.field_150351_n));
            erodables.put(Blocks.field_222450_ln, new Erodable(COBBLE_RESIST_ODDS, Blocks.field_150350_a));
            erodables.put(Blocks.field_222411_kZ, new Erodable(COBBLE_RESIST_ODDS, Blocks.field_150350_a));
            erodables.put(Blocks.field_196723_eg, new Erodable(COBBLE_RESIST_ODDS, Blocks.field_150350_a));
            erodables.put(Blocks.field_150347_e, new Erodable(COBBLE_RESIST_ODDS, Blocks.field_150341_Y));
            erodables.put(Blocks.field_196646_bz, new Erodable(COBBLE_RESIST_ODDS, Blocks.field_222450_ln));
            erodables.put(Blocks.field_196659_cl, new Erodable(COBBLE_RESIST_ODDS, Blocks.field_222411_kZ));
            erodables.put(Blocks.field_150463_bK, new Erodable(COBBLE_RESIST_ODDS, Blocks.field_196723_eg));
            erodables.put(Blocks.field_196698_dj, new Erodable(BRICK_RESIST_ODDS, Blocks.field_150351_n));
            erodables.put(Blocks.field_222448_ll, new Erodable(COBBLE_RESIST_ODDS, Blocks.field_150350_a));
            erodables.put(Blocks.field_222409_kX, new Erodable(COBBLE_RESIST_ODDS, Blocks.field_150350_a));
            erodables.put(Blocks.field_222462_lz, new Erodable(COBBLE_RESIST_ODDS, Blocks.field_150350_a));
            erodables.put(Blocks.field_196696_di, new Erodable(COBBLE_RESIST_ODDS, Blocks.field_196698_dj));
            erodables.put(Blocks.field_196573_bB, new Erodable(COBBLE_RESIST_ODDS, Blocks.field_222448_ll));
            erodables.put(Blocks.field_150390_bg, new Erodable(COBBLE_RESIST_ODDS, Blocks.field_222409_kX));
            erodables.put(Blocks.field_222413_lB, new Erodable(COBBLE_RESIST_ODDS, Blocks.field_222462_lz));
            erodables.forEach((block, erodable) -> {
                Erodable current = erodable;
                while (current.decayBlock != Blocks.field_150350_a) {
                    erodable.decayList.add(current.decayBlock);
                    current = erodables.get(current.decayBlock);
                }
            });
        }
        return erodables;
    }

    public static Integer getResistance(Block block) {
        if (ErodableBlocks.getErodables().containsKey(block)) {
            return ErodableBlocks.getErodables().get((Object)block).resistanceOdds;
        }
        if (EBlockTags.LEAVES.func_230235_a_((Object)block)) {
            return LEAF_RESIST_ODDS;
        }
        if (EBlockTags.SAND.func_230235_a_((Object)block)) {
            return SAND_RESIST_ODDS;
        }
        if (EBlockTags.WOOL.func_230235_a_((Object)block)) {
            return WOOL_RESIST_ODDS;
        }
        return MAX_RESIST_ODDS;
    }

    public static boolean canErode(Block block) {
        return ErodableBlocks.getResistance(block) != MAX_RESIST_ODDS;
    }

    public static boolean maybeErode(Random rand, Block block) {
        return rand.nextInt(ErodableBlocks.getResistance(block)) == 0;
    }

    public static Block maybeDecay(Random rand, Block block) {
        Integer odds = DECAY_NEVER_ODDS;
        Block decayToBlock = Blocks.field_150350_a;
        if (ErodableBlocks.getErodables().containsKey(block)) {
            decayToBlock = ErodableBlocks.getErodables().get((Object)block).decayBlock;
        }
        if (!ErodableBlocks.getDecayables().containsKey(decayToBlock)) {
            return Blocks.field_150350_a;
        }
        odds = ErodableBlocks.getDecayables().get(decayToBlock);
        if (odds == DECAY_NEVER_ODDS) {
            return Blocks.field_150350_a;
        }
        if (odds == DECAY_ALWAYS_ODDS) {
            return decayToBlock;
        }
        if (rand.nextInt(odds) == 0) {
            return decayToBlock;
        }
        return Blocks.field_150350_a;
    }

    public static Block decayTo(Block block) {
        HashMap<Block, Erodable> erodables = ErodableBlocks.getErodables();
        if (erodables.containsKey(block)) {
            return erodables.get((Object)block).decayBlock;
        }
        return Blocks.field_150350_a;
    }

    public static boolean canSourceBreak(Block block) {
        return ErodableBlocks.getResistance(block) < SOURCE_BREAK_RESIST_ODDS;
    }

    public static ArrayList<Block> getDecayList(Block block) {
        return ErodableBlocks.getErodables().get((Object)block).decayList;
    }

    static class Erodable {
        Integer resistanceOdds;
        Block decayBlock;
        ArrayList<Block> decayList;

        Erodable(Integer resistanceOdds, Block decayBlock) {
            this.resistanceOdds = resistanceOdds;
            this.decayBlock = decayBlock;
            this.decayList = new ArrayList();
        }
    }
}

