/*
 * Decompiled with CFR 0.152.
 */
package com._13rac1.erosion.common;

import com._13rac1.erosion.common.BlockFlag;
import com._13rac1.erosion.common.ErodableBlocks;
import com._13rac1.erosion.common.FluidLevel;
import com._13rac1.erosion.common.IWorld;
import com._13rac1.erosion.minecraft.EBlockPos;
import com._13rac1.erosion.minecraft.EBlockTags;
import com._13rac1.erosion.minecraft.EFluidBlock;
import com._13rac1.erosion.minecraft.EVec3d;
import com._13rac1.erosion.minecraft.EVec3i;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;

public class Tasks {
    private static final EVec3i VECTOR_DOWN = new EVec3i(0, -1, 0);
    private static final EVec3i VECTOR_UP = new EVec3i(0, 1, 0);
    private static final EVec3i VECTOR_NORTH = new EVec3i(0, 0, -1);
    private static final EVec3i VECTOR_NORTH_EAST = new EVec3i(1, 0, -1);
    private static final EVec3i VECTOR_EAST = new EVec3i(1, 0, 0);
    private static final EVec3i VECTOR_SOUTH_EAST = new EVec3i(1, 0, 1);
    private static final EVec3i VECTOR_SOUTH = new EVec3i(0, 0, 1);
    private static final EVec3i VECTOR_SOUTH_WEST = new EVec3i(-1, 0, 1);
    private static final EVec3i VECTOR_WEST = new EVec3i(-1, 0, 0);
    private static final EVec3i VECTOR_NORTH_WEST = new EVec3i(-1, 0, -1);
    private static final Integer blockFlags = BlockFlag.PROPAGATE_CHANGE | BlockFlag.NOTIFY_LISTENERS;
    private static final List<EVec3i> posFourEdges = Arrays.asList(VECTOR_NORTH, VECTOR_EAST, VECTOR_SOUTH, VECTOR_WEST);
    private static final List<EVec3i> posEightAround = Arrays.asList(VECTOR_NORTH, VECTOR_NORTH_EAST, VECTOR_EAST, VECTOR_SOUTH_EAST, VECTOR_SOUTH, VECTOR_SOUTH_WEST, VECTOR_WEST, VECTOR_NORTH_WEST);
    private static final List<EVec3i> posEightAroundUp = Arrays.asList(new EVec3i(1, 1, 1), new EVec3i(1, 1, 0), new EVec3i(1, 1, -1), new EVec3i(0, 1, -1), new EVec3i(-1, 1, -1), new EVec3i(-1, 1, 0), new EVec3i(-1, 1, 1), new EVec3i(0, 1, 1));
    private static List<Integer> wallBreakers = Arrays.asList(FluidLevel.FLOW1, FluidLevel.FLOW2, FluidLevel.FLOW3, FluidLevel.FLOW4, FluidLevel.FLOW5, FluidLevel.FLOW6, FluidLevel.FLOW7);

    public void run(BlockState state, IWorld world, EBlockPos pos, Random rand) {
        Integer level = (Integer)state.func_177229_b((Property)EFluidBlock.field_176367_b);
        this.maybeSourceBreak(state, world, pos, rand, level);
        if (this.maybeAddMoss(world, pos, rand)) {
            return;
        }
        if (level == FluidLevel.SOURCE) {
            return;
        }
        if (this.maybeFlowingWall(state, world, pos, rand, level)) {
            return;
        }
        this.maybeErodeEdge(state, world, pos, rand, level);
        this.maybeDecayUnder(state, world, pos, rand, level);
    }

    private void maybeErodeEdge(BlockState state, IWorld world, EBlockPos pos, Random rand, Integer level) {
        EBlockPos underPos = pos.down();
        Block underBlock = world.getBlock(underPos);
        if (!ErodableBlocks.canErode(underBlock)) {
            return;
        }
        if (!ErodableBlocks.maybeErode(rand, underBlock)) {
            return;
        }
        if (!this.isEdge(world, pos) && level != FluidLevel.FLOW7) {
            return;
        }
        Block decayBlock = ErodableBlocks.maybeDecay(rand, underBlock);
        if (decayBlock != Blocks.field_150350_a) {
            world.setBlockState(underPos, decayBlock.func_176223_P(), blockFlags);
            return;
        }
        Integer underBlocklevel = level < FluidLevel.FALLING7 ? level + 1 : FluidLevel.FALLING7;
        world.setBlockState(underPos, (BlockState)Blocks.field_150355_j.func_176223_P().func_206870_a((Property)EFluidBlock.field_176367_b, (Comparable)underBlocklevel), blockFlags);
        if (state.func_177229_b((Property)EFluidBlock.field_176367_b) == FluidLevel.SOURCE) {
            return;
        }
        world.setBlockState(pos, Blocks.field_150350_a.func_176223_P(), blockFlags);
        Integer upDeleteCount = 0;
        EBlockPos posUp = pos.up();
        while (world.isFluidBlock(world.getBlock(posUp)).booleanValue()) {
            Integer n = upDeleteCount;
            Integer n2 = upDeleteCount = Integer.valueOf(upDeleteCount + 1);
            if (upDeleteCount > 3 || world.getBlockState(posUp).func_177229_b((Property)EFluidBlock.field_176367_b) == FluidLevel.SOURCE) break;
            world.setBlockState(posUp, Blocks.field_150350_a.func_176223_P(), blockFlags);
            posUp = posUp.up();
        }
    }

    protected boolean isEdge(IWorld world, EBlockPos pos) {
        List<EBlockPos> listSidePos = Arrays.asList(pos.north(), pos.south(), pos.east(), pos.west());
        for (EBlockPos sidePos : listSidePos) {
            EBlockPos underPos = sidePos.down();
            Block underBlock = world.getBlock(underPos);
            if (!world.isFluidBlock(underBlock).booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected EVec3i dirTurnLeft(EVec3i in) {
        return in.crossProduct(VECTOR_DOWN);
    }

    protected EVec3i dirTurnRight(EVec3i in) {
        return in.crossProduct(VECTOR_UP);
    }

    protected boolean treeInColumn(IWorld world, EBlockPos pos) {
        Integer MAX_UP = 5;
        Integer count = 0;
        EBlockPos currentPos = pos.up();
        while (count < MAX_UP) {
            Block currentBlock = world.getBlock(currentPos);
            if (EBlockTags.LOGS.func_230235_a_((Object)currentBlock)) {
                return true;
            }
            if (this.isAir(currentBlock)) {
                return false;
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            currentPos = currentPos.up();
        }
        return false;
    }

    private boolean maybeFlowingWall(BlockState state, IWorld world, EBlockPos pos, Random rand, Integer level) {
        wallBreakOption opt;
        Integer dist;
        EVec3i dirForward;
        EBlockPos posForward;
        Block blockForward;
        if (!wallBreakers.contains(level)) {
            return false;
        }
        EVec3d velocity = world.getFlowVelocity(state, pos);
        if (Math.abs(velocity.getX()) < 0.8 && Math.abs(velocity.getZ()) < 0.8) {
            return false;
        }
        Integer Flow7Adjust = 0;
        if (level == FluidLevel.FLOW7) {
            Flow7Adjust = -1;
        }
        if (this.isAir(blockForward = world.getBlock(posForward = pos.add(dirForward = new EVec3i(Math.round(velocity.getX()), velocity.getY() + (double)Flow7Adjust.intValue(), Math.round(velocity.getZ()))))) || blockForward == Blocks.field_150355_j || blockForward == Blocks.field_150353_l) {
            return false;
        }
        EVec3i dirLeft = this.dirTurnLeft(dirForward);
        EVec3i dirRight = this.dirTurnRight(dirForward);
        EBlockPos posLeft = pos.add(dirLeft);
        EBlockPos posRight = pos.add(dirRight);
        Boolean canErodeForward = ErodableBlocks.canErode(blockForward) && !this.treeInColumn(world, posForward);
        Boolean canErodeLeft = ErodableBlocks.canErode(world.getBlock(posLeft)) && !this.treeInColumn(world, posLeft);
        Boolean canErodeRight = ErodableBlocks.canErode(world.getBlock(posRight)) && !this.treeInColumn(world, posRight);
        if (!(canErodeForward.booleanValue() || canErodeLeft.booleanValue() || canErodeRight.booleanValue())) {
            return false;
        }
        ArrayList<wallBreakOption> options = new ArrayList<wallBreakOption>();
        if (canErodeForward.booleanValue() && (dist = this.distanceToAirWaterInFlowPath(world, pos, dirForward, level)) != 128) {
            opt = new wallBreakOption();
            opt.dir = dirForward;
            opt.distance = dist;
            options.add(opt);
        }
        if (canErodeLeft.booleanValue() && (dist = this.distanceToAirWaterInFlowPath(world, pos, dirLeft, level)) != 128) {
            opt = new wallBreakOption();
            opt.dir = dirLeft;
            opt.distance = dist;
            options.add(opt);
        }
        if (canErodeRight.booleanValue() && (dist = this.distanceToAirWaterInFlowPath(world, pos, dirRight, level)) != 128) {
            opt = new wallBreakOption();
            opt.dir = dirRight;
            opt.distance = dist;
            options.add(opt);
        }
        if (options.size() == 0) {
            return false;
        }
        Integer shortestDistance = 128;
        EVec3i shortestDir = null;
        for (wallBreakOption option : options) {
            if (option.distance >= shortestDistance) continue;
            shortestDistance = option.distance;
            shortestDir = option.dir;
        }
        if (shortestDir == null) {
            return false;
        }
        EBlockPos flowPos = pos.add(shortestDir);
        EBlockPos aboveFlowPos = flowPos.up();
        Block aboveFlowBlock = world.getBlock(aboveFlowPos);
        if (EBlockTags.LOGS.func_230235_a_((Object)aboveFlowBlock)) {
            return false;
        }
        Block wallBlock = world.getBlock(flowPos);
        if (!ErodableBlocks.canErode(wallBlock)) {
            return false;
        }
        if (!ErodableBlocks.maybeErode(rand, wallBlock)) {
            return false;
        }
        world.setBlockState(flowPos, Blocks.field_150350_a.func_176223_P(), blockFlags);
        return true;
    }

    private void maybeSourceBreak(BlockState state, IWorld world, EBlockPos pos, Random rand, Integer level) {
        if (level != FluidLevel.SOURCE) {
            return;
        }
        if (pos.getY() < world.getSeaLevel()) {
            return;
        }
        Block upBlock = world.getBlockState(pos.up()).func_177230_c();
        if (!this.isAir(upBlock)) {
            return;
        }
        EVec3d velocity = world.getFlowVelocity(state, pos);
        if (velocity.length() > 0.0) {
            return;
        }
        List<EVec3i> listDirection = Arrays.asList(new EVec3i(1, 0, 0), new EVec3i(-1, 0, 0), new EVec3i(0, 0, 1), new EVec3i(0, 0, -1));
        Collections.shuffle(listDirection);
        for (EVec3i dir : listDirection) {
            Integer dist;
            EBlockPos sidePos = pos.add(dir);
            Block sideBlock = world.getBlock(sidePos);
            if (sideBlock == Blocks.field_150355_j || !ErodableBlocks.canErode(sideBlock) || !ErodableBlocks.canSourceBreak(sideBlock) || (dist = this.distanceToAirWaterInFlowPath(world, pos, dir, level)) == 128) continue;
            int waterFound = 0;
            for (int waterMultipler : Arrays.asList(1, 2, 3)) {
                EVec3i waterDirection = new EVec3i(-dir.getX() * waterMultipler, dir.getY(), -dir.getZ() * waterMultipler);
                EBlockPos maybeWaterPos = pos.add(waterDirection);
                BlockState maybeWaterState = world.getBlockState(maybeWaterPos);
                if (maybeWaterState.func_177230_c() != Blocks.field_150355_j) break;
                ++waterFound;
            }
            if (waterFound < 1) continue;
            if (!ErodableBlocks.maybeErode(rand, sideBlock)) {
                return;
            }
            world.setBlockState(sidePos, Blocks.field_150350_a.func_176223_P(), blockFlags);
            return;
        }
    }

    private boolean isAir(Block block) {
        return block == Blocks.field_150350_a || block == Blocks.field_201941_jj;
    }

    protected boolean airInFlowPath(IWorld world, EBlockPos pos, EVec3i dir) {
        int yDeeper = 0;
        for (int airMultipler : Arrays.asList(7, 14)) {
            EVec3i airDirection = new EVec3i(dir.getX() * airMultipler, dir.getY() - yDeeper, dir.getZ() * airMultipler);
            ++yDeeper;
            EBlockPos maybeAirPos = pos.add(airDirection);
            Block maybeAirBlock = world.getBlock(maybeAirPos);
            if (!this.isAir(maybeAirBlock) && !EBlockTags.LEAVES.func_230235_a_((Object)maybeAirBlock)) continue;
            return true;
        }
        return false;
    }

    protected Integer distanceToAirWaterInFlowPath(IWorld world, EBlockPos pos, EVec3i dir, Integer level) {
        Block blockCurrent;
        if (level > FluidLevel.FLOW7) {
            return 128;
        }
        Integer distanceToAirWater = 0;
        Integer flowDistanceRemaining = 7 - level;
        EBlockPos posCurrent = pos;
        while (flowDistanceRemaining > 0) {
            flowDistanceRemaining = flowDistanceRemaining - 1;
            distanceToAirWater = distanceToAirWater + 1;
            blockCurrent = world.getBlock(posCurrent = posCurrent.add(dir));
            if (this.isAir(blockCurrent) || EBlockTags.LEAVES.func_230235_a_((Object)blockCurrent) || blockCurrent == Blocks.field_150355_j) {
                return distanceToAirWater;
            }
            if (ErodableBlocks.canErode(blockCurrent)) continue;
            return 128;
        }
        posCurrent = posCurrent.down();
        flowDistanceRemaining = 7;
        while (flowDistanceRemaining > 0) {
            flowDistanceRemaining = flowDistanceRemaining - 1;
            distanceToAirWater = distanceToAirWater + 1;
            blockCurrent = world.getBlock(posCurrent = posCurrent.add(dir));
            if (!this.isAir(blockCurrent) && !EBlockTags.LEAVES.func_230235_a_((Object)blockCurrent)) continue;
            return distanceToAirWater;
        }
        return 128;
    }

    protected boolean maybeDecayUnder(BlockState state, IWorld world, EBlockPos pos, Random rand, Integer level) {
        if (level == FluidLevel.SOURCE || level > FluidLevel.FLOW7) {
            return false;
        }
        EBlockPos underPos = pos.down();
        Block underBlock = world.getBlock(underPos);
        if (!ErodableBlocks.canErode(underBlock)) {
            return false;
        }
        Block decayTo = ErodableBlocks.decayTo(underBlock);
        if (decayTo == Blocks.field_150350_a) {
            return false;
        }
        EVec3d velocity = world.getFlowVelocity(state, pos);
        if (Math.abs(velocity.getX()) < 0.8 && Math.abs(velocity.getZ()) < 0.8) {
            return false;
        }
        EBlockPos flowPos = underPos.add(new EVec3i(Math.round(velocity.getX()), 0.0, Math.round(velocity.getZ())));
        Block flowBlock = world.getBlock(flowPos);
        if (!ErodableBlocks.getDecayList(underBlock).contains(flowBlock)) {
            return false;
        }
        world.setBlockState(underPos, decayTo.func_176223_P(), blockFlags);
        return true;
    }

    protected boolean isCobbleStone(Block block) {
        return block == Blocks.field_150347_e || block == Blocks.field_150463_bK || block == Blocks.field_196659_cl || block == Blocks.field_150463_bK;
    }

    protected boolean isStoneBricks(Block block) {
        return block == Blocks.field_196696_di || block == Blocks.field_222413_lB || block == Blocks.field_150390_bg || block == Blocks.field_222413_lB;
    }

    protected boolean maybeAddMoss(IWorld world, EBlockPos pos, Random rand) {
        List<EVec3i> listDirection = posEightAround;
        Collections.shuffle(listDirection);
        Iterator<EVec3i> iterator = listDirection.iterator();
        if (iterator.hasNext()) {
            EVec3i dir = iterator.next();
            EBlockPos sidePos = pos.add(dir);
            Block sideBlock = world.getBlock(sidePos);
            if (!this.isCobbleStone(sideBlock) && !this.isStoneBricks(sideBlock)) {
                return false;
            }
            Block mossBlock = ErodableBlocks.maybeDecay(rand, sideBlock);
            if (mossBlock == Blocks.field_150350_a) {
                return false;
            }
            world.setBlockState(sidePos, mossBlock.func_176223_P(), blockFlags);
            return true;
        }
        return false;
    }

    private class wallBreakOption {
        EVec3i dir;
        Integer distance;

        private wallBreakOption() {
        }
    }
}

