/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.world_blender;

import com.telepathicgrunt.world_blender.WBIdentifiers;
import com.telepathicgrunt.world_blender.WorldBlenderClient;
import com.telepathicgrunt.world_blender.blocks.WBBlocks;
import com.telepathicgrunt.world_blender.blocks.WBPortalSpawning;
import com.telepathicgrunt.world_blender.configs.WBBlendingConfigs;
import com.telepathicgrunt.world_blender.configs.WBDimensionConfigs;
import com.telepathicgrunt.world_blender.configs.WBPortalConfigs;
import com.telepathicgrunt.world_blender.features.WBConfiguredFeatures;
import com.telepathicgrunt.world_blender.features.WBFeatures;
import com.telepathicgrunt.world_blender.generation.WBBiomeProvider;
import com.telepathicgrunt.world_blender.surfacebuilder.WBSurfaceBuilders;
import com.telepathicgrunt.world_blender.the_blender.TheBlender;
import com.telepathicgrunt.world_blender.utils.ConfigHelper;
import com.telepathicgrunt.world_blender.utils.MessageHandler;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeMaker;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="world_blender")
public class WorldBlender {
    public static final String MODID = "world_blender";
    public static final Logger LOGGER = LogManager.getLogger((String)"world_blender");
    public static WBBlendingConfigs.WBConfigValues WBBlendingConfig = null;
    public static WBDimensionConfigs.WBConfigValues WBDimensionConfig = null;
    public static WBPortalConfigs.WBConfigValues WBPortalConfig = null;

    public WorldBlender() {
        WBBlendingConfig = ConfigHelper.register(ModConfig.Type.COMMON, WBBlendingConfigs.WBConfigValues::new, "world_blender-blending.toml");
        WBDimensionConfig = ConfigHelper.register(ModConfig.Type.COMMON, WBDimensionConfigs.WBConfigValues::new, "world_blender-dimension.toml");
        WBPortalConfig = ConfigHelper.register(ModConfig.Type.COMMON, WBPortalConfigs.WBConfigValues::new, "world_blender-portal.toml");
        WBPortalSpawning.generateRequiredBlockList(WorldBlender.WBPortalConfig.requiredBlocksInChests.get());
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        modEventBus.addGenericListener(Biome.class, this::registerBiomes);
        modEventBus.addGenericListener(Feature.class, this::registerFeatures);
        modEventBus.addGenericListener(Block.class, WBBlocks::registerBlocks);
        modEventBus.addGenericListener(TileEntityType.class, WBBlocks::registerBlockEntities);
        modEventBus.addGenericListener(SurfaceBuilder.class, WBSurfaceBuilders::registerSurfaceBuilders);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.LOWEST, TheBlender::addDimensionalSpacing);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> WorldBlenderClient.subscribeClientEvents(modEventBus, forgeBus));
    }

    public void setup(FMLCommonSetupEvent event) {
        MessageHandler.init();
        WBPortalSpawning.generateRequiredBlockList(WorldBlender.WBPortalConfig.requiredBlocksInChests.get());
    }

    @Deprecated
    public void registerBiomes(RegistryEvent.Register<Biome> event) {
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243657_i, (ResourceLocation)WBIdentifiers.GENERAL_BLENDED_BIOME_ID, (Object)BiomeMaker.func_244234_c((boolean)false));
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243657_i, (ResourceLocation)WBIdentifiers.MOUNTAINOUS_BLENDED_BIOME_ID, (Object)BiomeMaker.func_244234_c((boolean)false));
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243657_i, (ResourceLocation)WBIdentifiers.COLD_HILLS_BLENDED_BIOME_ID, (Object)BiomeMaker.func_244234_c((boolean)false));
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243657_i, (ResourceLocation)WBIdentifiers.OCEAN_BLENDED_BIOME_ID, (Object)BiomeMaker.func_244234_c((boolean)false));
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243657_i, (ResourceLocation)WBIdentifiers.FROZEN_OCEAN_BLENDED_BIOME_ID, (Object)BiomeMaker.func_244234_c((boolean)false));
        WBBiomeProvider.registerBiomeProvider();
    }

    public void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        WBFeatures.registerFeatures(event);
        WBConfiguredFeatures.registerConfiguredFeatures();
    }

    public static <T extends IForgeRegistryEntry<T>> T register(IForgeRegistry<T> registry, T entry, String registryKey) {
        entry.setRegistryName(new ResourceLocation(MODID, registryKey));
        registry.register(entry);
        return entry;
    }
}

