/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.world_blender.features;

import com.telepathicgrunt.world_blender.WorldBlender;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class NoFloatingLiquidsOrFallingBlocks
extends Feature<NoFeatureConfig> {
    private static final Map<MaterialColor, Block> COLOR_MAP = new HashMap<MaterialColor, Block>();
    private static final Set<Material> REPLACEABLE_MATERIALS;

    public NoFloatingLiquidsOrFallingBlocks() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean func_241855_a(ISeedReader world, ChunkGenerator chunkgenerator, Random rand, BlockPos position, NoFeatureConfig config) {
        if (!WorldBlender.WBDimensionConfig.preventFallingBlocks.get().booleanValue() && !WorldBlender.WBDimensionConfig.containFloatingLiquids.get().booleanValue()) {
            return false;
        }
        BlockState lastBlockstate = Blocks.field_150348_b.func_176223_P();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                BlockPos.Mutable mutable = new BlockPos.Mutable(position.func_177958_n() + x, 0, position.func_177952_p() + z);
                mutable.func_189534_c(Direction.UP, Math.max(world.func_201676_a(Heightmap.Type.WORLD_SURFACE, mutable.func_177958_n(), mutable.func_177952_p()), chunkgenerator.func_230356_f_()));
                while (mutable.func_177956_o() >= 0) {
                    BlockState currentBlockstate = world.func_180495_p((BlockPos)mutable);
                    if (REPLACEABLE_MATERIALS.contains(currentBlockstate.func_185904_a())) {
                        NoFloatingLiquidsOrFallingBlocks.preventfalling(world, mutable, lastBlockstate);
                        NoFloatingLiquidsOrFallingBlocks.liquidContaining(world, mutable, lastBlockstate);
                    } else if (currentBlockstate.func_185904_a() == Material.field_151586_h || currentBlockstate.func_185904_a() == Material.field_151587_i) {
                        NoFloatingLiquidsOrFallingBlocks.preventfalling(world, mutable, lastBlockstate);
                    }
                    lastBlockstate = currentBlockstate;
                    mutable.func_189536_c(Direction.DOWN);
                }
            }
        }
        return true;
    }

    private static void preventfalling(ISeedReader world, BlockPos.Mutable mutable, BlockState lastBlockstate) {
        if (!WorldBlender.WBDimensionConfig.preventFallingBlocks.get().booleanValue()) {
            return;
        }
        if (lastBlockstate.func_177230_c() instanceof FallingBlock) {
            MaterialColor targetMaterial = lastBlockstate.func_185909_g((IBlockReader)world, (BlockPos)mutable);
            if (targetMaterial == null || !COLOR_MAP.containsKey(targetMaterial)) {
                world.func_180501_a((BlockPos)mutable, Blocks.field_196793_fx.func_176223_P(), 2);
            } else {
                world.func_180501_a((BlockPos)mutable, COLOR_MAP.get(targetMaterial).func_176223_P(), 2);
            }
        }
    }

    private static void liquidContaining(ISeedReader world, BlockPos.Mutable mutable, BlockState lastBlockstate) {
        if (!WorldBlender.WBDimensionConfig.containFloatingLiquids.get().booleanValue()) {
            return;
        }
        boolean touchingLiquid = false;
        BlockState neighboringBlockstate = null;
        if (!lastBlockstate.func_204520_s().func_206888_e()) {
            touchingLiquid = true;
            neighboringBlockstate = lastBlockstate;
        } else {
            for (Direction face : Direction.Plane.HORIZONTAL) {
                neighboringBlockstate = world.func_180495_p(mutable.func_177972_a(face));
                if (neighboringBlockstate.func_204520_s().func_206888_e()) continue;
                touchingLiquid = true;
                break;
            }
        }
        if (touchingLiquid) {
            MaterialColor targetMaterial = neighboringBlockstate.func_185909_g((IBlockReader)world, (BlockPos)mutable);
            if (targetMaterial == null || !COLOR_MAP.containsKey(targetMaterial)) {
                world.func_180501_a((BlockPos)mutable, Blocks.field_196793_fx.func_176223_P(), 2);
            } else {
                world.func_180501_a((BlockPos)mutable, COLOR_MAP.get(targetMaterial).func_176223_P(), 2);
            }
        }
    }

    static {
        COLOR_MAP.put(MaterialColor.field_151660_b, Blocks.field_150405_ch);
        COLOR_MAP.put(MaterialColor.field_151676_q, Blocks.field_196778_fp);
        COLOR_MAP.put(MaterialColor.field_151646_E, Blocks.field_196722_fD);
        COLOR_MAP.put(MaterialColor.field_151649_A, Blocks.field_196797_fz);
        COLOR_MAP.put(MaterialColor.field_151650_B, Blocks.field_196719_fA);
        COLOR_MAP.put(MaterialColor.field_151667_k, Blocks.field_196793_fx);
        COLOR_MAP.put(MaterialColor.field_151679_y, Blocks.field_196793_fx);
        COLOR_MAP.put(MaterialColor.field_151648_G, Blocks.field_196782_fr);
        COLOR_MAP.put(MaterialColor.field_151664_l, Blocks.field_196719_fA);
        COLOR_MAP.put(MaterialColor.field_151653_I, Blocks.field_196720_fB);
        COLOR_MAP.put(MaterialColor.field_151669_i, Blocks.field_196720_fB);
        COLOR_MAP.put(MaterialColor.field_151647_F, Blocks.field_196783_fs);
        COLOR_MAP.put(MaterialColor.field_151661_c, Blocks.field_196720_fB);
        COLOR_MAP.put(MaterialColor.field_151670_w, Blocks.field_196789_fv);
        COLOR_MAP.put(MaterialColor.field_151651_C, Blocks.field_196720_fB);
        COLOR_MAP.put(MaterialColor.field_151657_g, Blocks.field_196782_fr);
        COLOR_MAP.put(MaterialColor.field_151668_h, Blocks.field_196777_fo);
        COLOR_MAP.put(MaterialColor.field_151652_H, Blocks.field_196797_fz);
        COLOR_MAP.put(MaterialColor.field_151674_s, Blocks.field_196782_fr);
        COLOR_MAP.put(MaterialColor.field_197656_x, Blocks.field_196791_fw);
        COLOR_MAP.put(MaterialColor.field_151672_u, Blocks.field_196785_ft);
        COLOR_MAP.put(MaterialColor.field_151675_r, Blocks.field_196780_fq);
        COLOR_MAP.put(MaterialColor.field_151655_K, Blocks.field_196721_fC);
        COLOR_MAP.put(MaterialColor.field_151654_J, Blocks.field_196722_fD);
        COLOR_MAP.put(MaterialColor.field_151671_v, Blocks.field_196787_fu);
        COLOR_MAP.put(MaterialColor.field_151678_z, Blocks.field_196795_fy);
        COLOR_MAP.put(MaterialColor.field_151677_p, Blocks.field_196777_fo);
        COLOR_MAP.put(MaterialColor.field_151645_D, Blocks.field_196721_fC);
        COLOR_MAP.put(MaterialColor.field_151658_d, Blocks.field_196777_fo);
        COLOR_MAP.put(MaterialColor.field_151666_j, Blocks.field_196777_fo);
        COLOR_MAP.put(MaterialColor.field_151665_m, Blocks.field_196793_fx);
        COLOR_MAP.put(MaterialColor.field_151656_f, Blocks.field_196721_fC);
        COLOR_MAP.put(MaterialColor.field_151662_n, Blocks.field_196782_fr);
        COLOR_MAP.put(MaterialColor.field_151663_o, Blocks.field_150405_ch);
        COLOR_MAP.put(MaterialColor.field_151659_e, Blocks.field_196777_fo);
        COLOR_MAP.put(MaterialColor.field_151673_t, Blocks.field_196783_fs);
        COLOR_MAP.put(MaterialColor.field_193562_N, Blocks.field_196778_fp);
        COLOR_MAP.put(MaterialColor.field_193560_ab, Blocks.field_196722_fD);
        COLOR_MAP.put(MaterialColor.field_193572_X, Blocks.field_196797_fz);
        COLOR_MAP.put(MaterialColor.field_193573_Y, Blocks.field_196719_fA);
        COLOR_MAP.put(MaterialColor.field_193570_V, Blocks.field_196793_fx);
        COLOR_MAP.put(MaterialColor.field_193564_P, Blocks.field_196782_fr);
        COLOR_MAP.put(MaterialColor.field_193574_Z, Blocks.field_196720_fB);
        COLOR_MAP.put(MaterialColor.field_193568_T, Blocks.field_196789_fv);
        COLOR_MAP.put(MaterialColor.field_197655_T, Blocks.field_196791_fw);
        COLOR_MAP.put(MaterialColor.field_193566_R, Blocks.field_196785_ft);
        COLOR_MAP.put(MaterialColor.field_193563_O, Blocks.field_196780_fq);
        COLOR_MAP.put(MaterialColor.field_193559_aa, Blocks.field_196721_fC);
        COLOR_MAP.put(MaterialColor.field_193565_Q, Blocks.field_196783_fs);
        COLOR_MAP.put(MaterialColor.field_193567_S, Blocks.field_196787_fu);
        COLOR_MAP.put(MaterialColor.field_193571_W, Blocks.field_196795_fy);
        REPLACEABLE_MATERIALS = new HashSet<Material>();
        REPLACEABLE_MATERIALS.add(Material.field_151579_a);
        REPLACEABLE_MATERIALS.add(Material.field_189963_J);
        REPLACEABLE_MATERIALS.add(Material.field_151582_l);
        REPLACEABLE_MATERIALS.add(Material.field_151593_r);
        REPLACEABLE_MATERIALS.add(Material.field_151570_A);
    }
}

