/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.world_blender.generation;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.world_blender.WBIdentifiers;
import com.telepathicgrunt.world_blender.generation.MainBiomeLayer;
import com.telepathicgrunt.world_blender.mixin.BiomeLayerSamplerAccessor;
import java.util.List;
import java.util.function.LongFunction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WBBiomeProvider
extends BiomeProvider {
    public static final Codec<WBBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(biomeProvider -> biomeProvider.BIOME_REGISTRY)).apply((Applicative)instance, instance.stable(WBBiomeProvider::new)));
    private final Layer BIOME_SAMPLER;
    protected final Registry<Biome> BIOME_REGISTRY;
    protected static Registry<Biome> LAYERS_BIOME_REGISTRY;
    private static final List<RegistryKey<Biome>> BIOMES;

    public static void registerBiomeProvider() {
        Registry.func_218322_a((Registry)Registry.field_239689_aA_, (ResourceLocation)WBIdentifiers.WB_BIOME_PROVIDER_ID, CODEC);
    }

    public WBBiomeProvider(Registry<Biome> biomeRegistry) {
        this(0L, biomeRegistry);
    }

    public WBBiomeProvider(long seed, Registry<Biome> biomeRegistry) {
        super(BIOMES.stream().map(registryKey -> () -> (Biome)biomeRegistry.func_243576_d(registryKey)));
        MainBiomeLayer.setSeed(seed);
        this.BIOME_REGISTRY = biomeRegistry;
        LAYERS_BIOME_REGISTRY = biomeRegistry;
        this.BIOME_SAMPLER = WBBiomeProvider.buildWorldProcedure(seed);
    }

    public static Layer buildWorldProcedure(long seed) {
        IAreaFactory layerFactory = WBBiomeProvider.build(salt -> new LazyAreaLayerContext(25, seed, salt));
        return new Layer(layerFactory);
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> build(LongFunction<C> contextFactory) {
        IAreaFactory layerFactory = MainBiomeLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)contextFactory.apply(200L));
        layerFactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2001L), layerFactory);
        layerFactory = ZoomLayer.FUZZY.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2000L), layerFactory);
        return layerFactory;
    }

    public Biome func_225526_b_(int x, int y, int z) {
        return this.sample(LAYERS_BIOME_REGISTRY, x, z);
    }

    public Biome sample(Registry<Biome> registry, int x, int z) {
        int k = ((BiomeLayerSamplerAccessor)this.BIOME_SAMPLER).getSampler().func_202678_a(x, z);
        Biome biome = (Biome)registry.func_148745_a(k);
        if (biome == null) {
            if (SharedConstants.field_206244_b) {
                throw (IllegalStateException)Util.func_229757_c_((Throwable)new IllegalStateException("Unknown biome id: " + k));
            }
            return (Biome)registry.func_230516_a_(BiomeRegistry.func_244203_a((int)0));
        }
        return biome;
    }

    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BiomeProvider func_230320_a_(long seed) {
        return new WBBiomeProvider(seed, LAYERS_BIOME_REGISTRY);
    }

    static {
        BIOMES = ImmutableList.of((Object)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)WBIdentifiers.GENERAL_BLENDED_BIOME_ID), (Object)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)WBIdentifiers.MOUNTAINOUS_BLENDED_BIOME_ID), (Object)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)WBIdentifiers.COLD_HILLS_BLENDED_BIOME_ID), (Object)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)WBIdentifiers.OCEAN_BLENDED_BIOME_ID), (Object)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)WBIdentifiers.FROZEN_OCEAN_BLENDED_BIOME_ID));
    }
}

