/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.world_blender.the_blender;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.StructureFeature;

public class FeatureGrouping {
    private static final List<String> BAMBOO_FEATURE_KEYWORDS = Arrays.asList("bamboo");
    private static final List<String> LAGGY_STATE_KEYWORDS = Arrays.asList("lava", "fire", "bamboo", "sugar_cane");
    private static final List<String> LAGGY_FEATURE_KEYWORDS = Arrays.asList("basalt_columns", "basalt_pillar", "delta_feature");
    public static boolean bambooFound = false;
    public static final Map<GenerationStage.Decoration, List<ConfiguredFeature<?, ?>>> SMALL_PLANT_MAP = Maps.newHashMap();
    private static final List<String> SMALL_PLANT_KEYWORDS = Arrays.asList("grass", "flower", "rose", "plant", "bush", "fern");
    public static final Map<GenerationStage.Decoration, List<ConfiguredFeature<?, ?>>> LARGE_PLANT_MAP = Maps.newHashMap();
    private static final List<String> LARGE_PLANT_KEYWORDS = Arrays.asList("tree", "huge_mushroom", "big_mushroom", "poplar", "twiglet", "mangrove", "bramble");

    public static void setupFeatureMaps() {
        for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
            SMALL_PLANT_MAP.put(stage, new ArrayList());
            LARGE_PLANT_MAP.put(stage, new ArrayList());
            bambooFound = false;
        }
    }

    public static void clearFeatureMaps() {
        SMALL_PLANT_MAP.clear();
        LARGE_PLANT_MAP.clear();
    }

    public static boolean isLaggyFeature(ConfiguredFeature<?, ?> configuredFeature) {
        Optional optionalConfiguredFeatureJSON = ConfiguredFeature.field_242763_a.encode(configuredFeature, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).get().left();
        if (optionalConfiguredFeatureJSON.isPresent()) {
            JsonElement configuredFeatureJSON = (JsonElement)optionalConfiguredFeatureJSON.get();
            if (FeatureGrouping.containsBannedFeatureName(configuredFeatureJSON, BAMBOO_FEATURE_KEYWORDS) || FeatureGrouping.containsBannedState(configuredFeatureJSON, BAMBOO_FEATURE_KEYWORDS)) {
                bambooFound = true;
                return true;
            }
            if (FeatureGrouping.containsBannedFeatureName(configuredFeatureJSON, LAGGY_FEATURE_KEYWORDS)) {
                return true;
            }
            if (FeatureGrouping.containsBannedState(configuredFeatureJSON, LAGGY_STATE_KEYWORDS)) {
                return true;
            }
        }
        return false;
    }

    public static boolean checksAndAddSmallPlantFeatures(GenerationStage.Decoration stage, ConfiguredFeature<?, ?> configuredFeature) {
        JsonElement configuredFeatureJSON;
        if (SMALL_PLANT_MAP.get(stage).stream().anyMatch(vanillaConfigFeature -> FeatureGrouping.serializeAndCompareFeature(vanillaConfigFeature, configuredFeature, true))) {
            return false;
        }
        Optional optionalConfiguredFeatureJSON = ConfiguredFeature.field_242763_a.encode(configuredFeature, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).get().left();
        if (optionalConfiguredFeatureJSON.isPresent() && (FeatureGrouping.containsBannedFeatureName(configuredFeatureJSON = (JsonElement)optionalConfiguredFeatureJSON.get(), SMALL_PLANT_KEYWORDS) || FeatureGrouping.containsBannedState(configuredFeatureJSON, SMALL_PLANT_KEYWORDS))) {
            SMALL_PLANT_MAP.get(stage).add(configuredFeature);
            return true;
        }
        return false;
    }

    public static boolean checksAndAddLargePlantFeatures(GenerationStage.Decoration stage, ConfiguredFeature<?, ?> configuredFeature) {
        JsonElement configuredFeatureJSON;
        if (LARGE_PLANT_MAP.get(stage).stream().anyMatch(vanillaConfigFeature -> FeatureGrouping.serializeAndCompareFeature(vanillaConfigFeature, configuredFeature, true))) {
            return false;
        }
        Optional optionalConfiguredFeatureJSON = ConfiguredFeature.field_242763_a.encode(configuredFeature, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).get().left();
        if (optionalConfiguredFeatureJSON.isPresent() && (FeatureGrouping.containsBannedFeatureName(configuredFeatureJSON = (JsonElement)optionalConfiguredFeatureJSON.get(), LARGE_PLANT_KEYWORDS) || FeatureGrouping.containsBannedState(configuredFeatureJSON, LARGE_PLANT_KEYWORDS))) {
            LARGE_PLANT_MAP.get(stage).add(configuredFeature);
            return true;
        }
        return false;
    }

    private static boolean containsBannedState(JsonElement jsonElement, List<String> keywordList) {
        JsonObject jsonStartObject = jsonElement.getAsJsonObject();
        for (Map.Entry entry : jsonStartObject.entrySet()) {
            if (((String)entry.getKey()).equals("state")) {
                JsonObject jsonStateObject = ((JsonElement)entry.getValue()).getAsJsonObject();
                if (!jsonStateObject.has("Name")) continue;
                String blockPath = jsonStateObject.get("Name").getAsString().split(":")[1];
                for (String keyword : keywordList) {
                    if (!blockPath.contains(keyword)) continue;
                    return true;
                }
                continue;
            }
            if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
            return FeatureGrouping.containsBannedState((JsonElement)((JsonElement)entry.getValue()).getAsJsonObject(), keywordList);
        }
        return false;
    }

    private static boolean containsBannedFeatureName(JsonElement jsonElement, List<String> keywordList) {
        String stringToCheck = FeatureGrouping.getsFeatureName(jsonElement);
        return keywordList.stream().anyMatch(stringToCheck::contains);
    }

    private static String getsFeatureName(JsonElement jsonElement) {
        JsonObject jsonStartObject = jsonElement.getAsJsonObject();
        if (jsonStartObject.has("config")) {
            JsonObject jsonConfigObject = jsonStartObject.get("config").getAsJsonObject();
            if (jsonConfigObject.has("features")) {
                JsonElement jsonFeatureElement = jsonConfigObject.get("features");
                if (jsonFeatureElement.isJsonArray()) {
                    StringBuilder allFeatures = new StringBuilder();
                    for (JsonElement entry : jsonFeatureElement.getAsJsonArray()) {
                        allFeatures.append(entry.toString()).append(" ");
                    }
                    if (jsonConfigObject.has("default")) {
                        allFeatures.append(jsonConfigObject.get("default").toString()).append(" ");
                        return allFeatures.toString();
                    }
                    if (jsonConfigObject.has("type")) {
                        allFeatures.append(jsonConfigObject.get("type").toString()).append(" ");
                        return allFeatures.toString();
                    }
                }
            } else if (jsonConfigObject.has("feature")) {
                JsonElement jsonFeatureElement = jsonConfigObject.get("feature");
                if (jsonFeatureElement.isJsonObject()) {
                    return FeatureGrouping.getsFeatureName(jsonFeatureElement);
                }
            } else if (jsonStartObject.has("type")) {
                return jsonStartObject.toString();
            }
        } else if (jsonStartObject.has("type")) {
            return jsonStartObject.get("type").toString();
        }
        return "";
    }

    public static boolean serializeAndCompareFeature(ConfiguredFeature<?, ?> configuredFeature1, ConfiguredFeature<?, ?> configuredFeature2, boolean doDeepJSONCheck) {
        Optional optionalJsonElement1 = ConfiguredFeature.field_242763_a.encode(configuredFeature1, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).get().left();
        Optional optionalJsonElement2 = ConfiguredFeature.field_242763_a.encode(configuredFeature2, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).get().left();
        if (optionalJsonElement1.isPresent() && optionalJsonElement2.isPresent()) {
            JsonElement configuredFeatureJSON1 = (JsonElement)optionalJsonElement1.get();
            JsonElement configuredFeatureJSON2 = (JsonElement)optionalJsonElement2.get();
            return configuredFeatureJSON1.toString().equals(configuredFeatureJSON2.toString()) || doDeepJSONCheck && FeatureGrouping.getsFeatureName(configuredFeatureJSON1).equals(FeatureGrouping.getsFeatureName(configuredFeatureJSON2));
        }
        return configuredFeature1.equals(configuredFeature2);
    }

    public static boolean serializeAndCompareStructureJSONOnly(StructureFeature<?, ?> configuredStructure1, StructureFeature<?, ?> configuredStructure2) {
        Optional optionalJsonElement1 = StructureFeature.field_236267_a_.encode(configuredStructure1, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).get().left();
        Optional optionalJsonElement2 = StructureFeature.field_236267_a_.encode(configuredStructure2, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).get().left();
        if (optionalJsonElement1.isPresent() && optionalJsonElement2.isPresent()) {
            JsonElement configuredFeatureJSON1 = (JsonElement)optionalJsonElement1.get();
            JsonElement configuredFeatureJSON2 = (JsonElement)optionalJsonElement2.get();
            return configuredFeatureJSON1.toString().equals(configuredFeatureJSON2.toString());
        }
        return configuredStructure1.equals(configuredStructure2);
    }
}

