/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.world_blender.the_blender;

import com.telepathicgrunt.world_blender.WorldBlender;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;

public class IdentifierPrinting {
    public static void printAllResourceLocations(DynamicRegistries registryManager) {
        try (PrintStream printStream = new PrintStream("identifierDump.txt");){
            IdentifierPrinting.printOutSection(printStream, registryManager.func_243612_b(Registry.field_239720_u_), "BIOMES");
            printStream.println();
            IdentifierPrinting.printOutSection(printStream, registryManager.func_243612_b(Registry.field_243552_au), "CONFIGURED FEATURES");
            printStream.println();
            IdentifierPrinting.printOutSection(printStream, registryManager.func_243612_b(Registry.field_243553_av), "CONFIGURED STRUCTURES");
            printStream.println();
            IdentifierPrinting.printOutSection(printStream, registryManager.func_243612_b(Registry.field_243551_at), "CARVERS");
            printStream.println();
            IdentifierPrinting.printOutSection(printStream, Registry.field_212629_r, "ENTITIES");
            printStream.println();
            IdentifierPrinting.printOutSection(printStream, Registry.field_212618_g, "BLOCKS");
        }
        catch (FileNotFoundException e) {
            WorldBlender.LOGGER.warn("FAILED TO CREATE AND WRITE TO identifierDump.txt. SEE STACKTRACE AND SHOW IT TO MOD MAKER.");
            e.printStackTrace();
        }
    }

    private static <T> void printOutSection(PrintStream printStream, Registry<T> registry, String section) {
        AtomicReference<String> previous_namespace = new AtomicReference<String>("minecraft");
        printStream.println("######################################################################");
        printStream.println("######      " + section + " RESOURCE LOCATION (IDs)        ######");
        printStream.println();
        registry.func_239659_c_().stream().sorted(Comparator.comparing(p -> ((RegistryKey)p.getKey()).func_240901_a_().toString())).forEach(entry -> IdentifierPrinting.writeEntry(printStream, (RegistryKey)entry.getKey(), previous_namespace));
    }

    private static void writeEntry(PrintStream printStream, RegistryKey<?> entry, AtomicReference<String> previous_namespace) {
        ResourceLocation entryID = entry.func_240901_a_();
        if (entryID == null) {
            return;
        }
        previous_namespace.set(IdentifierPrinting.printSpacingBetweenMods(printStream, previous_namespace.get(), entryID.func_110624_b()));
        printStream.println(entryID.toString());
    }

    private static String printSpacingBetweenMods(PrintStream printStream, String previousModID, String currentModID) {
        if (!currentModID.isEmpty() && !previousModID.equals(currentModID)) {
            printStream.println();
            return currentModID;
        }
        return previousModID;
    }
}

