/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.world_blender.the_blender;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.telepathicgrunt.world_blender.WBIdentifiers;
import com.telepathicgrunt.world_blender.WorldBlender;
import com.telepathicgrunt.world_blender.features.WBConfiguredFeatures;
import com.telepathicgrunt.world_blender.mixin.CarverAccessor;
import com.telepathicgrunt.world_blender.mixin.ConfiguredCarverAccessor;
import com.telepathicgrunt.world_blender.mixin.DimensionStructureSettingsAccessor;
import com.telepathicgrunt.world_blender.mixin.GenerationSettingsAccessor;
import com.telepathicgrunt.world_blender.mixin.MobSpawnInfoAccessor;
import com.telepathicgrunt.world_blender.surfacebuilder.BlendedSurfaceBuilder;
import com.telepathicgrunt.world_blender.surfacebuilder.WBSurfaceBuilders;
import com.telepathicgrunt.world_blender.the_blender.ConfigBlacklisting;
import com.telepathicgrunt.world_blender.the_blender.FeatureGrouping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.logging.log4j.Level;

public class TheBlender {
    private static final Set<String> COLLECTED_UNREGISTERED_STUFF = new HashSet<String>();
    private static final Pattern WORLDGEN_OBJECT_REGEX = Pattern.compile("\"(?:Name|type|location)\": *\"([a-z_:]+)\"");
    private static Map<Structure<?>, StructureSeparationSettings> tempMap = new HashMap();

    public static void blendTheWorld(DynamicRegistries.Impl registryManager) {
        if (!registryManager.func_230521_a_(Registry.field_239720_u_).isPresent()) {
            return;
        }
        List<Biome> world_blender_biomes = ((MutableRegistry)registryManager.func_230521_a_(Registry.field_239720_u_).get()).func_239659_c_().stream().filter(entry -> ((RegistryKey)entry.getKey()).func_240901_a_().func_110624_b().equals("world_blender")).map(Map.Entry::getValue).collect(Collectors.toList());
        world_blender_biomes.forEach(TheBlender::makeBiomeMutable);
        ConfigBlacklisting.setupBlackLists();
        FeatureGrouping.setupFeatureMaps();
        BlendedSurfaceBuilder.resetSurfaceList();
        for (Map.Entry biomeEntry : ((MutableRegistry)registryManager.func_230521_a_(Registry.field_239720_u_).get()).func_239659_c_()) {
            if (((RegistryKey)biomeEntry.getKey()).func_240901_a_().func_110624_b().equals("world_blender")) continue;
            TheBlender.mainBlending((Biome)biomeEntry.getValue(), world_blender_biomes, ((RegistryKey)biomeEntry.getKey()).func_240901_a_(), registryManager);
        }
        TheBlender.completeBlending(world_blender_biomes, registryManager.func_243612_b(Registry.field_243552_au));
        if (COLLECTED_UNREGISTERED_STUFF.size() != 0) {
            String errorReport = "\n****************** World Blender ******************\n\n Found some unregistered ConfiguredFeatures, ConfiguredStructures, and/or\n ConfiguredCarvers. These unregistered stuff will not spawn in WorldBlender's dimension\n as unregistered stuff can wipe out everyone else's registered stuff from biomes.\n The creators of those mods need to register their stuff.\n Here are the following that will not show up in WB's dimension: \n\n" + COLLECTED_UNREGISTERED_STUFF.stream().sorted().collect(Collectors.joining("\n")) + "\n\n";
            WorldBlender.LOGGER.log(Level.ERROR, errorReport);
        }
        FeatureGrouping.clearFeatureMaps();
        COLLECTED_UNREGISTERED_STUFF.clear();
    }

    private static void extractModNames(String unconfigured_worldgen_object) {
        Matcher match = WORLDGEN_OBJECT_REGEX.matcher(unconfigured_worldgen_object);
        while (match.find()) {
            if (match.group(1).contains("minecraft:")) continue;
            COLLECTED_UNREGISTERED_STUFF.add(match.group(1));
        }
    }

    private static void mainBlending(Biome biome, List<Biome> world_blender_biomes, ResourceLocation biomeID, DynamicRegistries.Impl dynamicRegistryManager) {
        if (biomeID.func_110624_b().equals("world_blender")) {
            return;
        }
        if (biomeID.func_110624_b().equals("minecraft") && !WorldBlender.WBBlendingConfig.allowVanillaBiomeImport.get().booleanValue()) {
            return;
        }
        if (!biomeID.func_110624_b().equals("minecraft") && !WorldBlender.WBBlendingConfig.allowModdedBiomeImport.get().booleanValue()) {
            return;
        }
        if (ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.BLANKET, biomeID)) {
            return;
        }
        TheBlender.addBiomeFeatures(biome, world_blender_biomes, dynamicRegistryManager.func_243612_b(Registry.field_243552_au));
        TheBlender.addBiomeStructures(biome, world_blender_biomes, dynamicRegistryManager.func_243612_b(Registry.field_243553_av));
        TheBlender.addBiomeCarvers(biome, world_blender_biomes, dynamicRegistryManager.func_243612_b(Registry.field_243551_at));
        TheBlender.addBiomeNaturalMobs(biome, world_blender_biomes);
        TheBlender.addBiomeSurfaceConfig(biome, biomeID);
    }

    public static void completeBlending(List<Biome> world_blender_biomes, MutableRegistry<ConfiguredFeature<?, ?>> configuredFeaturesRegistry) {
        if (!ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.FEATURE, new ResourceLocation("minecraft:end_spike"))) {
            world_blender_biomes.forEach(blendedBiome -> ((List)blendedBiome.func_242440_e().func_242498_c().get(GenerationStage.Decoration.SURFACE_STRUCTURES.ordinal())).add(() -> (ConfiguredFeature)configuredFeaturesRegistry.func_82594_a(new ResourceLocation("minecraft", "end_spike"))));
        }
        for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
            for (ConfiguredFeature<?, ?> grassyFlowerFeature : FeatureGrouping.SMALL_PLANT_MAP.get(stage)) {
                if (!((List)world_blender_biomes.get(0).func_242440_e().func_242498_c().get(stage.ordinal())).stream().noneMatch(addedConfigFeature -> FeatureGrouping.serializeAndCompareFeature((ConfiguredFeature)addedConfigFeature.get(), grassyFlowerFeature, true))) continue;
                world_blender_biomes.forEach(blendedBiome -> ((List)blendedBiome.func_242440_e().func_242498_c().get(stage.ordinal())).add(() -> grassyFlowerFeature));
            }
        }
        if (!WorldBlender.WBBlendingConfig.disallowLaggyFeatures.get().booleanValue() && FeatureGrouping.bambooFound) {
            world_blender_biomes.forEach(blendedBiome -> ((List)blendedBiome.func_242440_e().func_242498_c().get(GenerationStage.Decoration.VEGETAL_DECORATION.ordinal())).add(() -> (ConfiguredFeature)configuredFeaturesRegistry.func_82594_a(new ResourceLocation("minecraft", "bamboo"))));
        }
        if (WorldBlender.WBDimensionConfig.carversCanCarveMoreBlocks.get().booleanValue()) {
            Set<Block> allBlocksToCarve = BlendedSurfaceBuilder.blocksToCarve();
            for (GenerationStage.Carving carverStage : GenerationStage.Carving.values()) {
                for (Supplier carver : world_blender_biomes.get(0).func_242440_e().func_242489_a(carverStage)) {
                    allBlocksToCarve.addAll(((CarverAccessor)((ConfiguredCarverAccessor)carver.get()).getcarver()).getalwaysCarvableBlocks());
                }
            }
            for (GenerationStage.Carving carverStage : GenerationStage.Carving.values()) {
                for (Supplier carver : world_blender_biomes.get(0).func_242440_e().func_242489_a(carverStage)) {
                    ((CarverAccessor)((ConfiguredCarverAccessor)carver.get()).getcarver()).setalwaysCarvableBlocks(allBlocksToCarve);
                }
            }
        }
        if (!ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.FEATURE, new ResourceLocation("world_blender:no_floating_liquids_or_falling_blocks"))) {
            world_blender_biomes.forEach(blendedBiome -> ((List)blendedBiome.func_242440_e().func_242498_c().get(GenerationStage.Decoration.LOCAL_MODIFICATIONS.ordinal())).add(() -> WBConfiguredFeatures.NO_FLOATING_LIQUIDS_OR_FALLING_BLOCKS));
        }
        if (!ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.FEATURE, new ResourceLocation("world_blender:separate_lava_and_water"))) {
            world_blender_biomes.forEach(blendedBiome -> ((List)blendedBiome.func_242440_e().func_242498_c().get(GenerationStage.Decoration.LOCAL_MODIFICATIONS.ordinal())).add(() -> WBConfiguredFeatures.SEPARATE_LAVA_AND_WATER));
        }
    }

    private static void makeBiomeMutable(Biome biome) {
        List<List<Supplier<ConfiguredFeature<?, ?>>>> tempFeature = ((GenerationSettingsAccessor)biome.func_242440_e()).getGSFeatures();
        ArrayList mutableGenerationStages = new ArrayList();
        for (int currentStageIndex = 0; currentStageIndex < Math.max(GenerationStage.Decoration.values().length, tempFeature.size()); ++currentStageIndex) {
            if (currentStageIndex >= tempFeature.size()) {
                mutableGenerationStages.add(new ArrayList());
                continue;
            }
            mutableGenerationStages.add(new ArrayList(tempFeature.get(currentStageIndex)));
        }
        ((GenerationSettingsAccessor)biome.func_242440_e()).setGSFeatures(mutableGenerationStages);
        ((GenerationSettingsAccessor)biome.func_242440_e()).setGSStructureFeatures(new ArrayList(((GenerationSettingsAccessor)biome.func_242440_e()).getGSStructureFeatures()));
        ((GenerationSettingsAccessor)biome.func_242440_e()).setGSStructureFeatures(new ArrayList(((GenerationSettingsAccessor)biome.func_242440_e()).getGSStructureFeatures()));
        ((GenerationSettingsAccessor)biome.func_242440_e()).setCarvers(new HashMap(((GenerationSettingsAccessor)biome.func_242440_e()).getCarvers()));
        for (GenerationStage.Carving carving : GenerationStage.Carving.values()) {
            ((GenerationSettingsAccessor)biome.func_242440_e()).getCarvers().put(carving, new ArrayList(biome.func_242440_e().func_242489_a(carving)));
        }
        ((MobSpawnInfoAccessor)biome.func_242433_b()).setSpawners(new HashMap<EntityClassification, List<MobSpawnInfo.Spawners>>(((MobSpawnInfoAccessor)biome.func_242433_b()).getSpawners()));
        for (GenerationStage.Carving carving : EntityClassification.values()) {
            ((MobSpawnInfoAccessor)biome.func_242433_b()).getSpawners().put((EntityClassification)carving, new ArrayList(biome.func_242433_b().func_242559_a((EntityClassification)carving)));
        }
        ((MobSpawnInfoAccessor)biome.func_242433_b()).setSpawnCosts(new HashMap(((MobSpawnInfoAccessor)biome.func_242433_b()).getSpawnCosts()));
    }

    private static void addBiomeFeatures(Biome biome, List<Biome> world_blender_biomes, MutableRegistry<ConfiguredFeature<?, ?>> configuredFeaturesRegistry) {
        for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
            if (stage.ordinal() >= biome.func_242440_e().func_242498_c().size()) break;
            for (Supplier configuredFeatureSupplier : (List)biome.func_242440_e().func_242498_c().get(stage.ordinal())) {
                ConfiguredFeature configuredFeature = (ConfiguredFeature)configuredFeatureSupplier.get();
                if (!((List)world_blender_biomes.get(0).func_242440_e().func_242498_c().get(stage.ordinal())).stream().noneMatch(arg_0 -> TheBlender.lambda$addBiomeFeatures$12((Supplier)configuredFeatureSupplier, arg_0))) continue;
                ResourceLocation configuredFeatureID = configuredFeaturesRegistry.func_177774_c((Object)configuredFeature);
                if (configuredFeatureID == null) {
                    configuredFeatureID = WorldGenRegistries.field_243653_e.func_177774_c((Object)configuredFeature);
                }
                if (configuredFeatureID == null) {
                    Optional configuredFeatureJSON = ConfiguredFeature.field_236264_b_.encode((Object)configuredFeatureSupplier, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).get().left();
                    configuredFeatureJSON.ifPresent(json -> TheBlender.extractModNames(json.toString()));
                    continue;
                }
                if (ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.FEATURE, configuredFeatureID)) continue;
                if (configuredFeatureID.func_110624_b().equals("minecraft")) {
                    if (!WorldBlender.WBBlendingConfig.allowVanillaFeatures.get().booleanValue() || FeatureGrouping.checksAndAddSmallPlantFeatures(stage, configuredFeature) || FeatureGrouping.isLaggyFeature(configuredFeature) && WorldBlender.WBBlendingConfig.disallowLaggyFeatures.get().booleanValue()) continue;
                    world_blender_biomes.forEach(arg_0 -> TheBlender.lambda$addBiomeFeatures$14(stage, (Supplier)configuredFeatureSupplier, arg_0));
                    continue;
                }
                if (!WorldBlender.WBBlendingConfig.allowModdedFeatures.get().booleanValue()) continue;
                if (!FeatureGrouping.checksAndAddSmallPlantFeatures(stage, configuredFeature) && FeatureGrouping.checksAndAddLargePlantFeatures(stage, configuredFeature)) {
                    world_blender_biomes.forEach(arg_0 -> TheBlender.lambda$addBiomeFeatures$15(stage, (Supplier)configuredFeatureSupplier, arg_0));
                    continue;
                }
                if (FeatureGrouping.isLaggyFeature(configuredFeature) && WorldBlender.WBBlendingConfig.disallowLaggyFeatures.get().booleanValue()) continue;
                world_blender_biomes.forEach(arg_0 -> TheBlender.lambda$addBiomeFeatures$16(stage, (Supplier)configuredFeatureSupplier, arg_0));
            }
        }
    }

    private static void addBiomeStructures(Biome biome, List<Biome> world_blender_biomes, MutableRegistry<StructureFeature<?, ?>> configuredStructuresRegistry) {
        for (Supplier configuredStructureSupplier : biome.func_242440_e().func_242487_a()) {
            StructureFeature configuredStructure = (StructureFeature)configuredStructureSupplier.get();
            if (!world_blender_biomes.get(0).func_242440_e().func_242487_a().stream().noneMatch(addedConfiguredStructure -> ((StructureFeature)addedConfiguredStructure.get()).field_236268_b_ == configuredStructure.field_236268_b_)) continue;
            ResourceLocation configuredStructureID = configuredStructuresRegistry.func_177774_c((Object)configuredStructure);
            if (configuredStructureID == null) {
                configuredStructureID = WorldGenRegistries.field_243654_f.func_177774_c((Object)configuredStructure);
            }
            if (configuredStructureID == null) {
                Optional configuredStructureJSON = StructureFeature.field_236267_a_.encode((Object)configuredStructure, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).get().left();
                configuredStructureJSON.ifPresent(json -> TheBlender.extractModNames(json.toString()));
                continue;
            }
            if (ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.STRUCTURE, configuredStructureID)) continue;
            if (configuredStructureID.func_110624_b().equals("minecraft")) {
                if (!WorldBlender.WBBlendingConfig.allowVanillaStructures.get().booleanValue()) continue;
                world_blender_biomes.forEach(arg_0 -> TheBlender.lambda$addBiomeStructures$19((Supplier)configuredStructureSupplier, arg_0));
                continue;
            }
            if (!WorldBlender.WBBlendingConfig.allowModdedStructures.get().booleanValue()) continue;
            world_blender_biomes.forEach(arg_0 -> TheBlender.lambda$addBiomeStructures$20((Supplier)configuredStructureSupplier, arg_0));
        }
    }

    private static void addBiomeCarvers(Biome biome, List<Biome> world_blender_biomes, MutableRegistry<ConfiguredCarver<?>> configuredCarversRegistry) {
        for (GenerationStage.Carving carverStage : GenerationStage.Carving.values()) {
            for (Supplier configuredCarverSupplier : biome.func_242440_e().func_242489_a(carverStage)) {
                ConfiguredCarver configuredCarver = (ConfiguredCarver)configuredCarverSupplier.get();
                if (!world_blender_biomes.get(0).func_242440_e().func_242489_a(carverStage).stream().noneMatch(addedConfiguredCarver -> addedConfiguredCarver.get() == configuredCarver)) continue;
                ResourceLocation configuredCarverID = configuredCarversRegistry.func_177774_c((Object)configuredCarver);
                if (configuredCarverID == null) {
                    configuredCarverID = WorldGenRegistries.field_243652_d.func_177774_c((Object)configuredCarver);
                }
                if (configuredCarverID == null) {
                    Optional configuredCarverJSON = ConfiguredCarver.field_236235_a_.encode((Object)configuredCarver, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).get().left();
                    configuredCarverJSON.ifPresent(json -> TheBlender.extractModNames(json.toString()));
                    continue;
                }
                if (ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.CARVER, configuredCarverID)) continue;
                if (configuredCarverID.func_110624_b().equals("minecraft")) {
                    if (!WorldBlender.WBBlendingConfig.allowVanillaCarvers.get().booleanValue()) continue;
                    world_blender_biomes.forEach(arg_0 -> TheBlender.lambda$addBiomeCarvers$23(carverStage, (Supplier)configuredCarverSupplier, arg_0));
                    continue;
                }
                if (!WorldBlender.WBBlendingConfig.allowModdedCarvers.get().booleanValue()) continue;
                world_blender_biomes.forEach(arg_0 -> TheBlender.lambda$addBiomeCarvers$24(carverStage, (Supplier)configuredCarverSupplier, arg_0));
            }
        }
    }

    private static void addBiomeNaturalMobs(Biome biome, List<Biome> world_blender_biomes) {
        for (EntityClassification spawnGroup : EntityClassification.values()) {
            for (MobSpawnInfo.Spawners spawnEntry : biome.func_242433_b().func_242559_a(spawnGroup)) {
                ResourceLocation entityTypeID;
                if (!world_blender_biomes.get(0).func_242433_b().func_242559_a(spawnGroup).stream().noneMatch(spawn -> spawn.field_242588_c == spawnEntry.field_242588_c) || ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.SPAWN, entityTypeID = Registry.field_212629_r.func_177774_c((Object)spawnEntry.field_242588_c))) continue;
                if (entityTypeID.func_110624_b().equals("minecraft")) {
                    if (!WorldBlender.WBBlendingConfig.allowVanillaSpawns.get().booleanValue()) continue;
                    world_blender_biomes.forEach(blendedBiome -> blendedBiome.func_242433_b().func_242559_a(spawnGroup).add(spawnEntry));
                    continue;
                }
                if (!WorldBlender.WBBlendingConfig.allowModdedSpawns.get().booleanValue()) continue;
                world_blender_biomes.forEach(blendedBiome -> blendedBiome.func_242433_b().func_242559_a(spawnGroup).add(spawnEntry));
            }
        }
    }

    private static void addBiomeSurfaceConfig(Biome biome, ResourceLocation biomeID) {
        if (biomeID.func_110624_b().equals("minecraft") ? WorldBlender.WBBlendingConfig.allowVanillaSurfaces.get() == false : WorldBlender.WBBlendingConfig.allowModdedSurfaces.get() == false) {
            return;
        }
        if (biome.func_242440_e().func_242502_e() instanceof SurfaceBuilderConfig) {
            SurfaceBuilderConfig surfaceConfig = (SurfaceBuilderConfig)biome.func_242440_e().func_242502_e();
            if (ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.SURFACE_BLOCK, Registry.field_212618_g.func_177774_c((Object)surfaceConfig.func_204108_a().func_177230_c()))) {
                return;
            }
            if (!((BlendedSurfaceBuilder)WBSurfaceBuilders.BLENDED_SURFACE_BUILDER).containsConfig(surfaceConfig)) {
                ((BlendedSurfaceBuilder)WBSurfaceBuilders.BLENDED_SURFACE_BUILDER).addConfig(surfaceConfig);
            }
        } else {
            ISurfaceBuilderConfig surfaceConfig = biome.func_242440_e().func_242502_e();
            if (ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.SURFACE_BLOCK, Registry.field_212618_g.func_177774_c((Object)surfaceConfig.func_204108_a().func_177230_c()))) {
                return;
            }
            if (!((BlendedSurfaceBuilder)WBSurfaceBuilders.BLENDED_SURFACE_BUILDER).containsConfig(surfaceConfig)) {
                ((BlendedSurfaceBuilder)WBSurfaceBuilders.BLENDED_SURFACE_BUILDER).addConfig(surfaceConfig);
            }
        }
    }

    public static void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            tempMap.putAll(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            ServerWorld wbServerWorld = serverWorld.func_73046_m().func_71218_a(WBIdentifiers.WB_WORLD_KEY);
            if (wbServerWorld != null) {
                tempMap.putAll(wbServerWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
                tempMap.values().removeIf(Objects::isNull);
                ((DimensionStructureSettingsAccessor)wbServerWorld.func_72863_F().field_186029_c.func_235957_b_()).setStructureConfigMap(tempMap);
                tempMap = new HashMap();
            }
        }
    }

    private static /* synthetic */ void lambda$addBiomeCarvers$24(GenerationStage.Carving carverStage, Supplier configuredCarverSupplier, Biome blendedBiome) {
        blendedBiome.func_242440_e().func_242489_a(carverStage).add(configuredCarverSupplier);
    }

    private static /* synthetic */ void lambda$addBiomeCarvers$23(GenerationStage.Carving carverStage, Supplier configuredCarverSupplier, Biome blendedBiome) {
        blendedBiome.func_242440_e().func_242489_a(carverStage).add(configuredCarverSupplier);
    }

    private static /* synthetic */ void lambda$addBiomeStructures$20(Supplier configuredStructureSupplier, Biome blendedBiome) {
        blendedBiome.func_242440_e().func_242487_a().add(configuredStructureSupplier);
    }

    private static /* synthetic */ void lambda$addBiomeStructures$19(Supplier configuredStructureSupplier, Biome blendedBiome) {
        blendedBiome.func_242440_e().func_242487_a().add(configuredStructureSupplier);
    }

    private static /* synthetic */ void lambda$addBiomeFeatures$16(GenerationStage.Decoration stage, Supplier configuredFeatureSupplier, Biome blendedBiome) {
        ((List)blendedBiome.func_242440_e().func_242498_c().get(stage.ordinal())).add(configuredFeatureSupplier);
    }

    private static /* synthetic */ void lambda$addBiomeFeatures$15(GenerationStage.Decoration stage, Supplier configuredFeatureSupplier, Biome blendedBiome) {
        ((List)blendedBiome.func_242440_e().func_242498_c().get(stage.ordinal())).add(0, configuredFeatureSupplier);
    }

    private static /* synthetic */ void lambda$addBiomeFeatures$14(GenerationStage.Decoration stage, Supplier configuredFeatureSupplier, Biome blendedBiome) {
        ((List)blendedBiome.func_242440_e().func_242498_c().get(stage.ordinal())).add(configuredFeatureSupplier);
    }

    private static /* synthetic */ boolean lambda$addBiomeFeatures$12(Supplier configuredFeatureSupplier, Supplier addedConfigFeature) {
        return FeatureGrouping.serializeAndCompareFeature((ConfiguredFeature)addedConfigFeature.get(), (ConfiguredFeature)configuredFeatureSupplier.get(), true);
    }
}

