/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders;

import com.endertech.minecraft.forge.client.ItemModel;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.mods.adfinders.finder.BuiltInModel;
import com.endertech.minecraft.mods.adfinders.finder.FinderState;
import com.endertech.minecraft.mods.adfinders.init.FinderType;
import com.endertech.minecraft.mods.adfinders.init.Targets;
import com.endertech.minecraft.mods.adfinders.items.Finder;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.common.Mod;

@Mod(value="adfinders")
public class AdFinders
extends ForgeMod {
    public static final String ID = "adfinders";
    public static final String NAME = "Advanced Finders";
    private static AdFinders instance;

    public static ForgeMod getInstance() {
        return instance;
    }

    public AdFinders() {
        instance = this;
    }

    public String getId() {
        return ID;
    }

    public void commonInit() {
        this.registerNetMessage(FinderState.UpdateMsg::new);
        this.registerNetMessage(Finder.SyncClientMsg::new);
    }

    public void commonPostInit() {
        Targets.initAll();
        for (FinderType type : FinderType.values()) {
            type.definitions.syncWithConfigs();
            type.finder.syncTargetsWith(type.definitions.toArray());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
        DeferredWorkQueue.runLater(() -> {
            for (FinderType type : FinderType.values()) {
                ItemModelsProperties.func_239418_a_((Item)type.finder, (ResourceLocation)this.toResLoc("broken"), (stack, world, entity) -> ForgeItem.isBroken((ItemStack)stack) ? 1.0f : 0.0f);
                ItemModelsProperties.func_239418_a_((Item)type.finder, (ResourceLocation)this.toResLoc("alarmed"), (stack, world, entity) -> Finder.findStateFor(stack).map(state -> ForgeItem.notBroken((ItemStack)stack) && state.isDepositFound() ? 1 : 0).orElse(0).intValue());
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientReplaceModels(ItemModel.RegistryWrapper registry) {
        for (FinderType type : FinderType.values()) {
            IBakedModel original = registry.getModelOf((Item)type.finder);
            registry.replaceModelOf((Item)type.finder, (IBakedModel)new BuiltInModel(original));
        }
    }

    public void commonConfigInit(ForgeMod.ConfigValueBuilder value) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientConfigInit(ForgeMod.ConfigValueBuilder value) {
    }

    public void registerBlocks() {
    }

    public void registerItems() {
        for (FinderType type : FinderType.values()) {
            this.registerItem((Item)type.finder);
        }
    }

    public void registerEntities() {
    }

    public void registerTiles() {
    }
}

