/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.common.CommonPath;
import com.endertech.common.CommonString;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adfinders.AdFinders;
import com.endertech.minecraft.mods.adfinders.finder.Ore;
import com.endertech.minecraft.mods.adfinders.finder.Target;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;

public class Definitions {
    private static final String NAME_ORE = "ore";
    private static final String DEFAULT_DELIMITER = "_";
    private final String finderName;
    private String modId;
    private String delimiter;
    private int defaultMeta;
    private final List<String> prefixes = new ArrayList<String>();
    private final List<String> suffixes = new ArrayList<String>();
    private final Map<String, List<String>> definitions = new HashMap<String, List<String>>();

    public Definitions(String finderName) {
        this.finderName = finderName;
        this.forMod("minecraft");
    }

    public Definitions forMod(String modId) {
        this.modId = modId;
        this.delimiter = DEFAULT_DELIMITER;
        this.defaultMeta = 0;
        this.clearPrefixes();
        this.clearSuffixes();
        this.createAbsentDefList(modId);
        return this;
    }

    protected Definitions clearPrefixes() {
        this.prefixes.clear();
        return this;
    }

    protected Definitions clearSuffixes() {
        this.suffixes.clear();
        return this;
    }

    private static String properModId(String modId) {
        return CommonPath.replaceReservedCharsWith((String)modId, (String)DEFAULT_DELIMITER);
    }

    @Nullable
    private List<String> getDefinitionsList(String modId) {
        return this.definitions.get(Definitions.properModId(modId));
    }

    private void putDefinitionsList(String modId, List<String> list) {
        this.definitions.put(Definitions.properModId(modId), list);
    }

    private void createAbsentDefList(String modId) {
        if (this.getDefinitionsList(modId) == null) {
            this.putDefinitionsList(modId, new ArrayList<String>());
        }
    }

    public Definitions withPrefixes(String ... prefixes) {
        this.clearPrefixes();
        for (String prefix : prefixes) {
            this.prefixes.add(prefix);
        }
        return this;
    }

    public Definitions withSuffixes(String ... suffixes) {
        this.clearSuffixes();
        for (String suffix : suffixes) {
            this.suffixes.add(suffix);
        }
        return this;
    }

    public Definitions withOrePrefix() {
        return this.withPrefixes(NAME_ORE);
    }

    public Definitions withOreSuffix() {
        return this.withSuffixes(NAME_ORE);
    }

    public Definitions withDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public Definitions withNoDelimiters() {
        this.delimiter = "";
        return this;
    }

    public Definitions withMetaAll() {
        this.defaultMeta = Short.MAX_VALUE;
        return this;
    }

    public Definitions withDefaultMeta() {
        this.defaultMeta = 0;
        return this;
    }

    public Definitions addOre(String regName, int argb) {
        Ore ore = new Ore(regName, argb);
        return this.addOre(ore);
    }

    public Definitions addOre(Ore ore) {
        return this.addOre(ore.getName(), ore);
    }

    public Definitions addOre(String regName, Ore ore) {
        return this.addOre(regName, this.defaultMeta, ore);
    }

    public Definitions addOre(int meta, Ore ore) {
        return this.addOre(ore.getName(), meta, ore);
    }

    public Definitions addOre(String regName, int meta, Ore ore) {
        return this.addOre(regName, meta, ore.getARGB(), ore.getName());
    }

    public Definitions addOres(Ore ... ores) {
        for (Ore ore : ores) {
            this.addOre(this.defaultMeta, ore);
        }
        return this;
    }

    protected Definitions addOre(String regName, int meta, int colorARGB, String targetName) {
        ColorARGB color = ColorARGB.from((int)colorARGB);
        if (this.prefixes.isEmpty()) {
            this.prefixes.add("");
        }
        if (this.suffixes.isEmpty()) {
            this.suffixes.add("");
        }
        List<String> list = this.getDefinitionsList(this.modId);
        for (String prefix : this.prefixes) {
            for (String suffix : this.suffixes) {
                list.add(this.definition(prefix, regName, suffix, meta, color, targetName));
            }
        }
        return this;
    }

    public void syncWithConfigs() {
        String modId;
        Path configsDir = AdFinders.getInstance().getConfigsDir().resolve(Folders.TARGETS.toString());
        for (Path path : UnitConfig.listCustomConfigs((Path)configsDir, null)) {
            modId = CommonPath.getFileNameOnly((Path)path);
            this.createAbsentDefList(modId);
        }
        for (Map.Entry entry : this.definitions.entrySet()) {
            modId = (String)entry.getKey();
            List defList = (List)entry.getValue();
            UnitConfig config = UnitConfig.in((Path)configsDir, (String)modId);
            String[] defArray = UnitConfig.getStrArray((UnitConfig)config, (String)this.finderName, (String)"targets", (String[])defList.toArray(new String[0]), (String)"List of all blocks the finder should be looking for.\nThe format is <unitId>, <colorARGB> [, <groupName>]\n\nId is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too if it equals 0.\nUnitName must be lowercase, words separated by '_', words order - from private to common (example: black_iron_ore).\nUse '*' char or '[]' as meta value to specify all possible values (all block states).\nTo define multiple block states, you can use block properties. The format is <modId:blockName:[prop1=value1, prop2=value2]>\nAlso you may use tags. The format is <#modId:tagPath> (example: #forge:ores/copper \n\nColor in ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb)\n\nGroup name is necessary for having one needle for each ore group(one needle for all copper ores, one for all gold ores, etc.)\nIf not set then unitName will be used.\n");
            config.save();
            defList.clear();
            for (String definition : defArray) {
                defList.add(definition);
            }
        }
    }

    public String[] toArray() {
        ArrayList<String> allDefList = new ArrayList<String>();
        for (List<String> defList : this.definitions.values()) {
            allDefList.addAll(defList);
        }
        return allDefList.toArray(new String[0]);
    }

    private String definition(String namePrefix, String regName, String nameSuffix, int meta, ColorARGB color, String targetName) {
        String unitName = UnitId.joinWords((String)this.delimiter, (String[])new String[]{namePrefix, regName, nameSuffix});
        UnitId blockId = UnitId.from((String)this.modId, (String)unitName, (int)meta);
        return Target.definition(blockId, color, targetName);
    }

    public static class Suffixes {
        private final List<String> suffixes = new ArrayList<String>();

        public static Prefixes create() {
            return new Prefixes();
        }

        public Suffixes add(String ... words) {
            String suffix = UnitId.buildRegName((String[])words);
            this.suffixes.add(suffix);
            return this;
        }

        public String[] toArray() {
            return this.suffixes.toArray(new String[0]);
        }
    }

    public static class Prefixes {
        private final List<String> prefixes = new ArrayList<String>();

        public static Prefixes create() {
            return new Prefixes();
        }

        public Prefixes add(String ... words) {
            String prefix = UnitId.buildRegName((String[])words);
            this.prefixes.add(prefix);
            return this;
        }

        public String[] toArray() {
            return this.prefixes.toArray(new String[0]);
        }
    }

    public static enum Folders {
        TARGETS,
        DEFAULT,
        USER;


        public String toString() {
            return CommonString.capitalizeFirstChar((String)this.name().toLowerCase(Locale.ROOT));
        }
    }
}

