/*
 * Decompiled with CFR 0.152.
 */
package clevernucleus.adiectamateria.common.world;

import clevernucleus.adiectamateria.common.init.Registry;
import clevernucleus.adiectamateria.common.util.ConfigSetting;
import clevernucleus.adiectamateria.common.util.Dual;
import clevernucleus.adiectamateria.common.util.Util;
import java.util.Collection;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="adiectamateria", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GenerationRegistry {
    private static final Collection<ResourceLocation> SALT_BIOMES = Util.set(var -> {
        var.add(new ResourceLocation("ocean"));
        var.add(new ResourceLocation("deep_cold_ocean"));
        var.add(new ResourceLocation("deep_frozen_ocean"));
        var.add(new ResourceLocation("deep_lukewarm_ocean"));
        var.add(new ResourceLocation("deep_ocean"));
        var.add(new ResourceLocation("deep_warm_ocean"));
        var.add(new ResourceLocation("desert"));
        var.add(new ResourceLocation("desert_hills"));
        var.add(new ResourceLocation("frozen_ocean"));
        var.add(new ResourceLocation("lukewarm_ocean"));
        var.add(new ResourceLocation("ocean"));
        var.add(new ResourceLocation("warm_ocean"));
    });
    private static final Dual<GenerationStage.Decoration, ConfiguredFeature<?, ?>> SALT_GEN = Dual.get(() -> {
        OreFeatureConfig var0 = new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, Registry.SALTPETER_ORE.func_176223_P(), 15);
        TopSolidRangeConfig var1 = new TopSolidRangeConfig(5, 0, 55);
        ConfiguredFeature var2 = (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)var0).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)var1)).func_242728_a()).func_242731_b(15);
        return Dual.make(GenerationStage.Decoration.UNDERGROUND_ORES, var2);
    });
    private static final Dual<GenerationStage.Decoration, ConfiguredFeature<?, ?>> ENDSTONE_GEN = Dual.get(() -> {
        OreFeatureConfig var0 = new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, Blocks.field_150377_bs.func_176223_P(), 10);
        TopSolidRangeConfig var1 = new TopSolidRangeConfig(1, 0, 25);
        ConfiguredFeature var2 = (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)var0).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)var1)).func_242728_a()).func_242731_b(10);
        return Dual.make(GenerationStage.Decoration.UNDERGROUND_ORES, var2);
    });

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void registerBiomeFeatures(BiomeLoadingEvent par0) {
        if (((Boolean)ConfigSetting.CONFIG.genSaltpeter.get()).booleanValue() && SALT_BIOMES.contains(par0.getName())) {
            par0.getGeneration().getFeatures(SALT_GEN.a()).add(() -> SALT_GEN.b());
        }
        if (((Boolean)ConfigSetting.CONFIG.genEndstone.get()).booleanValue()) {
            par0.getGeneration().getFeatures(ENDSTONE_GEN.a()).add(() -> ENDSTONE_GEN.b());
        }
    }
}

