/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.advancedtools.crafting;

import de.maxhenkel.advancedtools.Main;
import de.maxhenkel.advancedtools.ModItems;
import de.maxhenkel.advancedtools.crafting.RecipeHelper;
import de.maxhenkel.advancedtools.items.enchantments.ItemEnchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.BookItem;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RecipeConvertEnchantment
extends SpecialRecipe {
    private RecipeHelper.RecipeIngredient[] ingredients = new RecipeHelper.RecipeIngredient[]{new RecipeHelper.RecipeIngredient(ItemEnchantment.class, 1), new RecipeHelper.RecipeIngredient(BookItem.class, 1)};

    public RecipeConvertEnchantment(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        return RecipeHelper.matchesRecipe(inv, this.ingredients);
    }

    public ItemStack assemble(CraftingInventory inv) {
        return this.doCrafting(inv);
    }

    public ItemStack doCrafting(CraftingInventory inv) {
        ItemStack book = null;
        ItemStack enchantment = null;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_77973_b() instanceof BookItem) {
                if (book != null) {
                    return null;
                }
                book = stack;
                continue;
            }
            if (stack.func_77973_b() instanceof ItemEnchantment) {
                if (enchantment != null) {
                    return null;
                }
                enchantment = stack;
                continue;
            }
            if (stack.func_190926_b()) continue;
            return null;
        }
        if (book == null || enchantment == null) {
            return null;
        }
        ItemStack retStack = new ItemStack((IItemProvider)Items.field_151134_bR);
        EnchantmentData data = ModItems.ENCHANTMENT.getEnchantment(enchantment);
        if (data == null) {
            return ItemStack.field_190927_a;
        }
        EnchantedBookItem.func_92115_a((ItemStack)retStack, (EnchantmentData)data);
        return retStack;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)Items.field_151134_bR);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Main.CRAFTING_CONVERT_ENCHANTMENT;
    }
}

