/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.advancedtools.crafting;

import de.maxhenkel.advancedtools.Main;
import de.maxhenkel.advancedtools.ModItems;
import de.maxhenkel.advancedtools.crafting.RecipeHelper;
import de.maxhenkel.advancedtools.items.enchantments.ItemEnchantment;
import de.maxhenkel.advancedtools.items.enchantments.ItemPliers;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RecipeCutEnchantment
extends SpecialRecipe {
    private RecipeHelper.RecipeIngredient[] ingredients = new RecipeHelper.RecipeIngredient[]{new RecipeHelper.RecipeIngredient(ItemPliers.class, 1), new RecipeHelper.RecipeIngredient(ItemEnchantment.class, 1)};

    public RecipeCutEnchantment(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        return RecipeHelper.matchesRecipe(inv, this.ingredients);
    }

    public ItemStack assemble(CraftingInventory inv) {
        RecipeResult res = this.doCrafting(inv);
        if (res == null) {
            return ItemStack.field_190927_a;
        }
        return res.result;
    }

    private RecipeResult doCrafting(CraftingInventory inv) {
        ItemStack plier = null;
        ItemStack enchantment = null;
        int plierSlot = -1;
        int enchantmentSlot = -1;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_77973_b() == ModItems.PLIER) {
                if (plier != null) {
                    return null;
                }
                plier = stack;
                plierSlot = i;
                continue;
            }
            if (stack.func_77973_b() instanceof ItemEnchantment) {
                if (enchantment != null) {
                    return null;
                }
                enchantment = stack;
                enchantmentSlot = i;
                continue;
            }
            if (stack.func_190926_b()) continue;
            return null;
        }
        if (plier == null || enchantment == null) {
            return null;
        }
        NonNullList list = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (plier.func_77958_k() - plier.func_77952_i() > 1) {
            ItemStack p = plier.func_77946_l();
            p.func_196085_b(p.func_77952_i() + 1);
            list.set(plierSlot, (Object)p);
        }
        EnchantmentData en = ModItems.ENCHANTMENT.getEnchantment(enchantment);
        ItemStack result = new ItemStack((IItemProvider)ModItems.BROKEN_ENCHANTMENT, 2);
        if (en != null) {
            ModItems.ENCHANTMENT.setEnchantment(result, en.field_76302_b, en.field_76303_c);
        }
        RecipeResult recipeResult = new RecipeResult();
        recipeResult.remaining = list;
        recipeResult.result = result;
        return recipeResult;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        RecipeResult res = this.doCrafting(inv);
        if (res == null) {
            return NonNullList.func_191196_a();
        }
        return res.remaining;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Main.CRAFTING_CUT_ENCHANTMENT;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    class RecipeResult {
        private NonNullList<ItemStack> remaining;
        private ItemStack result;

        RecipeResult() {
        }
    }
}

