/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.advancedtools.crafting;

import de.maxhenkel.advancedtools.Main;
import de.maxhenkel.advancedtools.ModItems;
import de.maxhenkel.advancedtools.crafting.RecipeHelper;
import de.maxhenkel.advancedtools.items.enchantments.ItemEnchantmentRemover;
import de.maxhenkel.advancedtools.items.tools.AbstractTool;
import de.maxhenkel.advancedtools.items.tools.EnchantmentTools;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RecipeRemoveEnchantment
extends SpecialRecipe {
    private RecipeHelper.RecipeIngredient[] ingredients = new RecipeHelper.RecipeIngredient[]{new RecipeHelper.RecipeIngredient(ItemEnchantmentRemover.class, 1), new RecipeHelper.RecipeIngredient(AbstractTool.class, 1)};

    public RecipeRemoveEnchantment(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        return RecipeHelper.matchesRecipe(inv, this.ingredients);
    }

    public ItemStack assemble(CraftingInventory inv) {
        RecipeResult res = this.doCrafting(inv);
        if (res == null) {
            return ItemStack.field_190927_a;
        }
        return res.result;
    }

    private RecipeResult doCrafting(CraftingInventory inv) {
        ItemStack result;
        ItemStack tool = null;
        ItemStack enchantment = null;
        int toolSlot = -1;
        int removerSlot = -1;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_77973_b() instanceof AbstractTool) {
                if (tool != null) {
                    return null;
                }
                tool = stack;
                toolSlot = i;
                continue;
            }
            if (stack.func_77973_b() instanceof ItemEnchantmentRemover) {
                if (enchantment != null) {
                    return null;
                }
                enchantment = stack;
                removerSlot = i;
                continue;
            }
            if (stack.func_190926_b()) continue;
            return null;
        }
        if (tool == null || enchantment == null) {
            return null;
        }
        NonNullList list = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        list.set(removerSlot, (Object)enchantment.func_77946_l());
        Enchantment en = ModItems.ENCHANTMENT_REMOVER.getEnchantment(enchantment);
        if (en != null) {
            ItemStack e = new ItemStack((IItemProvider)ModItems.ENCHANTMENT);
            for (EnchantmentData data : EnchantmentTools.getEnchantments(tool)) {
                if (!data.field_76302_b.equals(en)) continue;
                ModItems.ENCHANTMENT.setEnchantment(e, en, data.field_76303_c);
                list.set(toolSlot, (Object)e);
                break;
            }
        }
        if ((result = ((AbstractTool)tool.func_77973_b()).removeEnchantment(tool, enchantment)).equals(ItemStack.field_190927_a)) {
            return null;
        }
        RecipeResult recipeResult = new RecipeResult();
        recipeResult.remaining = list;
        recipeResult.result = result;
        return recipeResult;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        RecipeResult res = this.doCrafting(inv);
        if (res == null) {
            return NonNullList.func_191196_a();
        }
        return res.remaining;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Main.CRAFTING_EREMOVE_ENCHANTMENT;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    class RecipeResult {
        private NonNullList<ItemStack> remaining;
        private ItemStack result;

        RecipeResult() {
        }
    }
}

