/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.advancedtools.crafting;

import de.maxhenkel.advancedtools.Main;
import de.maxhenkel.advancedtools.crafting.RecipeHelper;
import de.maxhenkel.advancedtools.items.enchantments.ItemEnchantment;
import de.maxhenkel.advancedtools.items.tools.EnchantmentTools;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RecipeSplitEnchantments
extends SpecialRecipe {
    private RecipeHelper.RecipeIngredient[] ingredients = new RecipeHelper.RecipeIngredient[]{new RecipeHelper.RecipeIngredient(ItemEnchantment.class, 1)};

    public RecipeSplitEnchantments(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        return RecipeHelper.matchesRecipe(inv, this.ingredients);
    }

    public ItemStack assemble(CraftingInventory inv) {
        ItemStack[] result = this.getResult(inv);
        if (result == null) {
            return ItemStack.field_190927_a;
        }
        return result[0];
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        int index = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            index = i;
            break;
        }
        NonNullList items = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStack[] result = this.getResult(inv);
        if (result == null) {
            return items;
        }
        items.set(index, (Object)result[1]);
        return items;
    }

    private ItemStack[] getResult(CraftingInventory inv) {
        ItemStack enchantment = null;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_77973_b() instanceof ItemEnchantment) {
                if (enchantment != null) {
                    return null;
                }
                enchantment = stack;
                continue;
            }
            if (stack.func_190926_b()) continue;
            return null;
        }
        if (enchantment == null) {
            return null;
        }
        return EnchantmentTools.splitEnchantments(enchantment);
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Main.CRAFTING_SPLIT_ENCHANTMENTS;
    }
}

