/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.advancedtools.integration.jei.category.convert_enchantment;

import com.google.common.collect.ImmutableList;
import de.maxhenkel.advancedtools.ModItems;
import de.maxhenkel.advancedtools.integration.jei.JEIPlugin;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;

public class ConvertEnchantmentRecipeCategory
implements IRecipeCategory<EnchantmentData> {
    private IGuiHelper helper;

    public ConvertEnchantmentRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
    }

    public IDrawable getBackground() {
        return this.helper.createDrawable(new ResourceLocation("advancedtools", "textures/gui/jei_crafting.png"), 0, 0, 116, 54);
    }

    public IDrawable getIcon() {
        return this.helper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModItems.ENCHANTMENT));
    }

    public void setIngredients(EnchantmentData wrapper, IIngredients ingredients) {
        ItemStack enchantment = new ItemStack((IItemProvider)Items.field_151134_bR);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)enchantment);
        ItemStack ench = new ItemStack((IItemProvider)ModItems.ENCHANTMENT);
        ItemStack book = new ItemStack((IItemProvider)Items.field_151122_aG);
        ingredients.setInputs(VanillaTypes.ITEM, (List)ImmutableList.of((Object)ench, (Object)book));
    }

    public String getTitle() {
        return new TranslationTextComponent("jei.enchantment_converting").getString();
    }

    public ResourceLocation getUid() {
        return JEIPlugin.CATEGORY_ENCHANTMENT_CONVERTING;
    }

    public Class<? extends EnchantmentData> getRecipeClass() {
        return EnchantmentData.class;
    }

    public void setRecipe(IRecipeLayout layout, EnchantmentData wrapper, IIngredients ingredients) {
        IGuiItemStackGroup group = layout.getItemStacks();
        group.init(0, true, 0, 0);
        ItemStack stack = new ItemStack((IItemProvider)ModItems.ENCHANTMENT);
        ModItems.ENCHANTMENT.setEnchantment(stack, wrapper.field_76302_b, wrapper.field_76303_c);
        group.set(0, stack);
        group.init(1, true, 18, 0);
        group.set(1, new ItemStack((IItemProvider)Items.field_151122_aG));
        group.init(2, true, 36, 0);
        group.init(3, true, 0, 18);
        group.init(4, true, 18, 18);
        group.init(5, true, 36, 18);
        group.init(6, true, 0, 36);
        group.init(7, true, 18, 36);
        group.init(8, true, 36, 36);
        group.init(9, false, 94, 18);
        ItemStack stack1 = new ItemStack((IItemProvider)Items.field_151134_bR);
        EnchantedBookItem.func_92115_a((ItemStack)stack1, (EnchantmentData)wrapper);
        group.set(9, stack1);
    }
}

