/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.advancedtools.items.enchantments;

import de.maxhenkel.advancedtools.items.tools.StackUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class ItemEnchantmentBase
extends Item {
    public ItemEnchantmentBase() {
        super(new Item.Properties());
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        EnchantmentData data = this.getEnchantment(stack);
        if (data != null) {
            tooltip.add(data.field_76302_b.func_200305_d(data.field_76303_c));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public void setEnchantment(ItemStack stack, Enchantment enchantment, int level) {
        CompoundNBT compound = StackUtils.getStackCompound(stack);
        CompoundNBT ench = new CompoundNBT();
        ench.func_74768_a("level", level);
        ench.func_74778_a("name", enchantment.getRegistryName().toString());
        compound.func_218657_a("enchantment", (INBT)ench);
    }

    public EnchantmentData getEnchantment(ItemStack stack) {
        String name;
        String[] split;
        CompoundNBT compound = StackUtils.getStackCompound(stack);
        if (!compound.func_74764_b("enchantment")) {
            return null;
        }
        CompoundNBT ench = compound.func_74775_l("enchantment");
        if (!ench.func_74764_b("name")) {
            return null;
        }
        int level = 0;
        if (ench.func_74764_b("level")) {
            level = ench.func_74762_e("level");
        }
        if ((split = (name = ench.func_74779_i("name")).split(":")).length < 2) {
            return null;
        }
        return new EnchantmentData((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(split[0], split[1])), level);
    }
}

