/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.advancedtools.items.tools;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.maxhenkel.advancedtools.Main;
import de.maxhenkel.advancedtools.ModItems;
import de.maxhenkel.advancedtools.items.tools.AdvancedToolMaterial;
import de.maxhenkel.advancedtools.items.tools.EnchantmentTools;
import de.maxhenkel.advancedtools.items.tools.StackUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.ToolItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.DistExecutor;

public abstract class AbstractTool
extends ToolItem {
    public AbstractTool() {
        super(0.0f, 0.0f, (IItemTier)ItemTier.NETHERITE, null, new Item.Properties().func_200918_c(100));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::addVariants);
    }

    private void addVariants() {
        for (AdvancedToolMaterial material : AdvancedToolMaterial.getAll()) {
            ItemModelsProperties.func_239418_a_((Item)this, (ResourceLocation)new ResourceLocation("advancedtools", material.getName()), (itemStack, world, livingEntity) -> material.equals(StackUtils.getMaterial(itemStack)) ? 1.0f : 0.0f);
        }
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return Math.min(Math.max(this.getDurability(stack) - 1, 0), amount);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return this.isBroken(stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        Map<StackUtils.Stat, Integer> stats;
        Map enchantments;
        AdvancedToolMaterial mat;
        StackUtils.updateFlags(stack);
        if (this.isBroken(stack)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.broken").func_240699_a_(TextFormatting.DARK_RED));
        }
        if ((mat = StackUtils.getMaterial(stack)) != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.material", new Object[]{mat.getDisplayName().func_240699_a_(TextFormatting.DARK_GRAY)}).func_240699_a_(TextFormatting.GRAY));
            if (!flagIn.func_194127_a() && !this.isBroken(stack)) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.durability_left", new Object[]{new StringTextComponent(String.valueOf(this.getMaxDamage(stack) - stack.func_77952_i())).func_240699_a_(TextFormatting.DARK_GRAY)}).func_240699_a_(TextFormatting.GRAY));
            }
        }
        if (!(enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack)).isEmpty()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltips.enchantments").func_240699_a_(TextFormatting.GRAY));
            for (Map.Entry entry : enchantments.entrySet()) {
                tooltip.add((ITextComponent)new StringTextComponent("  - ").func_230529_a_((ITextComponent)((IFormattableTextComponent)((Enchantment)entry.getKey()).func_200305_d(((Integer)entry.getValue()).intValue())).func_240699_a_(TextFormatting.DARK_GRAY)).func_240699_a_(TextFormatting.GRAY));
            }
        }
        if (!(stats = StackUtils.getToolStats(stack)).isEmpty()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltips.stats").func_240699_a_(TextFormatting.GRAY));
            for (Map.Entry<StackUtils.Stat, Integer> entry : stats.entrySet()) {
                tooltip.add((ITextComponent)new StringTextComponent("  - ").func_230529_a_((ITextComponent)entry.getKey().getTranslation(new StringTextComponent(String.valueOf(entry.getValue())).func_240699_a_(TextFormatting.DARK_GRAY)).func_240699_a_(TextFormatting.GRAY)).func_240699_a_(TextFormatting.GRAY));
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean isFireResistant(ItemStack stack) {
        return StackUtils.getMaterial(stack).isFireResistant();
    }

    public abstract Set<ToolType> getToolTypes(ItemStack var1);

    public abstract float getAttackDamage(ItemStack var1);

    public abstract float getAttackSpeed(ItemStack var1);

    public abstract float getEfficiency(ItemStack var1);

    public abstract Set<Material> getEffectiveMaterials(ItemStack var1);

    public abstract int getHarvestLevel(ItemStack var1);

    public abstract String getPrimaryToolType();

    public abstract int getMaxDamage(ItemStack var1);

    public ITextComponent func_200295_i(ItemStack stack) {
        AdvancedToolMaterial mat = StackUtils.getMaterial(stack);
        if (mat != null) {
            return new StringTextComponent(mat.getDisplayName().getString() + " " + new TranslationTextComponent("tool." + this.getPrimaryToolType()).getString()).func_240699_a_(TextFormatting.WHITE);
        }
        return new TranslationTextComponent("tool." + this.getPrimaryToolType()).func_240699_a_(TextFormatting.WHITE);
    }

    public abstract int getRepairCost(ItemStack var1, AdvancedToolMaterial var2);

    public ItemStack repair(ItemStack in, AdvancedToolMaterial material, int count) {
        AdvancedToolMaterial currMat = StackUtils.getMaterial(in);
        if (currMat == null) {
            return ItemStack.field_190927_a;
        }
        int repairCost = this.getRepairCost(in, material);
        if (repairCost < 1) {
            repairCost = 1;
        }
        if (repairCost > 8) {
            repairCost = 8;
        }
        if (count > repairCost) {
            return ItemStack.field_190927_a;
        }
        if (currMat.equals(material)) {
            ItemStack newStack = in.func_77946_l();
            int maxDamage = this.getMaxDamage(newStack);
            int damageRev = newStack.func_77952_i();
            int repairPerCount = maxDamage / repairCost + 1;
            newStack.func_196085_b(damageRev - repairPerCount * count);
            return newStack;
        }
        if (count < repairCost) {
            return ItemStack.field_190927_a;
        }
        ItemStack newStack = in.func_77946_l();
        newStack.func_196085_b(0);
        return StackUtils.setMaterial(newStack, material);
    }

    public ItemStack applyEnchantment(ItemStack tool, ItemStack enchantment) {
        ItemStack newTool = tool.func_77946_l();
        EnchantmentData data = ModItems.ENCHANTMENT.getEnchantment(enchantment);
        if (data != null && data.field_76302_b.func_92089_a(tool)) {
            List<EnchantmentData> enchantments = EnchantmentTools.getEnchantments(newTool);
            EnchantmentHelper.func_185282_a(enchantments, (EnchantmentData)data);
            enchantments.add(data);
            EnchantmentTools.setEnchantments(enchantments, newTool);
            return newTool;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack removeEnchantment(ItemStack tool, ItemStack enchantmentRemover) {
        ItemStack newTool = tool.func_77946_l();
        Enchantment ench = ModItems.ENCHANTMENT_REMOVER.getEnchantment(enchantmentRemover);
        if (ench != null) {
            if (!ench.func_92089_a(tool)) {
                return ItemStack.field_190927_a;
            }
            List<EnchantmentData> enchantments = EnchantmentTools.getEnchantments(tool);
            enchantments.removeIf(data -> data.field_76302_b.equals(ench));
            EnchantmentTools.setEnchantments(enchantments, newTool);
            return newTool;
        }
        return ItemStack.field_190927_a;
    }

    public int getItemEnchantability(ItemStack stack) {
        return 0;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public boolean countBreakStats(ItemStack stack) {
        return true;
    }

    public boolean countHitStats(ItemStack stack) {
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlotType.MAINHAND && !this.isBroken(stack)) {
            multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.getAttackDamage(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.getAttackSpeed(stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        if (this.isBroken(stack)) {
            return 0.0f;
        }
        for (ToolType type : this.getToolTypes(stack)) {
            if (!state.func_177230_c().isToolEffective(state, type)) continue;
            return this.getEfficiency(stack);
        }
        return this.getEffectiveMaterials(stack).contains(state.func_185904_a()) ? this.getEfficiency(stack) : 1.0f;
    }

    public int getHarvestLevel(ItemStack stack, ToolType toolType, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        if (this.getToolTypes(stack).contains(toolType)) {
            return this.getHarvestLevel(stack);
        }
        return -1;
    }

    public boolean isBroken(ItemStack stack) {
        return this.getDurability(stack) <= 1;
    }

    public int getDurability(ItemStack stack) {
        return this.getMaxDamage(stack) - this.getDamage(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        int maxDamage = this.getMaxDamage(stack);
        if (damage > maxDamage) {
            return;
        }
        super.setDamage(stack, damage);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (((Boolean)Main.SERVER_CONFIG.toolItemsNeverDespawn.get()).booleanValue()) {
            entity.lifespan = Integer.MAX_VALUE;
        }
        if (((Boolean)Main.SERVER_CONFIG.toolItemsIndestructible.get()).booleanValue()) {
            entity.func_184224_h(true);
        }
        return false;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        boolean flag = super.func_179218_a(stack, worldIn, state, pos, entityLiving);
        if (flag && this.countBreakStats(stack)) {
            StackUtils.incrementToolStat(stack, StackUtils.Stat.STAT_BLOCKS_MINED, 1);
        }
        return flag;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        boolean flag = super.func_77644_a(stack, target, attacker);
        if (flag && this.countHitStats(stack)) {
            StackUtils.incrementToolStat(stack, StackUtils.Stat.STAT_MOBS_HIT, 1);
        }
        return flag;
    }

    public boolean canHarvestBlock(ItemStack stack, BlockState state) {
        for (ToolType type : this.getToolTypes(stack)) {
            if (!state.func_177230_c().isToolEffective(state, type)) continue;
            return true;
        }
        return super.canHarvestBlock(stack, state);
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }
}

